// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an association of a Amazon Web Services Systems Manager document (SSM document) and a managed node.
 */
class Association private constructor(builder: Builder) {
    /**
     * The ID created by the system when you create an association. An association is a binding
     * between a document and a set of targets with a schedule.
     */
    val associationId: kotlin.String? = builder.associationId
    /**
     * The association name.
     */
    val associationName: kotlin.String? = builder.associationName
    /**
     * The association version.
     */
    val associationVersion: kotlin.String? = builder.associationVersion
    /**
     * The version of the document used in the association.
     * State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the default version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to default.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The managed node ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The date on which the association was last run.
     */
    val lastExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastExecutionDate
    /**
     * The name of the SSM document.
     */
    val name: kotlin.String? = builder.name
    /**
     * Information about the association.
     */
    val overview: aws.sdk.kotlin.services.ssm.model.AssociationOverview? = builder.overview
    /**
     * A cron expression that specifies a schedule when the association runs. The schedule runs in
     * Coordinated Universal Time (UTC).
     */
    val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The managed nodes targeted by the request to create an association. You can target all
     * managed nodes in an Amazon Web Services account by specifying the InstanceIds key with a value of
     * *.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Association = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Association(")
        append("associationId=$associationId,")
        append("associationName=$associationName,")
        append("associationVersion=$associationVersion,")
        append("documentVersion=$documentVersion,")
        append("instanceId=$instanceId,")
        append("lastExecutionDate=$lastExecutionDate,")
        append("name=$name,")
        append("overview=$overview,")
        append("scheduleExpression=$scheduleExpression,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (associationName?.hashCode() ?: 0)
        result = 31 * result + (associationVersion?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (lastExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overview?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Association

        if (associationId != other.associationId) return false
        if (associationName != other.associationName) return false
        if (associationVersion != other.associationVersion) return false
        if (documentVersion != other.documentVersion) return false
        if (instanceId != other.instanceId) return false
        if (lastExecutionDate != other.lastExecutionDate) return false
        if (name != other.name) return false
        if (overview != other.overview) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Association = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID created by the system when you create an association. An association is a binding
         * between a document and a set of targets with a schedule.
         */
        var associationId: kotlin.String? = null
        /**
         * The association name.
         */
        var associationName: kotlin.String? = null
        /**
         * The association version.
         */
        var associationVersion: kotlin.String? = null
        /**
         * The version of the document used in the association.
         * State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the default version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to default.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The managed node ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * The date on which the association was last run.
         */
        var lastExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the SSM document.
         */
        var name: kotlin.String? = null
        /**
         * Information about the association.
         */
        var overview: aws.sdk.kotlin.services.ssm.model.AssociationOverview? = null
        /**
         * A cron expression that specifies a schedule when the association runs. The schedule runs in
         * Coordinated Universal Time (UTC).
         */
        var scheduleExpression: kotlin.String? = null
        /**
         * The managed nodes targeted by the request to create an association. You can target all
         * managed nodes in an Amazon Web Services account by specifying the InstanceIds key with a value of
         * *.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Association) : this() {
            this.associationId = x.associationId
            this.associationName = x.associationName
            this.associationVersion = x.associationVersion
            this.documentVersion = x.documentVersion
            this.instanceId = x.instanceId
            this.lastExecutionDate = x.lastExecutionDate
            this.name = x.name
            this.overview = x.overview
            this.scheduleExpression = x.scheduleExpression
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Association = Association(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AssociationOverview] inside the given [block]
         */
        fun overview(block: aws.sdk.kotlin.services.ssm.model.AssociationOverview.Builder.() -> kotlin.Unit) {
            this.overview = aws.sdk.kotlin.services.ssm.model.AssociationOverview.invoke(block)
        }
    }
}
