// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the parameters for a document.
 */
class AssociationDescription private constructor(builder: Builder) {
    /**
     * By default, when you create a new associations, the system runs it immediately after it is
     * created and then according to the schedule you specified. Specify this option if you don't want
     * an association to run immediately after you create it. This parameter isn't supported for rate
     * expressions.
     */
    val applyOnlyAtCronInterval: kotlin.Boolean = builder.applyOnlyAtCronInterval
    /**
     * The association ID.
     */
    val associationId: kotlin.String? = builder.associationId
    /**
     * The association name.
     */
    val associationName: kotlin.String? = builder.associationName
    /**
     * The association version.
     */
    val associationVersion: kotlin.String? = builder.associationVersion
    /**
     * Choose the parameter that will define how your automation will branch out. This target is
     * required for associations that use an Automation runbook and target resources by using rate
     * controls. Automation is a capability of Amazon Web Services Systems Manager.
     */
    val automationTargetParameterName: kotlin.String? = builder.automationTargetParameterName
    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
     * associations are gated under. The associations only run when that change calendar is open. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
     * Calendar.
     */
    val calendarNames: List<String>? = builder.calendarNames
    /**
     * The severity level that is assigned to the association.
     */
    val complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = builder.complianceSeverity
    /**
     * The date when the association was made.
     */
    val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * The document version.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The managed node ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The date on which the association was last run.
     */
    val lastExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastExecutionDate
    /**
     * The last date on which the association was successfully run.
     */
    val lastSuccessfulExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulExecutionDate
    /**
     * The date when the association was last updated.
     */
    val lastUpdateAssociationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateAssociationDate
    /**
     * The maximum number of targets allowed to run the association at the same time. You can
     * specify a number, for example 10, or a percentage of the target set, for example 10%. The default
     * value is 100%, which means all targets run the association at the same time.
     * If a new managed node starts and attempts to run an association while Systems Manager is running
     * MaxConcurrency associations, the association is allowed to run. During the next
     * association interval, the new managed node will process its association within the limit
     * specified for MaxConcurrency.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The number of errors that are allowed before the system stops sending requests to run the
     * association on additional targets. You can specify either an absolute number of errors, for
     * example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
     * the system stops sending requests when the fourth error is received. If you specify 0, then the
     * system stops sending requests after the first error is returned. If you run an association on 50
     * managed nodes and set MaxError to 10%, then the system stops sending the request
     * when the sixth error is received.
     * Executions that are already running an association when MaxErrors is reached
     * are allowed to complete, but some of these executions may fail as well. If you need to ensure
     * that there won't be more than max-errors failed executions, set MaxConcurrency to 1
     * so that executions proceed one at a time.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The name of the SSM document.
     */
    val name: kotlin.String? = builder.name
    /**
     * An S3 bucket where you want to store the output details of the request.
     */
    val outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = builder.outputLocation
    /**
     * Information about the association.
     */
    val overview: aws.sdk.kotlin.services.ssm.model.AssociationOverview? = builder.overview
    /**
     * A description of the parameters for a document.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * A cron expression that specifies a schedule when the association runs.
     */
    val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * The association status.
     */
    val status: aws.sdk.kotlin.services.ssm.model.AssociationStatus? = builder.status
    /**
     * The mode for generating association compliance. You can specify AUTO or
     * MANUAL. In AUTO mode, the system uses the status of the association
     * execution to determine the compliance status. If the association execution runs successfully,
     * then the association is COMPLIANT. If the association execution doesn't run
     * successfully, the association is NON-COMPLIANT.
     * In MANUAL mode, you must specify the AssociationId as a parameter
     * for the PutComplianceItems API operation. In this case, compliance data isn't
     * managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     * PutComplianceItems API operation.
     * By default, all associations use AUTO mode.
     */
    val syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = builder.syncCompliance
    /**
     * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
     * association.
     */
    val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * The managed nodes targeted by the request.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AssociationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociationDescription(")
        append("applyOnlyAtCronInterval=$applyOnlyAtCronInterval,")
        append("associationId=$associationId,")
        append("associationName=$associationName,")
        append("associationVersion=$associationVersion,")
        append("automationTargetParameterName=$automationTargetParameterName,")
        append("calendarNames=$calendarNames,")
        append("complianceSeverity=$complianceSeverity,")
        append("date=$date,")
        append("documentVersion=$documentVersion,")
        append("instanceId=$instanceId,")
        append("lastExecutionDate=$lastExecutionDate,")
        append("lastSuccessfulExecutionDate=$lastSuccessfulExecutionDate,")
        append("lastUpdateAssociationDate=$lastUpdateAssociationDate,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("outputLocation=$outputLocation,")
        append("overview=$overview,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("scheduleExpression=$scheduleExpression,")
        append("status=$status,")
        append("syncCompliance=$syncCompliance,")
        append("targetLocations=$targetLocations,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnlyAtCronInterval.hashCode()
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (associationName?.hashCode() ?: 0)
        result = 31 * result + (associationVersion?.hashCode() ?: 0)
        result = 31 * result + (automationTargetParameterName?.hashCode() ?: 0)
        result = 31 * result + (calendarNames?.hashCode() ?: 0)
        result = 31 * result + (complianceSeverity?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (lastExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateAssociationDate?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (overview?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (syncCompliance?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociationDescription

        if (applyOnlyAtCronInterval != other.applyOnlyAtCronInterval) return false
        if (associationId != other.associationId) return false
        if (associationName != other.associationName) return false
        if (associationVersion != other.associationVersion) return false
        if (automationTargetParameterName != other.automationTargetParameterName) return false
        if (calendarNames != other.calendarNames) return false
        if (complianceSeverity != other.complianceSeverity) return false
        if (date != other.date) return false
        if (documentVersion != other.documentVersion) return false
        if (instanceId != other.instanceId) return false
        if (lastExecutionDate != other.lastExecutionDate) return false
        if (lastSuccessfulExecutionDate != other.lastSuccessfulExecutionDate) return false
        if (lastUpdateAssociationDate != other.lastUpdateAssociationDate) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (outputLocation != other.outputLocation) return false
        if (overview != other.overview) return false
        if (parameters != other.parameters) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (status != other.status) return false
        if (syncCompliance != other.syncCompliance) return false
        if (targetLocations != other.targetLocations) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AssociationDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * By default, when you create a new associations, the system runs it immediately after it is
         * created and then according to the schedule you specified. Specify this option if you don't want
         * an association to run immediately after you create it. This parameter isn't supported for rate
         * expressions.
         */
        var applyOnlyAtCronInterval: kotlin.Boolean = false
        /**
         * The association ID.
         */
        var associationId: kotlin.String? = null
        /**
         * The association name.
         */
        var associationName: kotlin.String? = null
        /**
         * The association version.
         */
        var associationVersion: kotlin.String? = null
        /**
         * Choose the parameter that will define how your automation will branch out. This target is
         * required for associations that use an Automation runbook and target resources by using rate
         * controls. Automation is a capability of Amazon Web Services Systems Manager.
         */
        var automationTargetParameterName: kotlin.String? = null
        /**
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
         * associations are gated under. The associations only run when that change calendar is open. For
         * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
         * Calendar.
         */
        var calendarNames: List<String>? = null
        /**
         * The severity level that is assigned to the association.
         */
        var complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = null
        /**
         * The date when the association was made.
         */
        var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The document version.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The managed node ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * The date on which the association was last run.
         */
        var lastExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date on which the association was successfully run.
         */
        var lastSuccessfulExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date when the association was last updated.
         */
        var lastUpdateAssociationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of targets allowed to run the association at the same time. You can
         * specify a number, for example 10, or a percentage of the target set, for example 10%. The default
         * value is 100%, which means all targets run the association at the same time.
         * If a new managed node starts and attempts to run an association while Systems Manager is running
         * MaxConcurrency associations, the association is allowed to run. During the next
         * association interval, the new managed node will process its association within the limit
         * specified for MaxConcurrency.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The number of errors that are allowed before the system stops sending requests to run the
         * association on additional targets. You can specify either an absolute number of errors, for
         * example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
         * the system stops sending requests when the fourth error is received. If you specify 0, then the
         * system stops sending requests after the first error is returned. If you run an association on 50
         * managed nodes and set MaxError to 10%, then the system stops sending the request
         * when the sixth error is received.
         * Executions that are already running an association when MaxErrors is reached
         * are allowed to complete, but some of these executions may fail as well. If you need to ensure
         * that there won't be more than max-errors failed executions, set MaxConcurrency to 1
         * so that executions proceed one at a time.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The name of the SSM document.
         */
        var name: kotlin.String? = null
        /**
         * An S3 bucket where you want to store the output details of the request.
         */
        var outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = null
        /**
         * Information about the association.
         */
        var overview: aws.sdk.kotlin.services.ssm.model.AssociationOverview? = null
        /**
         * A description of the parameters for a document.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * A cron expression that specifies a schedule when the association runs.
         */
        var scheduleExpression: kotlin.String? = null
        /**
         * The association status.
         */
        var status: aws.sdk.kotlin.services.ssm.model.AssociationStatus? = null
        /**
         * The mode for generating association compliance. You can specify AUTO or
         * MANUAL. In AUTO mode, the system uses the status of the association
         * execution to determine the compliance status. If the association execution runs successfully,
         * then the association is COMPLIANT. If the association execution doesn't run
         * successfully, the association is NON-COMPLIANT.
         * In MANUAL mode, you must specify the AssociationId as a parameter
         * for the PutComplianceItems API operation. In this case, compliance data isn't
         * managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         * PutComplianceItems API operation.
         * By default, all associations use AUTO mode.
         */
        var syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = null
        /**
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
         * association.
         */
        var targetLocations: List<TargetLocation>? = null
        /**
         * The managed nodes targeted by the request.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AssociationDescription) : this() {
            this.applyOnlyAtCronInterval = x.applyOnlyAtCronInterval
            this.associationId = x.associationId
            this.associationName = x.associationName
            this.associationVersion = x.associationVersion
            this.automationTargetParameterName = x.automationTargetParameterName
            this.calendarNames = x.calendarNames
            this.complianceSeverity = x.complianceSeverity
            this.date = x.date
            this.documentVersion = x.documentVersion
            this.instanceId = x.instanceId
            this.lastExecutionDate = x.lastExecutionDate
            this.lastSuccessfulExecutionDate = x.lastSuccessfulExecutionDate
            this.lastUpdateAssociationDate = x.lastUpdateAssociationDate
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.outputLocation = x.outputLocation
            this.overview = x.overview
            this.parameters = x.parameters
            this.scheduleExpression = x.scheduleExpression
            this.status = x.status
            this.syncCompliance = x.syncCompliance
            this.targetLocations = x.targetLocations
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AssociationDescription = AssociationDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation] inside the given [block]
         */
        fun outputLocation(block: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AssociationOverview] inside the given [block]
         */
        fun overview(block: aws.sdk.kotlin.services.ssm.model.AssociationOverview.Builder.() -> kotlin.Unit) {
            this.overview = aws.sdk.kotlin.services.ssm.model.AssociationOverview.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AssociationStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.ssm.model.AssociationStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.ssm.model.AssociationStatus.invoke(block)
        }
    }
}
