// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Defines the basic information about a patch baseline override.
 */
class BaselineOverride private constructor(builder: Builder) {
    /**
     * A set of rules defining the approval rules for a patch baseline.
     */
    val approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = builder.approvalRules
    /**
     * A list of explicitly approved patches for the baseline.
     * For information about accepted formats for lists of approved patches and rejected patches,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
     * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
     */
    val approvedPatches: List<String>? = builder.approvedPatches
    /**
     * Defines the compliance level for approved patches. When an approved patch is reported as
     * missing, this value describes the severity of the compliance violation.
     */
    val approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = builder.approvedPatchesComplianceLevel
    /**
     * Indicates whether the list of approved patches includes non-security updates that should be
     * applied to the managed nodes. The default value is false. Applies to Linux managed
     * nodes only.
     */
    val approvedPatchesEnableNonSecurity: kotlin.Boolean = builder.approvedPatchesEnableNonSecurity
    /**
     * A set of patch filters, typically used for approval rules.
     */
    val globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = builder.globalFilters
    /**
     * The operating system rule used by the patch baseline override.
     */
    val operatingSystem: aws.sdk.kotlin.services.ssm.model.OperatingSystem? = builder.operatingSystem
    /**
     * A list of explicitly rejected patches for the baseline.
     * For information about accepted formats for lists of approved patches and rejected patches,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
     * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
     */
    val rejectedPatches: List<String>? = builder.rejectedPatches
    /**
     * The action for Patch Manager to take on patches included in the
     * RejectedPackages list. A patch can be allowed only if it is a dependency of another
     * package, or blocked entirely along with packages that include it as a dependency.
     */
    val rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = builder.rejectedPatchesAction
    /**
     * Information about the patches to use to update the managed nodes, including target operating
     * systems and source repositories. Applies to Linux managed nodes only.
     */
    val sources: List<PatchSource>? = builder.sources

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.BaselineOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BaselineOverride(")
        append("approvalRules=$approvalRules,")
        append("approvedPatches=$approvedPatches,")
        append("approvedPatchesComplianceLevel=$approvedPatchesComplianceLevel,")
        append("approvedPatchesEnableNonSecurity=$approvedPatchesEnableNonSecurity,")
        append("globalFilters=$globalFilters,")
        append("operatingSystem=$operatingSystem,")
        append("rejectedPatches=$rejectedPatches,")
        append("rejectedPatchesAction=$rejectedPatchesAction,")
        append("sources=$sources)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRules?.hashCode() ?: 0
        result = 31 * result + (approvedPatches?.hashCode() ?: 0)
        result = 31 * result + (approvedPatchesComplianceLevel?.hashCode() ?: 0)
        result = 31 * result + (approvedPatchesEnableNonSecurity.hashCode())
        result = 31 * result + (globalFilters?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (rejectedPatches?.hashCode() ?: 0)
        result = 31 * result + (rejectedPatchesAction?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BaselineOverride

        if (approvalRules != other.approvalRules) return false
        if (approvedPatches != other.approvedPatches) return false
        if (approvedPatchesComplianceLevel != other.approvedPatchesComplianceLevel) return false
        if (approvedPatchesEnableNonSecurity != other.approvedPatchesEnableNonSecurity) return false
        if (globalFilters != other.globalFilters) return false
        if (operatingSystem != other.operatingSystem) return false
        if (rejectedPatches != other.rejectedPatches) return false
        if (rejectedPatchesAction != other.rejectedPatchesAction) return false
        if (sources != other.sources) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.BaselineOverride = Builder(this).apply(block).build()

    class Builder {
        /**
         * A set of rules defining the approval rules for a patch baseline.
         */
        var approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = null
        /**
         * A list of explicitly approved patches for the baseline.
         * For information about accepted formats for lists of approved patches and rejected patches,
         * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
         * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
         */
        var approvedPatches: List<String>? = null
        /**
         * Defines the compliance level for approved patches. When an approved patch is reported as
         * missing, this value describes the severity of the compliance violation.
         */
        var approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = null
        /**
         * Indicates whether the list of approved patches includes non-security updates that should be
         * applied to the managed nodes. The default value is false. Applies to Linux managed
         * nodes only.
         */
        var approvedPatchesEnableNonSecurity: kotlin.Boolean = false
        /**
         * A set of patch filters, typically used for approval rules.
         */
        var globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = null
        /**
         * The operating system rule used by the patch baseline override.
         */
        var operatingSystem: aws.sdk.kotlin.services.ssm.model.OperatingSystem? = null
        /**
         * A list of explicitly rejected patches for the baseline.
         * For information about accepted formats for lists of approved patches and rejected patches,
         * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
         * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
         */
        var rejectedPatches: List<String>? = null
        /**
         * The action for Patch Manager to take on patches included in the
         * RejectedPackages list. A patch can be allowed only if it is a dependency of another
         * package, or blocked entirely along with packages that include it as a dependency.
         */
        var rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = null
        /**
         * Information about the patches to use to update the managed nodes, including target operating
         * systems and source repositories. Applies to Linux managed nodes only.
         */
        var sources: List<PatchSource>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.BaselineOverride) : this() {
            this.approvalRules = x.approvalRules
            this.approvedPatches = x.approvedPatches
            this.approvedPatchesComplianceLevel = x.approvedPatchesComplianceLevel
            this.approvedPatchesEnableNonSecurity = x.approvedPatchesEnableNonSecurity
            this.globalFilters = x.globalFilters
            this.operatingSystem = x.operatingSystem
            this.rejectedPatches = x.rejectedPatches
            this.rejectedPatchesAction = x.rejectedPatchesAction
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.BaselineOverride = BaselineOverride(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchRuleGroup] inside the given [block]
         */
        fun approvalRules(block: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.Builder.() -> kotlin.Unit) {
            this.approvalRules = aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchFilterGroup] inside the given [block]
         */
        fun globalFilters(block: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.Builder.() -> kotlin.Unit) {
            this.globalFilters = aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.invoke(block)
        }
    }
}
