// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a command request.
 */
class Command private constructor(builder: Builder) {
    /**
     * Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
     * output.
     */
    val cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = builder.cloudWatchOutputConfig
    /**
     * A unique identifier for this command.
     */
    val commandId: kotlin.String? = builder.commandId
    /**
     * User-specified information about the command, such as a brief description of what the
     * command should do.
     */
    val comment: kotlin.String? = builder.comment
    /**
     * The number of targets for which the command invocation reached a terminal state. Terminal
     * states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Cancelled,
     * Terminated, or Undeliverable.
     */
    val completedCount: kotlin.Int = builder.completedCount
    /**
     * The number of targets for which the status is Delivery Timed Out.
     */
    val deliveryTimedOutCount: kotlin.Int = builder.deliveryTimedOutCount
    /**
     * The name of the document requested for execution.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The Systems Manager document (SSM document) version.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The number of targets for which the status is Failed or Execution Timed Out.
     */
    val errorCount: kotlin.Int = builder.errorCount
    /**
     * If this time is reached and the command hasn't already started running, it won't run.
     * Calculated based on the ExpiresAfter user input provided as part of the
     * SendCommand API operation.
     */
    val expiresAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresAfter
    /**
     * The managed node IDs against which this command was requested.
     */
    val instanceIds: List<String>? = builder.instanceIds
    /**
     * The maximum number of managed nodes that are allowed to run the command at the same time.
     * You can specify a number of managed nodes, such as 10, or a percentage of nodes, such as 10%. The
     * default value is 50. For more information about how to use MaxConcurrency, see
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running
     * commands using Systems Manager Run Command in the Amazon Web Services Systems Manager User Guide.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The maximum number of errors allowed before the system stops sending the command to
     * additional targets. You can specify a number of errors, such as 10, or a percentage or errors,
     * such as 10%. The default value is 0. For more information about how to use
     * MaxErrors, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run
     * Command in the Amazon Web Services Systems Manager User Guide.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * Configurations for sending notifications about command status changes.
     */
    val notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = builder.notificationConfig
    /**
     * The S3 bucket where the responses to the command executions should be stored. This was
     * requested when issuing the command.
     */
    val outputS3BucketName: kotlin.String? = builder.outputS3BucketName
    /**
     * The S3 directory path inside the bucket where the responses to the command executions should
     * be stored. This was requested when issuing the command.
     */
    val outputS3KeyPrefix: kotlin.String? = builder.outputS3KeyPrefix
    /**
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     * automatically determines the Amazon Web Services Region of the S3 bucket.
     */
    val outputS3Region: kotlin.String? = builder.outputS3Region
    /**
     * The parameter values to be inserted in the document when running the command.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The date and time the command was requested.
     */
    val requestedDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedDateTime
    /**
     * The Identity and Access Management (IAM) service role that Run Command, a capability
     * of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The status of the command.
     */
    val status: aws.sdk.kotlin.services.ssm.model.CommandStatus? = builder.status
    /**
     * A detailed status of the command execution. StatusDetails includes more
     * information than Status because it includes states resulting from error and
     * concurrency control parameters. StatusDetails can show different results than
     * Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
     * statuses in the Amazon Web Services Systems Manager User Guide. StatusDetails can be one of the
     * following values:
     * Pending: The command hasn't been sent to any managed nodes.
     * In Progress: The command has been sent to at least one managed node but hasn't reached a
     * final state on all managed nodes.
     * Success: The command successfully ran on all invocations. This is a terminal state.
     * Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of
     * Delivery Timed Out. This is a terminal state.
     * Execution Timed Out: The value of MaxErrors or more command invocations shows a status of
     * Execution Timed Out. This is a terminal state.
     * Failed: The value of MaxErrors or more command invocations shows a status of Failed. This
     * is a terminal state.
     * Incomplete: The command was attempted on all managed nodes and one or more invocations
     * doesn't have a value of Success but not enough invocations failed for the status to be Failed.
     * This is a terminal state.
     * Cancelled: The command was terminated before it was completed. This is a terminal
     * state.
     * Rate Exceeded: The number of managed nodes targeted by the command exceeded the account
     * limit for pending invocations. The system has canceled the command before running it on any
     * managed node. This is a terminal state.
     */
    val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The number of targets for the command.
     */
    val targetCount: kotlin.Int = builder.targetCount
    /**
     * An array of search criteria that targets managed nodes using a Key,Value combination that
     * you specify. Targets is required if you don't provide one or more managed node IDs in the
     * call.
     */
    val targets: List<Target>? = builder.targets
    /**
     * The TimeoutSeconds value specified for a command.
     */
    val timeoutSeconds: kotlin.Int = builder.timeoutSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Command = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Command(")
        append("cloudWatchOutputConfig=$cloudWatchOutputConfig,")
        append("commandId=$commandId,")
        append("comment=$comment,")
        append("completedCount=$completedCount,")
        append("deliveryTimedOutCount=$deliveryTimedOutCount,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("errorCount=$errorCount,")
        append("expiresAfter=$expiresAfter,")
        append("instanceIds=$instanceIds,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("notificationConfig=$notificationConfig,")
        append("outputS3BucketName=$outputS3BucketName,")
        append("outputS3KeyPrefix=$outputS3KeyPrefix,")
        append("outputS3Region=$outputS3Region,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("requestedDateTime=$requestedDateTime,")
        append("serviceRole=$serviceRole,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("targetCount=$targetCount,")
        append("targets=$targets,")
        append("timeoutSeconds=$timeoutSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchOutputConfig?.hashCode() ?: 0
        result = 31 * result + (commandId?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (completedCount)
        result = 31 * result + (deliveryTimedOutCount)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (errorCount)
        result = 31 * result + (expiresAfter?.hashCode() ?: 0)
        result = 31 * result + (instanceIds?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (notificationConfig?.hashCode() ?: 0)
        result = 31 * result + (outputS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (outputS3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (outputS3Region?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (requestedDateTime?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (targetCount)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Command

        if (cloudWatchOutputConfig != other.cloudWatchOutputConfig) return false
        if (commandId != other.commandId) return false
        if (comment != other.comment) return false
        if (completedCount != other.completedCount) return false
        if (deliveryTimedOutCount != other.deliveryTimedOutCount) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (errorCount != other.errorCount) return false
        if (expiresAfter != other.expiresAfter) return false
        if (instanceIds != other.instanceIds) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (notificationConfig != other.notificationConfig) return false
        if (outputS3BucketName != other.outputS3BucketName) return false
        if (outputS3KeyPrefix != other.outputS3KeyPrefix) return false
        if (outputS3Region != other.outputS3Region) return false
        if (parameters != other.parameters) return false
        if (requestedDateTime != other.requestedDateTime) return false
        if (serviceRole != other.serviceRole) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (targetCount != other.targetCount) return false
        if (targets != other.targets) return false
        if (timeoutSeconds != other.timeoutSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Command = Builder(this).apply(block).build()

    class Builder {
        /**
         * Amazon CloudWatch Logs information where you want Amazon Web Services Systems Manager to send the command
         * output.
         */
        var cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = null
        /**
         * A unique identifier for this command.
         */
        var commandId: kotlin.String? = null
        /**
         * User-specified information about the command, such as a brief description of what the
         * command should do.
         */
        var comment: kotlin.String? = null
        /**
         * The number of targets for which the command invocation reached a terminal state. Terminal
         * states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Cancelled,
         * Terminated, or Undeliverable.
         */
        var completedCount: kotlin.Int = 0
        /**
         * The number of targets for which the status is Delivery Timed Out.
         */
        var deliveryTimedOutCount: kotlin.Int = 0
        /**
         * The name of the document requested for execution.
         */
        var documentName: kotlin.String? = null
        /**
         * The Systems Manager document (SSM document) version.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The number of targets for which the status is Failed or Execution Timed Out.
         */
        var errorCount: kotlin.Int = 0
        /**
         * If this time is reached and the command hasn't already started running, it won't run.
         * Calculated based on the ExpiresAfter user input provided as part of the
         * SendCommand API operation.
         */
        var expiresAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The managed node IDs against which this command was requested.
         */
        var instanceIds: List<String>? = null
        /**
         * The maximum number of managed nodes that are allowed to run the command at the same time.
         * You can specify a number of managed nodes, such as 10, or a percentage of nodes, such as 10%. The
         * default value is 50. For more information about how to use MaxConcurrency, see
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running
         * commands using Systems Manager Run Command in the Amazon Web Services Systems Manager User Guide.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before the system stops sending the command to
         * additional targets. You can specify a number of errors, such as 10, or a percentage or errors,
         * such as 10%. The default value is 0. For more information about how to use
         * MaxErrors, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run
         * Command in the Amazon Web Services Systems Manager User Guide.
         */
        var maxErrors: kotlin.String? = null
        /**
         * Configurations for sending notifications about command status changes.
         */
        var notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = null
        /**
         * The S3 bucket where the responses to the command executions should be stored. This was
         * requested when issuing the command.
         */
        var outputS3BucketName: kotlin.String? = null
        /**
         * The S3 directory path inside the bucket where the responses to the command executions should
         * be stored. This was requested when issuing the command.
         */
        var outputS3KeyPrefix: kotlin.String? = null
        /**
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         * automatically determines the Amazon Web Services Region of the S3 bucket.
         */
        var outputS3Region: kotlin.String? = null
        /**
         * The parameter values to be inserted in the document when running the command.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * The date and time the command was requested.
         */
        var requestedDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Identity and Access Management (IAM) service role that Run Command, a capability
         * of Amazon Web Services Systems Manager, uses to act on your behalf when sending notifications about command status changes.
         */
        var serviceRole: kotlin.String? = null
        /**
         * The status of the command.
         */
        var status: aws.sdk.kotlin.services.ssm.model.CommandStatus? = null
        /**
         * A detailed status of the command execution. StatusDetails includes more
         * information than Status because it includes states resulting from error and
         * concurrency control parameters. StatusDetails can show different results than
         * Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
         * statuses in the Amazon Web Services Systems Manager User Guide. StatusDetails can be one of the
         * following values:
         * Pending: The command hasn't been sent to any managed nodes.
         * In Progress: The command has been sent to at least one managed node but hasn't reached a
         * final state on all managed nodes.
         * Success: The command successfully ran on all invocations. This is a terminal state.
         * Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of
         * Delivery Timed Out. This is a terminal state.
         * Execution Timed Out: The value of MaxErrors or more command invocations shows a status of
         * Execution Timed Out. This is a terminal state.
         * Failed: The value of MaxErrors or more command invocations shows a status of Failed. This
         * is a terminal state.
         * Incomplete: The command was attempted on all managed nodes and one or more invocations
         * doesn't have a value of Success but not enough invocations failed for the status to be Failed.
         * This is a terminal state.
         * Cancelled: The command was terminated before it was completed. This is a terminal
         * state.
         * Rate Exceeded: The number of managed nodes targeted by the command exceeded the account
         * limit for pending invocations. The system has canceled the command before running it on any
         * managed node. This is a terminal state.
         */
        var statusDetails: kotlin.String? = null
        /**
         * The number of targets for the command.
         */
        var targetCount: kotlin.Int = 0
        /**
         * An array of search criteria that targets managed nodes using a Key,Value combination that
         * you specify. Targets is required if you don't provide one or more managed node IDs in the
         * call.
         */
        var targets: List<Target>? = null
        /**
         * The TimeoutSeconds value specified for a command.
         */
        var timeoutSeconds: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Command) : this() {
            this.cloudWatchOutputConfig = x.cloudWatchOutputConfig
            this.commandId = x.commandId
            this.comment = x.comment
            this.completedCount = x.completedCount
            this.deliveryTimedOutCount = x.deliveryTimedOutCount
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.errorCount = x.errorCount
            this.expiresAfter = x.expiresAfter
            this.instanceIds = x.instanceIds
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.notificationConfig = x.notificationConfig
            this.outputS3BucketName = x.outputS3BucketName
            this.outputS3KeyPrefix = x.outputS3KeyPrefix
            this.outputS3Region = x.outputS3Region
            this.parameters = x.parameters
            this.requestedDateTime = x.requestedDateTime
            this.serviceRole = x.serviceRole
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.targetCount = x.targetCount
            this.targets = x.targets
            this.timeoutSeconds = x.timeoutSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Command = Command(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig] inside the given [block]
         */
        fun cloudWatchOutputConfig(block: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchOutputConfig = aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.NotificationConfig] inside the given [block]
         */
        fun notificationConfig(block: aws.sdk.kotlin.services.ssm.model.NotificationConfig.Builder.() -> kotlin.Unit) {
            this.notificationConfig = aws.sdk.kotlin.services.ssm.model.NotificationConfig.invoke(block)
        }
    }
}
