// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about a compliance item.
 */
class ComplianceItemEntry private constructor(builder: Builder) {
    /**
     * A "Key": "Value" tag combination for the compliance item.
     */
    val details: Map<String, String>? = builder.details
    /**
     * The compliance item ID. For example, if the compliance item is a Windows patch, the ID could
     * be the number of the KB article.
     */
    val id: kotlin.String? = builder.id
    /**
     * The severity of the compliance status. Severity can be one of the following: Critical, High,
     * Medium, Low, Informational, Unspecified.
     */
    val severity: aws.sdk.kotlin.services.ssm.model.ComplianceSeverity? = builder.severity
    /**
     * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
     */
    val status: aws.sdk.kotlin.services.ssm.model.ComplianceStatus? = builder.status
    /**
     * The title of the compliance item. For example, if the compliance item is a Windows patch,
     * the title could be the title of the KB article for the patch; for example: Security Update for
     * Active Directory Federation Services.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComplianceItemEntry(")
        append("details=$details,")
        append("id=$id,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComplianceItemEntry

        if (details != other.details) return false
        if (id != other.id) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * A "Key": "Value" tag combination for the compliance item.
         */
        var details: Map<String, String>? = null
        /**
         * The compliance item ID. For example, if the compliance item is a Windows patch, the ID could
         * be the number of the KB article.
         */
        var id: kotlin.String? = null
        /**
         * The severity of the compliance status. Severity can be one of the following: Critical, High,
         * Medium, Low, Informational, Unspecified.
         */
        var severity: aws.sdk.kotlin.services.ssm.model.ComplianceSeverity? = null
        /**
         * The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
         */
        var status: aws.sdk.kotlin.services.ssm.model.ComplianceStatus? = null
        /**
         * The title of the compliance item. For example, if the compliance item is a Windows patch,
         * the title could be the title of the KB article for the patch; for example: Security Update for
         * Active Directory Federation Services.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry) : this() {
            this.details = x.details
            this.id = x.id
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry = ComplianceItemEntry(this)
    }
}
