// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class CreateMaintenanceWindowRequest private constructor(builder: Builder) {
    /**
     * Enables a maintenance window task to run on managed nodes, even if you haven't registered
     * those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by node
     * ID) when you register a task with the maintenance window.
     * If you don't enable this option, then you must specify previously-registered targets when
     * you register a task with the maintenance window.
     */
    val allowUnassociatedTargets: kotlin.Boolean = builder.allowUnassociatedTargets
    /**
     * User-provided idempotency token.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
     * new tasks for execution.
     */
    val cutoff: kotlin.Int = builder.cutoff
    /**
     * An optional description for the maintenance window. We recommend specifying a description to
     * help you organize your maintenance windows.
     */
    val description: kotlin.String? = builder.description
    /**
     * The duration of the maintenance window in hours.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
     * become inactive. EndDate allows you to set a date and time in the future when the
     * maintenance window will no longer run.
     */
    val endDate: kotlin.String? = builder.endDate
    /**
     * The name of the maintenance window.
     */
    val name: kotlin.String? = builder.name
    /**
     * The schedule of the maintenance window in the form of a cron or rate expression.
     */
    val schedule: kotlin.String? = builder.schedule
    /**
     * The number of days to wait after the date and time specified by a cron expression before
     * running the maintenance window.
     * For example, the following cron expression schedules a maintenance window to run on the
     * third Tuesday of every month at 11:30 PM.
     * cron(30 23 ? * TUE#3 *)
     * If the schedule offset is 2, the maintenance window won't run until two days
     * later.
     */
    val scheduleOffset: kotlin.Int = builder.scheduleOffset
    /**
     * The time zone that the scheduled maintenance window executions are based on, in Internet
     * Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
     * "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
     * Zone Database on the IANA website.
     */
    val scheduleTimezone: kotlin.String? = builder.scheduleTimezone
    /**
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
     * become active. StartDate allows you to delay activation of the maintenance window
     * until the specified future date.
     */
    val startDate: kotlin.String? = builder.startDate
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
     * different ways, such as by purpose, owner, or environment. For example, you might want to tag a
     * maintenance window to identify the type of tasks it will run, the types of targets, and the
     * environment it will run in. In this case, you could specify the following key-value pairs:
     * Key=TaskType,Value=AgentUpdate
     * Key=OS,Value=Windows
     * Key=Environment,Value=Production
     * To add tags to an existing maintenance window, use the AddTagsToResource
     * operation.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateMaintenanceWindowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMaintenanceWindowRequest(")
        append("allowUnassociatedTargets=$allowUnassociatedTargets,")
        append("clientToken=$clientToken,")
        append("cutoff=$cutoff,")
        append("description=*** Sensitive Data Redacted ***,")
        append("duration=$duration,")
        append("endDate=$endDate,")
        append("name=$name,")
        append("schedule=$schedule,")
        append("scheduleOffset=$scheduleOffset,")
        append("scheduleTimezone=$scheduleTimezone,")
        append("startDate=$startDate,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowUnassociatedTargets.hashCode()
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (cutoff)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (duration)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset)
        result = 31 * result + (scheduleTimezone?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMaintenanceWindowRequest

        if (allowUnassociatedTargets != other.allowUnassociatedTargets) return false
        if (clientToken != other.clientToken) return false
        if (cutoff != other.cutoff) return false
        if (description != other.description) return false
        if (duration != other.duration) return false
        if (endDate != other.endDate) return false
        if (name != other.name) return false
        if (schedule != other.schedule) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (scheduleTimezone != other.scheduleTimezone) return false
        if (startDate != other.startDate) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateMaintenanceWindowRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Enables a maintenance window task to run on managed nodes, even if you haven't registered
         * those nodes as targets. If enabled, then you must specify the unregistered managed nodes (by node
         * ID) when you register a task with the maintenance window.
         * If you don't enable this option, then you must specify previously-registered targets when
         * you register a task with the maintenance window.
         */
        var allowUnassociatedTargets: kotlin.Boolean = false
        /**
         * User-provided idempotency token.
         */
        var clientToken: kotlin.String? = null
        /**
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
         * new tasks for execution.
         */
        var cutoff: kotlin.Int = 0
        /**
         * An optional description for the maintenance window. We recommend specifying a description to
         * help you organize your maintenance windows.
         */
        var description: kotlin.String? = null
        /**
         * The duration of the maintenance window in hours.
         */
        var duration: kotlin.Int = 0
        /**
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
         * become inactive. EndDate allows you to set a date and time in the future when the
         * maintenance window will no longer run.
         */
        var endDate: kotlin.String? = null
        /**
         * The name of the maintenance window.
         */
        var name: kotlin.String? = null
        /**
         * The schedule of the maintenance window in the form of a cron or rate expression.
         */
        var schedule: kotlin.String? = null
        /**
         * The number of days to wait after the date and time specified by a cron expression before
         * running the maintenance window.
         * For example, the following cron expression schedules a maintenance window to run on the
         * third Tuesday of every month at 11:30 PM.
         * cron(30 23 ? * TUE#3 *)
         * If the schedule offset is 2, the maintenance window won't run until two days
         * later.
         */
        var scheduleOffset: kotlin.Int = 0
        /**
         * The time zone that the scheduled maintenance window executions are based on, in Internet
         * Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
         * "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
         * Zone Database on the IANA website.
         */
        var scheduleTimezone: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to
         * become active. StartDate allows you to delay activation of the maintenance window
         * until the specified future date.
         */
        var startDate: kotlin.String? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
         * different ways, such as by purpose, owner, or environment. For example, you might want to tag a
         * maintenance window to identify the type of tasks it will run, the types of targets, and the
         * environment it will run in. In this case, you could specify the following key-value pairs:
         * Key=TaskType,Value=AgentUpdate
         * Key=OS,Value=Windows
         * Key=Environment,Value=Production
         * To add tags to an existing maintenance window, use the AddTagsToResource
         * operation.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateMaintenanceWindowRequest) : this() {
            this.allowUnassociatedTargets = x.allowUnassociatedTargets
            this.clientToken = x.clientToken
            this.cutoff = x.cutoff
            this.description = x.description
            this.duration = x.duration
            this.endDate = x.endDate
            this.name = x.name
            this.schedule = x.schedule
            this.scheduleOffset = x.scheduleOffset
            this.scheduleTimezone = x.scheduleTimezone
            this.startDate = x.startDate
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateMaintenanceWindowRequest = CreateMaintenanceWindowRequest(this)
    }
}
