// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class CreatePatchBaselineRequest private constructor(builder: Builder) {
    /**
     * A set of rules used to include patches in the baseline.
     */
    val approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = builder.approvalRules
    /**
     * A list of explicitly approved patches for the baseline.
     * For information about accepted formats for lists of approved patches and rejected patches,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
     * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
     */
    val approvedPatches: List<String>? = builder.approvedPatches
    /**
     * Defines the compliance level for approved patches. When an approved patch is reported as
     * missing, this value describes the severity of the compliance violation. The default value is
     * UNSPECIFIED.
     */
    val approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = builder.approvedPatchesComplianceLevel
    /**
     * Indicates whether the list of approved patches includes non-security updates that should be
     * applied to the managed nodes. The default value is false. Applies to Linux managed
     * nodes only.
     */
    val approvedPatchesEnableNonSecurity: kotlin.Boolean = builder.approvedPatchesEnableNonSecurity
    /**
     * User-provided idempotency token.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description of the patch baseline.
     */
    val description: kotlin.String? = builder.description
    /**
     * A set of global filters used to include patches in the baseline.
     */
    val globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = builder.globalFilters
    /**
     * The name of the patch baseline.
     */
    val name: kotlin.String? = builder.name
    /**
     * Defines the operating system the patch baseline applies to. The default value is
     * WINDOWS.
     */
    val operatingSystem: aws.sdk.kotlin.services.ssm.model.OperatingSystem? = builder.operatingSystem
    /**
     * A list of explicitly rejected patches for the baseline.
     * For information about accepted formats for lists of approved patches and rejected patches,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
     * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
     */
    val rejectedPatches: List<String>? = builder.rejectedPatches
    /**
     * The action for Patch Manager to take on patches included in the
     * RejectedPackages list.
     * ALLOW_AS_DEPENDENCY
     * : A package in the
     * Rejected patches list is installed only if it is a dependency of another package.
     * It is considered compliant with the patch baseline, and its status is reported as
     * InstalledOther. This is the default action if no option is specified.
     * BLOCK
     * : Packages in the
     * RejectedPatches list, and packages that include them as dependencies, aren't
     * installed under any circumstances. If a package was installed before it was added to the
     * Rejected patches list, it is considered non-compliant with the patch baseline, and its status
     * is reported as InstalledRejected.
     */
    val rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = builder.rejectedPatchesAction
    /**
     * Information about the patches to use to update the managed nodes, including target operating
     * systems and source repositories. Applies to Linux managed nodes only.
     */
    val sources: List<PatchSource>? = builder.sources
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
     * different ways, such as by purpose, owner, or environment. For example, you might want to tag a
     * patch baseline to identify the severity level of patches it specifies and the operating system
     * family it applies to. In this case, you could specify the following key-value pairs:
     * Key=PatchSeverity,Value=Critical
     * Key=OS,Value=Windows
     * To add tags to an existing patch baseline, use the AddTagsToResource
     * operation.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreatePatchBaselineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePatchBaselineRequest(")
        append("approvalRules=$approvalRules,")
        append("approvedPatches=$approvedPatches,")
        append("approvedPatchesComplianceLevel=$approvedPatchesComplianceLevel,")
        append("approvedPatchesEnableNonSecurity=$approvedPatchesEnableNonSecurity,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("globalFilters=$globalFilters,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("rejectedPatches=$rejectedPatches,")
        append("rejectedPatchesAction=$rejectedPatchesAction,")
        append("sources=$sources,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRules?.hashCode() ?: 0
        result = 31 * result + (approvedPatches?.hashCode() ?: 0)
        result = 31 * result + (approvedPatchesComplianceLevel?.hashCode() ?: 0)
        result = 31 * result + (approvedPatchesEnableNonSecurity.hashCode())
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (globalFilters?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (rejectedPatches?.hashCode() ?: 0)
        result = 31 * result + (rejectedPatchesAction?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePatchBaselineRequest

        if (approvalRules != other.approvalRules) return false
        if (approvedPatches != other.approvedPatches) return false
        if (approvedPatchesComplianceLevel != other.approvedPatchesComplianceLevel) return false
        if (approvedPatchesEnableNonSecurity != other.approvedPatchesEnableNonSecurity) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (globalFilters != other.globalFilters) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (rejectedPatches != other.rejectedPatches) return false
        if (rejectedPatchesAction != other.rejectedPatchesAction) return false
        if (sources != other.sources) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreatePatchBaselineRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A set of rules used to include patches in the baseline.
         */
        var approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = null
        /**
         * A list of explicitly approved patches for the baseline.
         * For information about accepted formats for lists of approved patches and rejected patches,
         * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
         * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
         */
        var approvedPatches: List<String>? = null
        /**
         * Defines the compliance level for approved patches. When an approved patch is reported as
         * missing, this value describes the severity of the compliance violation. The default value is
         * UNSPECIFIED.
         */
        var approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = null
        /**
         * Indicates whether the list of approved patches includes non-security updates that should be
         * applied to the managed nodes. The default value is false. Applies to Linux managed
         * nodes only.
         */
        var approvedPatchesEnableNonSecurity: kotlin.Boolean = false
        /**
         * User-provided idempotency token.
         */
        var clientToken: kotlin.String? = null
        /**
         * A description of the patch baseline.
         */
        var description: kotlin.String? = null
        /**
         * A set of global filters used to include patches in the baseline.
         */
        var globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = null
        /**
         * The name of the patch baseline.
         */
        var name: kotlin.String? = null
        /**
         * Defines the operating system the patch baseline applies to. The default value is
         * WINDOWS.
         */
        var operatingSystem: aws.sdk.kotlin.services.ssm.model.OperatingSystem? = null
        /**
         * A list of explicitly rejected patches for the baseline.
         * For information about accepted formats for lists of approved patches and rejected patches,
         * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About
         * package name formats for approved and rejected patch lists in the Amazon Web Services Systems Manager User Guide.
         */
        var rejectedPatches: List<String>? = null
        /**
         * The action for Patch Manager to take on patches included in the
         * RejectedPackages list.
         * ALLOW_AS_DEPENDENCY
         * : A package in the
         * Rejected patches list is installed only if it is a dependency of another package.
         * It is considered compliant with the patch baseline, and its status is reported as
         * InstalledOther. This is the default action if no option is specified.
         * BLOCK
         * : Packages in the
         * RejectedPatches list, and packages that include them as dependencies, aren't
         * installed under any circumstances. If a package was installed before it was added to the
         * Rejected patches list, it is considered non-compliant with the patch baseline, and its status
         * is reported as InstalledRejected.
         */
        var rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = null
        /**
         * Information about the patches to use to update the managed nodes, including target operating
         * systems and source repositories. Applies to Linux managed nodes only.
         */
        var sources: List<PatchSource>? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
         * different ways, such as by purpose, owner, or environment. For example, you might want to tag a
         * patch baseline to identify the severity level of patches it specifies and the operating system
         * family it applies to. In this case, you could specify the following key-value pairs:
         * Key=PatchSeverity,Value=Critical
         * Key=OS,Value=Windows
         * To add tags to an existing patch baseline, use the AddTagsToResource
         * operation.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreatePatchBaselineRequest) : this() {
            this.approvalRules = x.approvalRules
            this.approvedPatches = x.approvedPatches
            this.approvedPatchesComplianceLevel = x.approvedPatchesComplianceLevel
            this.approvedPatchesEnableNonSecurity = x.approvedPatchesEnableNonSecurity
            this.clientToken = x.clientToken
            this.description = x.description
            this.globalFilters = x.globalFilters
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.rejectedPatches = x.rejectedPatches
            this.rejectedPatchesAction = x.rejectedPatchesAction
            this.sources = x.sources
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreatePatchBaselineRequest = CreatePatchBaselineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchRuleGroup] inside the given [block]
         */
        fun approvalRules(block: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.Builder.() -> kotlin.Unit) {
            this.approvalRules = aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchFilterGroup] inside the given [block]
         */
        fun globalFilters(block: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.Builder.() -> kotlin.Unit) {
            this.globalFilters = aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.invoke(block)
        }
    }
}
