// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class DescribePatchGroupStateResponse private constructor(builder: Builder) {
    /**
     * The number of managed nodes in the patch group.
     */
    val instances: kotlin.Int = builder.instances
    /**
     * The number of managed nodes where patches that are specified as Critical for
     * compliance reporting in the patch baseline aren't installed. These patches might be missing, have
     * failed installation, were rejected, or were installed but awaiting a required managed node
     * reboot. The status of these managed nodes is NON_COMPLIANT.
     */
    val instancesWithCriticalNonCompliantPatches: kotlin.Int = builder.instancesWithCriticalNonCompliantPatches
    /**
     * The number of managed nodes with patches from the patch baseline that failed to
     * install.
     */
    val instancesWithFailedPatches: kotlin.Int = builder.instancesWithFailedPatches
    /**
     * The number of managed nodes with patches installed that aren't defined in the patch
     * baseline.
     */
    val instancesWithInstalledOtherPatches: kotlin.Int = builder.instancesWithInstalledOtherPatches
    /**
     * The number of managed nodes with installed patches.
     */
    val instancesWithInstalledPatches: kotlin.Int = builder.instancesWithInstalledPatches
    /**
     * The number of managed nodes with patches installed by Patch Manager that haven't been
     * rebooted after the patch installation. The status of these managed nodes is
     * NON_COMPLIANT.
     */
    val instancesWithInstalledPendingRebootPatches: kotlin.Int = builder.instancesWithInstalledPendingRebootPatches
    /**
     * The number of managed nodes with patches installed that are specified in a
     * RejectedPatches list. Patches with a status of INSTALLED_REJECTED were
     * typically installed before they were added to a RejectedPatches list.
     * If ALLOW_AS_DEPENDENCY is the specified option for
     * RejectedPatchesAction, the value of
     * InstancesWithInstalledRejectedPatches will always be 0 (zero).
     */
    val instancesWithInstalledRejectedPatches: kotlin.Int = builder.instancesWithInstalledRejectedPatches
    /**
     * The number of managed nodes with missing patches from the patch baseline.
     */
    val instancesWithMissingPatches: kotlin.Int = builder.instancesWithMissingPatches
    /**
     * The number of managed nodes with patches that aren't applicable.
     */
    val instancesWithNotApplicablePatches: kotlin.Int = builder.instancesWithNotApplicablePatches
    /**
     * The number of managed nodes with patches installed that are specified as other than
     * Critical or Security but aren't compliant with the patch baseline. The
     * status of these managed nodes is NON_COMPLIANT.
     */
    val instancesWithOtherNonCompliantPatches: kotlin.Int = builder.instancesWithOtherNonCompliantPatches
    /**
     * The number of managed nodes where patches that are specified as Security in a
     * patch advisory aren't installed. These patches might be missing, have failed installation, were
     * rejected, or were installed but awaiting a required managed node reboot. The status of these
     * managed nodes is NON_COMPLIANT.
     */
    val instancesWithSecurityNonCompliantPatches: kotlin.Int = builder.instancesWithSecurityNonCompliantPatches
    /**
     * The number of managed nodes with NotApplicable patches beyond the supported
     * limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.
     */
    val instancesWithUnreportedNotApplicablePatches: kotlin.Int = builder.instancesWithUnreportedNotApplicablePatches

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePatchGroupStateResponse(")
        append("instances=$instances,")
        append("instancesWithCriticalNonCompliantPatches=$instancesWithCriticalNonCompliantPatches,")
        append("instancesWithFailedPatches=$instancesWithFailedPatches,")
        append("instancesWithInstalledOtherPatches=$instancesWithInstalledOtherPatches,")
        append("instancesWithInstalledPatches=$instancesWithInstalledPatches,")
        append("instancesWithInstalledPendingRebootPatches=$instancesWithInstalledPendingRebootPatches,")
        append("instancesWithInstalledRejectedPatches=$instancesWithInstalledRejectedPatches,")
        append("instancesWithMissingPatches=$instancesWithMissingPatches,")
        append("instancesWithNotApplicablePatches=$instancesWithNotApplicablePatches,")
        append("instancesWithOtherNonCompliantPatches=$instancesWithOtherNonCompliantPatches,")
        append("instancesWithSecurityNonCompliantPatches=$instancesWithSecurityNonCompliantPatches,")
        append("instancesWithUnreportedNotApplicablePatches=$instancesWithUnreportedNotApplicablePatches)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instances
        result = 31 * result + (instancesWithCriticalNonCompliantPatches)
        result = 31 * result + (instancesWithFailedPatches)
        result = 31 * result + (instancesWithInstalledOtherPatches)
        result = 31 * result + (instancesWithInstalledPatches)
        result = 31 * result + (instancesWithInstalledPendingRebootPatches)
        result = 31 * result + (instancesWithInstalledRejectedPatches)
        result = 31 * result + (instancesWithMissingPatches)
        result = 31 * result + (instancesWithNotApplicablePatches)
        result = 31 * result + (instancesWithOtherNonCompliantPatches)
        result = 31 * result + (instancesWithSecurityNonCompliantPatches)
        result = 31 * result + (instancesWithUnreportedNotApplicablePatches)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePatchGroupStateResponse

        if (instances != other.instances) return false
        if (instancesWithCriticalNonCompliantPatches != other.instancesWithCriticalNonCompliantPatches) return false
        if (instancesWithFailedPatches != other.instancesWithFailedPatches) return false
        if (instancesWithInstalledOtherPatches != other.instancesWithInstalledOtherPatches) return false
        if (instancesWithInstalledPatches != other.instancesWithInstalledPatches) return false
        if (instancesWithInstalledPendingRebootPatches != other.instancesWithInstalledPendingRebootPatches) return false
        if (instancesWithInstalledRejectedPatches != other.instancesWithInstalledRejectedPatches) return false
        if (instancesWithMissingPatches != other.instancesWithMissingPatches) return false
        if (instancesWithNotApplicablePatches != other.instancesWithNotApplicablePatches) return false
        if (instancesWithOtherNonCompliantPatches != other.instancesWithOtherNonCompliantPatches) return false
        if (instancesWithSecurityNonCompliantPatches != other.instancesWithSecurityNonCompliantPatches) return false
        if (instancesWithUnreportedNotApplicablePatches != other.instancesWithUnreportedNotApplicablePatches) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of managed nodes in the patch group.
         */
        var instances: kotlin.Int = 0
        /**
         * The number of managed nodes where patches that are specified as Critical for
         * compliance reporting in the patch baseline aren't installed. These patches might be missing, have
         * failed installation, were rejected, or were installed but awaiting a required managed node
         * reboot. The status of these managed nodes is NON_COMPLIANT.
         */
        var instancesWithCriticalNonCompliantPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches from the patch baseline that failed to
         * install.
         */
        var instancesWithFailedPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed that aren't defined in the patch
         * baseline.
         */
        var instancesWithInstalledOtherPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with installed patches.
         */
        var instancesWithInstalledPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed by Patch Manager that haven't been
         * rebooted after the patch installation. The status of these managed nodes is
         * NON_COMPLIANT.
         */
        var instancesWithInstalledPendingRebootPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed that are specified in a
         * RejectedPatches list. Patches with a status of INSTALLED_REJECTED were
         * typically installed before they were added to a RejectedPatches list.
         * If ALLOW_AS_DEPENDENCY is the specified option for
         * RejectedPatchesAction, the value of
         * InstancesWithInstalledRejectedPatches will always be 0 (zero).
         */
        var instancesWithInstalledRejectedPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with missing patches from the patch baseline.
         */
        var instancesWithMissingPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches that aren't applicable.
         */
        var instancesWithNotApplicablePatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed that are specified as other than
         * Critical or Security but aren't compliant with the patch baseline. The
         * status of these managed nodes is NON_COMPLIANT.
         */
        var instancesWithOtherNonCompliantPatches: kotlin.Int = 0
        /**
         * The number of managed nodes where patches that are specified as Security in a
         * patch advisory aren't installed. These patches might be missing, have failed installation, were
         * rejected, or were installed but awaiting a required managed node reboot. The status of these
         * managed nodes is NON_COMPLIANT.
         */
        var instancesWithSecurityNonCompliantPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with NotApplicable patches beyond the supported
         * limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.
         */
        var instancesWithUnreportedNotApplicablePatches: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse) : this() {
            this.instances = x.instances
            this.instancesWithCriticalNonCompliantPatches = x.instancesWithCriticalNonCompliantPatches
            this.instancesWithFailedPatches = x.instancesWithFailedPatches
            this.instancesWithInstalledOtherPatches = x.instancesWithInstalledOtherPatches
            this.instancesWithInstalledPatches = x.instancesWithInstalledPatches
            this.instancesWithInstalledPendingRebootPatches = x.instancesWithInstalledPendingRebootPatches
            this.instancesWithInstalledRejectedPatches = x.instancesWithInstalledRejectedPatches
            this.instancesWithMissingPatches = x.instancesWithMissingPatches
            this.instancesWithNotApplicablePatches = x.instancesWithNotApplicablePatches
            this.instancesWithOtherNonCompliantPatches = x.instancesWithOtherNonCompliantPatches
            this.instancesWithSecurityNonCompliantPatches = x.instancesWithSecurityNonCompliantPatches
            this.instancesWithUnreportedNotApplicablePatches = x.instancesWithUnreportedNotApplicablePatches
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse = DescribePatchGroupStateResponse(this)
    }
}
