// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class GetInventoryRequest private constructor(builder: Builder) {
    /**
     * Returns counts of inventory types based on one or more expressions. For example, if you
     * aggregate by using an expression that uses the AWS:InstanceInformation.PlatformType
     * type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried
     * fleet.
     */
    val aggregators: List<InventoryAggregator>? = builder.aggregators
    /**
     * One or more filters. Use a filter to return a more specific list of results.
     */
    val filters: List<InventoryFilter>? = builder.filters
    /**
     * The maximum number of items to return for this call. The call also returns a token that you
     * can specify in a subsequent call to get the next set of results.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * The token for the next set of items to return. (You received this token from a previous
     * call.)
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The list of inventory item types to return.
     */
    val resultAttributes: List<ResultAttribute>? = builder.resultAttributes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetInventoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetInventoryRequest(")
        append("aggregators=$aggregators,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resultAttributes=$resultAttributes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregators?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resultAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetInventoryRequest

        if (aggregators != other.aggregators) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resultAttributes != other.resultAttributes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetInventoryRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Returns counts of inventory types based on one or more expressions. For example, if you
         * aggregate by using an expression that uses the AWS:InstanceInformation.PlatformType
         * type, you can see a count of how many Windows and Linux managed nodes exist in your inventoried
         * fleet.
         */
        var aggregators: List<InventoryAggregator>? = null
        /**
         * One or more filters. Use a filter to return a more specific list of results.
         */
        var filters: List<InventoryFilter>? = null
        /**
         * The maximum number of items to return for this call. The call also returns a token that you
         * can specify in a subsequent call to get the next set of results.
         */
        var maxResults: kotlin.Int = 0
        /**
         * The token for the next set of items to return. (You received this token from a previous
         * call.)
         */
        var nextToken: kotlin.String? = null
        /**
         * The list of inventory item types to return.
         */
        var resultAttributes: List<ResultAttribute>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetInventoryRequest) : this() {
            this.aggregators = x.aggregators
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resultAttributes = x.resultAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetInventoryRequest = GetInventoryRequest(this)
    }
}
