// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class GetInventorySchemaRequest private constructor(builder: Builder) {
    /**
     * Returns inventory schemas that support aggregation. For example, this call returns the
     * AWS:InstanceInformation type, because it supports aggregation based on the
     * PlatformName, PlatformType, and PlatformVersion
     * attributes.
     */
    val aggregator: kotlin.Boolean = builder.aggregator
    /**
     * The maximum number of items to return for this call. The call also returns a token that you
     * can specify in a subsequent call to get the next set of results.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * The token for the next set of items to return. (You received this token from a previous
     * call.)
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Returns the sub-type schema for a specified inventory type.
     */
    val subType: kotlin.Boolean = builder.subType
    /**
     * The type of inventory item to return.
     */
    val typeName: kotlin.String? = builder.typeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetInventorySchemaRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetInventorySchemaRequest(")
        append("aggregator=$aggregator,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("subType=$subType,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregator.hashCode()
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (subType.hashCode())
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetInventorySchemaRequest

        if (aggregator != other.aggregator) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (subType != other.subType) return false
        if (typeName != other.typeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetInventorySchemaRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Returns inventory schemas that support aggregation. For example, this call returns the
         * AWS:InstanceInformation type, because it supports aggregation based on the
         * PlatformName, PlatformType, and PlatformVersion
         * attributes.
         */
        var aggregator: kotlin.Boolean = false
        /**
         * The maximum number of items to return for this call. The call also returns a token that you
         * can specify in a subsequent call to get the next set of results.
         */
        var maxResults: kotlin.Int = 0
        /**
         * The token for the next set of items to return. (You received this token from a previous
         * call.)
         */
        var nextToken: kotlin.String? = null
        /**
         * Returns the sub-type schema for a specified inventory type.
         */
        var subType: kotlin.Boolean = false
        /**
         * The type of inventory item to return.
         */
        var typeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetInventorySchemaRequest) : this() {
            this.aggregator = x.aggregator
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.subType = x.subType
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetInventorySchemaRequest = GetInventorySchemaRequest(this)
    }
}
