// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a filter for a specific list of managed nodes.
 */
class InstanceInformation private constructor(builder: Builder) {
    /**
     * The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was
     * registered.
     */
    val activationId: kotlin.String? = builder.activationId
    /**
     * The version of SSM Agent running on your Linux managed node.
     */
    val agentVersion: kotlin.String? = builder.agentVersion
    /**
     * Information about the association.
     */
    val associationOverview: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview? = builder.associationOverview
    /**
     * The status of the association.
     */
    val associationStatus: kotlin.String? = builder.associationStatus
    /**
     * The fully qualified host name of the managed node.
     */
    val computerName: kotlin.String? = builder.computerName
    /**
     * The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager
     * managed node. This call doesn't return the IAM role for Amazon Elastic Compute Cloud
     * (Amazon EC2) instances. To retrieve the IAM role for an EC2 instance, use
     * the Amazon EC2 DescribeInstances operation. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances in the Amazon EC2 API Reference or <a href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances in
     * the Amazon Web Services CLI Command Reference.
     */
    val iamRole: kotlin.String? = builder.iamRole
    /**
     * The managed node ID.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The IP address of the managed node.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Indicates whether the latest version of SSM Agent is running on your Linux managed node. This
     * field doesn't indicate whether or not the latest version is installed on Windows managed nodes,
     * because some older versions of Windows Server use the EC2Config service to process Systems Manager
     * requests.
     */
    val isLatestVersion: kotlin.Boolean = builder.isLatestVersion
    /**
     * The date the association was last run.
     */
    val lastAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAssociationExecutionDate
    /**
     * The date and time when the agent last pinged the Systems Manager service.
     */
    val lastPingDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastPingDateTime
    /**
     * The last date the association was successfully run.
     */
    val lastSuccessfulAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulAssociationExecutionDate
    /**
     * The name assigned to an on-premises server, edge device, or virtual machine (VM) when it is
     * activated as a Systems Manager managed node. The name is specified as the DefaultInstanceName
     * property using the CreateActivation command. It is applied to the managed node
     * by specifying the Activation Code and Activation ID when you install SSM Agent on the node, as
     * explained in <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html">Install SSM Agent for a
     * hybrid environment (Linux) and <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html">Install SSM Agent for a
     * hybrid environment (Windows). To retrieve the Name tag of an EC2 instance,
     * use the Amazon EC2 DescribeInstances operation. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances in the Amazon EC2 API Reference or <a href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances in
     * the Amazon Web Services CLI Command Reference.
     */
    val name: kotlin.String? = builder.name
    /**
     * Connection status of SSM Agent.
     * The status Inactive has been deprecated and is no longer in use.
     */
    val pingStatus: aws.sdk.kotlin.services.ssm.model.PingStatus? = builder.pingStatus
    /**
     * The name of the operating system platform running on your managed node.
     */
    val platformName: kotlin.String? = builder.platformName
    /**
     * The operating system platform type.
     */
    val platformType: aws.sdk.kotlin.services.ssm.model.PlatformType? = builder.platformType
    /**
     * The version of the OS platform running on your managed node.
     */
    val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The date the server or VM was registered with Amazon Web Services as a managed node.
     */
    val registrationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.registrationDate
    /**
     * The type of instance. Instances are either EC2 instances or managed instances.
     */
    val resourceType: aws.sdk.kotlin.services.ssm.model.ResourceType? = builder.resourceType
    /**
     * The ID of the source resource. For IoT Greengrass devices, SourceId is
     * the Thing name.
     */
    val sourceId: kotlin.String? = builder.sourceId
    /**
     * The type of the source resource. For IoT Greengrass devices, SourceType
     * is AWS::IoT::Thing.
     */
    val sourceType: aws.sdk.kotlin.services.ssm.model.SourceType? = builder.sourceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstanceInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceInformation(")
        append("activationId=$activationId,")
        append("agentVersion=$agentVersion,")
        append("associationOverview=$associationOverview,")
        append("associationStatus=$associationStatus,")
        append("computerName=$computerName,")
        append("iamRole=$iamRole,")
        append("instanceId=$instanceId,")
        append("ipAddress=$ipAddress,")
        append("isLatestVersion=$isLatestVersion,")
        append("lastAssociationExecutionDate=$lastAssociationExecutionDate,")
        append("lastPingDateTime=$lastPingDateTime,")
        append("lastSuccessfulAssociationExecutionDate=$lastSuccessfulAssociationExecutionDate,")
        append("name=$name,")
        append("pingStatus=$pingStatus,")
        append("platformName=$platformName,")
        append("platformType=$platformType,")
        append("platformVersion=$platformVersion,")
        append("registrationDate=$registrationDate,")
        append("resourceType=$resourceType,")
        append("sourceId=$sourceId,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationId?.hashCode() ?: 0
        result = 31 * result + (agentVersion?.hashCode() ?: 0)
        result = 31 * result + (associationOverview?.hashCode() ?: 0)
        result = 31 * result + (associationStatus?.hashCode() ?: 0)
        result = 31 * result + (computerName?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (isLatestVersion.hashCode())
        result = 31 * result + (lastAssociationExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (lastPingDateTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulAssociationExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pingStatus?.hashCode() ?: 0)
        result = 31 * result + (platformName?.hashCode() ?: 0)
        result = 31 * result + (platformType?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (registrationDate?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceInformation

        if (activationId != other.activationId) return false
        if (agentVersion != other.agentVersion) return false
        if (associationOverview != other.associationOverview) return false
        if (associationStatus != other.associationStatus) return false
        if (computerName != other.computerName) return false
        if (iamRole != other.iamRole) return false
        if (instanceId != other.instanceId) return false
        if (ipAddress != other.ipAddress) return false
        if (isLatestVersion != other.isLatestVersion) return false
        if (lastAssociationExecutionDate != other.lastAssociationExecutionDate) return false
        if (lastPingDateTime != other.lastPingDateTime) return false
        if (lastSuccessfulAssociationExecutionDate != other.lastSuccessfulAssociationExecutionDate) return false
        if (name != other.name) return false
        if (pingStatus != other.pingStatus) return false
        if (platformName != other.platformName) return false
        if (platformType != other.platformType) return false
        if (platformVersion != other.platformVersion) return false
        if (registrationDate != other.registrationDate) return false
        if (resourceType != other.resourceType) return false
        if (sourceId != other.sourceId) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstanceInformation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The activation ID created by Amazon Web Services Systems Manager when the server or virtual machine (VM) was
         * registered.
         */
        var activationId: kotlin.String? = null
        /**
         * The version of SSM Agent running on your Linux managed node.
         */
        var agentVersion: kotlin.String? = null
        /**
         * Information about the association.
         */
        var associationOverview: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview? = null
        /**
         * The status of the association.
         */
        var associationStatus: kotlin.String? = null
        /**
         * The fully qualified host name of the managed node.
         */
        var computerName: kotlin.String? = null
        /**
         * The Identity and Access Management (IAM) role assigned to the on-premises Systems Manager
         * managed node. This call doesn't return the IAM role for Amazon Elastic Compute Cloud
         * (Amazon EC2) instances. To retrieve the IAM role for an EC2 instance, use
         * the Amazon EC2 DescribeInstances operation. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances in the Amazon EC2 API Reference or <a href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances in
         * the Amazon Web Services CLI Command Reference.
         */
        var iamRole: kotlin.String? = null
        /**
         * The managed node ID.
         */
        var instanceId: kotlin.String? = null
        /**
         * The IP address of the managed node.
         */
        var ipAddress: kotlin.String? = null
        /**
         * Indicates whether the latest version of SSM Agent is running on your Linux managed node. This
         * field doesn't indicate whether or not the latest version is installed on Windows managed nodes,
         * because some older versions of Windows Server use the EC2Config service to process Systems Manager
         * requests.
         */
        var isLatestVersion: kotlin.Boolean = false
        /**
         * The date the association was last run.
         */
        var lastAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time when the agent last pinged the Systems Manager service.
         */
        var lastPingDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date the association was successfully run.
         */
        var lastSuccessfulAssociationExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name assigned to an on-premises server, edge device, or virtual machine (VM) when it is
         * activated as a Systems Manager managed node. The name is specified as the DefaultInstanceName
         * property using the CreateActivation command. It is applied to the managed node
         * by specifying the Activation Code and Activation ID when you install SSM Agent on the node, as
         * explained in <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html">Install SSM Agent for a
         * hybrid environment (Linux) and <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html">Install SSM Agent for a
         * hybrid environment (Windows). To retrieve the Name tag of an EC2 instance,
         * use the Amazon EC2 DescribeInstances operation. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances in the Amazon EC2 API Reference or <a href="https://docs.aws.amazon.com/cli/latest/ec2/describe-instances.html">describe-instances in
         * the Amazon Web Services CLI Command Reference.
         */
        var name: kotlin.String? = null
        /**
         * Connection status of SSM Agent.
         * The status Inactive has been deprecated and is no longer in use.
         */
        var pingStatus: aws.sdk.kotlin.services.ssm.model.PingStatus? = null
        /**
         * The name of the operating system platform running on your managed node.
         */
        var platformName: kotlin.String? = null
        /**
         * The operating system platform type.
         */
        var platformType: aws.sdk.kotlin.services.ssm.model.PlatformType? = null
        /**
         * The version of the OS platform running on your managed node.
         */
        var platformVersion: kotlin.String? = null
        /**
         * The date the server or VM was registered with Amazon Web Services as a managed node.
         */
        var registrationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of instance. Instances are either EC2 instances or managed instances.
         */
        var resourceType: aws.sdk.kotlin.services.ssm.model.ResourceType? = null
        /**
         * The ID of the source resource. For IoT Greengrass devices, SourceId is
         * the Thing name.
         */
        var sourceId: kotlin.String? = null
        /**
         * The type of the source resource. For IoT Greengrass devices, SourceType
         * is AWS::IoT::Thing.
         */
        var sourceType: aws.sdk.kotlin.services.ssm.model.SourceType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstanceInformation) : this() {
            this.activationId = x.activationId
            this.agentVersion = x.agentVersion
            this.associationOverview = x.associationOverview
            this.associationStatus = x.associationStatus
            this.computerName = x.computerName
            this.iamRole = x.iamRole
            this.instanceId = x.instanceId
            this.ipAddress = x.ipAddress
            this.isLatestVersion = x.isLatestVersion
            this.lastAssociationExecutionDate = x.lastAssociationExecutionDate
            this.lastPingDateTime = x.lastPingDateTime
            this.lastSuccessfulAssociationExecutionDate = x.lastSuccessfulAssociationExecutionDate
            this.name = x.name
            this.pingStatus = x.pingStatus
            this.platformName = x.platformName
            this.platformType = x.platformType
            this.platformVersion = x.platformVersion
            this.registrationDate = x.registrationDate
            this.resourceType = x.resourceType
            this.sourceId = x.sourceId
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstanceInformation = InstanceInformation(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview] inside the given [block]
         */
        fun associationOverview(block: aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview.Builder.() -> kotlin.Unit) {
            this.associationOverview = aws.sdk.kotlin.services.ssm.model.InstanceAggregatedAssociationOverview.invoke(block)
        }
    }
}
