// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a task execution performed as part of a maintenance window
 * execution.
 */
class MaintenanceWindowExecutionTaskIdentity private constructor(builder: Builder) {
    /**
     * The time the task execution finished.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The time the task execution started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task execution.
     */
    val status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = builder.status
    /**
     * The details explaining the status of the task execution. Not available for all status
     * values.
     */
    val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The Amazon Resource Name (ARN) of the task that ran.
     */
    val taskArn: kotlin.String? = builder.taskArn
    /**
     * The ID of the specific task execution in the maintenance window execution.
     */
    val taskExecutionId: kotlin.String? = builder.taskExecutionId
    /**
     * The type of task that ran.
     */
    val taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.taskType
    /**
     * The ID of the maintenance window execution that ran the task.
     */
    val windowExecutionId: kotlin.String? = builder.windowExecutionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowExecutionTaskIdentity(")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("taskArn=$taskArn,")
        append("taskExecutionId=$taskExecutionId,")
        append("taskType=$taskType,")
        append("windowExecutionId=$windowExecutionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionId?.hashCode() ?: 0)
        result = 31 * result + (taskType?.hashCode() ?: 0)
        result = 31 * result + (windowExecutionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowExecutionTaskIdentity

        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (taskArn != other.taskArn) return false
        if (taskExecutionId != other.taskExecutionId) return false
        if (taskType != other.taskType) return false
        if (windowExecutionId != other.windowExecutionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time the task execution finished.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the task execution started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task execution.
         */
        var status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = null
        /**
         * The details explaining the status of the task execution. Not available for all status
         * values.
         */
        var statusDetails: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the task that ran.
         */
        var taskArn: kotlin.String? = null
        /**
         * The ID of the specific task execution in the maintenance window execution.
         */
        var taskExecutionId: kotlin.String? = null
        /**
         * The type of task that ran.
         */
        var taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The ID of the maintenance window execution that ran the task.
         */
        var windowExecutionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity) : this() {
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.taskArn = x.taskArn
            this.taskExecutionId = x.taskExecutionId
            this.taskType = x.taskType
            this.windowExecutionId = x.windowExecutionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = MaintenanceWindowExecutionTaskIdentity(this)
    }
}
