// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the information about a task invocation for a particular target as part of a task
 * execution performed as part of a maintenance window execution.
 */
class MaintenanceWindowExecutionTaskInvocationIdentity private constructor(builder: Builder) {
    /**
     * The time the invocation finished.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The ID of the action performed in the service that actually handled the task invocation. If
     * the task type is RUN_COMMAND, this value is the command ID.
     */
    val executionId: kotlin.String? = builder.executionId
    /**
     * The ID of the task invocation.
     */
    val invocationId: kotlin.String? = builder.invocationId
    /**
     * User-provided value that was specified when the target was registered with the maintenance
     * window. This was also included in any Amazon CloudWatch Events events raised during the task
     * invocation.
     */
    val ownerInformation: kotlin.String? = builder.ownerInformation
    /**
     * The parameters that were provided for the invocation when it was run.
     */
    val parameters: kotlin.String? = builder.parameters
    /**
     * The time the invocation started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task invocation.
     */
    val status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = builder.status
    /**
     * The details explaining the status of the task invocation. Not available for all status
     * values.
     */
    val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The ID of the specific task execution in the maintenance window execution.
     */
    val taskExecutionId: kotlin.String? = builder.taskExecutionId
    /**
     * The task type.
     */
    val taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.taskType
    /**
     * The ID of the maintenance window execution that ran the task.
     */
    val windowExecutionId: kotlin.String? = builder.windowExecutionId
    /**
     * The ID of the target definition in this maintenance window the invocation was performed
     * for.
     */
    val windowTargetId: kotlin.String? = builder.windowTargetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowExecutionTaskInvocationIdentity(")
        append("endTime=$endTime,")
        append("executionId=$executionId,")
        append("invocationId=$invocationId,")
        append("ownerInformation=*** Sensitive Data Redacted ***,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("taskExecutionId=$taskExecutionId,")
        append("taskType=$taskType,")
        append("windowExecutionId=$windowExecutionId,")
        append("windowTargetId=$windowTargetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (executionId?.hashCode() ?: 0)
        result = 31 * result + (invocationId?.hashCode() ?: 0)
        result = 31 * result + (ownerInformation?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionId?.hashCode() ?: 0)
        result = 31 * result + (taskType?.hashCode() ?: 0)
        result = 31 * result + (windowExecutionId?.hashCode() ?: 0)
        result = 31 * result + (windowTargetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowExecutionTaskInvocationIdentity

        if (endTime != other.endTime) return false
        if (executionId != other.executionId) return false
        if (invocationId != other.invocationId) return false
        if (ownerInformation != other.ownerInformation) return false
        if (parameters != other.parameters) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (taskExecutionId != other.taskExecutionId) return false
        if (taskType != other.taskType) return false
        if (windowExecutionId != other.windowExecutionId) return false
        if (windowTargetId != other.windowTargetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time the invocation finished.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the action performed in the service that actually handled the task invocation. If
         * the task type is RUN_COMMAND, this value is the command ID.
         */
        var executionId: kotlin.String? = null
        /**
         * The ID of the task invocation.
         */
        var invocationId: kotlin.String? = null
        /**
         * User-provided value that was specified when the target was registered with the maintenance
         * window. This was also included in any Amazon CloudWatch Events events raised during the task
         * invocation.
         */
        var ownerInformation: kotlin.String? = null
        /**
         * The parameters that were provided for the invocation when it was run.
         */
        var parameters: kotlin.String? = null
        /**
         * The time the invocation started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task invocation.
         */
        var status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = null
        /**
         * The details explaining the status of the task invocation. Not available for all status
         * values.
         */
        var statusDetails: kotlin.String? = null
        /**
         * The ID of the specific task execution in the maintenance window execution.
         */
        var taskExecutionId: kotlin.String? = null
        /**
         * The task type.
         */
        var taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The ID of the maintenance window execution that ran the task.
         */
        var windowExecutionId: kotlin.String? = null
        /**
         * The ID of the target definition in this maintenance window the invocation was performed
         * for.
         */
        var windowTargetId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity) : this() {
            this.endTime = x.endTime
            this.executionId = x.executionId
            this.invocationId = x.invocationId
            this.ownerInformation = x.ownerInformation
            this.parameters = x.parameters
            this.startTime = x.startTime
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.taskExecutionId = x.taskExecutionId
            this.taskType = x.taskType
            this.windowExecutionId = x.windowExecutionId
            this.windowTargetId = x.windowTargetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity = MaintenanceWindowExecutionTaskInvocationIdentity(this)
    }
}
