// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about parameter usage.
 */
class ParameterHistory private constructor(builder: Builder) {
    /**
     * Parameter names can include the following letters and symbols.
     * a-zA-Z0-9_.-
     */
    val allowedPattern: kotlin.String? = builder.allowedPattern
    /**
     * The data type of the parameter, such as text or aws:ec2:image. The
     * default is text.
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * Information about the parameter.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of the query key used for this parameter.
     */
    val keyId: kotlin.String? = builder.keyId
    /**
     * Labels assigned to the parameter version.
     */
    val labels: List<String>? = builder.labels
    /**
     * Date the parameter was last changed or updated.
     */
    val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.
     */
    val lastModifiedUser: kotlin.String? = builder.lastModifiedUser
    /**
     * The name of the parameter.
     */
    val name: kotlin.String? = builder.name
    /**
     * Information about the policies assigned to a parameter.
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
     * policies in the Amazon Web Services Systems Manager User Guide.
     */
    val policies: List<ParameterInlinePolicy>? = builder.policies
    /**
     * The parameter tier.
     */
    val tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = builder.tier
    /**
     * The type of parameter used.
     */
    val type: aws.sdk.kotlin.services.ssm.model.ParameterType? = builder.type
    /**
     * The parameter value.
     */
    val value: kotlin.String? = builder.value
    /**
     * The parameter version.
     */
    val version: kotlin.Long = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ParameterHistory = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterHistory(")
        append("allowedPattern=$allowedPattern,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("labels=$labels,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("lastModifiedUser=$lastModifiedUser,")
        append("name=$name,")
        append("policies=$policies,")
        append("tier=$tier,")
        append("type=$type,")
        append("value=*** Sensitive Data Redacted ***,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPattern?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedUser?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterHistory

        if (allowedPattern != other.allowedPattern) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (labels != other.labels) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (lastModifiedUser != other.lastModifiedUser) return false
        if (name != other.name) return false
        if (policies != other.policies) return false
        if (tier != other.tier) return false
        if (type != other.type) return false
        if (value != other.value) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ParameterHistory = Builder(this).apply(block).build()

    class Builder {
        /**
         * Parameter names can include the following letters and symbols.
         * a-zA-Z0-9_.-
         */
        var allowedPattern: kotlin.String? = null
        /**
         * The data type of the parameter, such as text or aws:ec2:image. The
         * default is text.
         */
        var dataType: kotlin.String? = null
        /**
         * Information about the parameter.
         */
        var description: kotlin.String? = null
        /**
         * The ID of the query key used for this parameter.
         */
        var keyId: kotlin.String? = null
        /**
         * Labels assigned to the parameter version.
         */
        var labels: List<String>? = null
        /**
         * Date the parameter was last changed or updated.
         */
        var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon Resource Name (ARN) of the Amazon Web Services user who last changed the parameter.
         */
        var lastModifiedUser: kotlin.String? = null
        /**
         * The name of the parameter.
         */
        var name: kotlin.String? = null
        /**
         * Information about the policies assigned to a parameter.
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
         * policies in the Amazon Web Services Systems Manager User Guide.
         */
        var policies: List<ParameterInlinePolicy>? = null
        /**
         * The parameter tier.
         */
        var tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = null
        /**
         * The type of parameter used.
         */
        var type: aws.sdk.kotlin.services.ssm.model.ParameterType? = null
        /**
         * The parameter value.
         */
        var value: kotlin.String? = null
        /**
         * The parameter version.
         */
        var version: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ParameterHistory) : this() {
            this.allowedPattern = x.allowedPattern
            this.dataType = x.dataType
            this.description = x.description
            this.keyId = x.keyId
            this.labels = x.labels
            this.lastModifiedDate = x.lastModifiedDate
            this.lastModifiedUser = x.lastModifiedUser
            this.name = x.name
            this.policies = x.policies
            this.tier = x.tier
            this.type = x.type
            this.value = x.value
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ParameterHistory = ParameterHistory(this)
    }
}
