// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Defines an approval rule for a patch baseline.
 */
class PatchRule private constructor(builder: Builder) {
    /**
     * The number of days after the release date of each patch matched by the rule that the patch
     * is marked as approved in the patch baseline. For example, a value of 7 means that
     * patches are approved seven days after they are released. Not supported on Debian Server or Ubuntu
     * Server.
     */
    val approveAfterDays: kotlin.Int = builder.approveAfterDays
    /**
     * The cutoff date for auto approval of released patches. Any patches released on or before
     * this date are installed automatically. Not supported on Debian Server or Ubuntu Server.
     * Enter dates in the format YYYY-MM-DD. For example,
     * 2021-12-31.
     */
    val approveUntilDate: kotlin.String? = builder.approveUntilDate
    /**
     * A compliance severity level for all approved patches in a patch baseline.
     */
    val complianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = builder.complianceLevel
    /**
     * For managed nodes identified by the approval rule filters, enables a patch baseline to apply
     * non-security updates available in the specified repository. The default value is
     * false. Applies to Linux managed nodes only.
     */
    val enableNonSecurity: kotlin.Boolean = builder.enableNonSecurity
    /**
     * The patch filter group that defines the criteria for the rule.
     */
    val patchFilterGroup: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = builder.patchFilterGroup

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchRule(")
        append("approveAfterDays=$approveAfterDays,")
        append("approveUntilDate=$approveUntilDate,")
        append("complianceLevel=$complianceLevel,")
        append("enableNonSecurity=$enableNonSecurity,")
        append("patchFilterGroup=$patchFilterGroup)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approveAfterDays
        result = 31 * result + (approveUntilDate?.hashCode() ?: 0)
        result = 31 * result + (complianceLevel?.hashCode() ?: 0)
        result = 31 * result + (enableNonSecurity.hashCode())
        result = 31 * result + (patchFilterGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchRule

        if (approveAfterDays != other.approveAfterDays) return false
        if (approveUntilDate != other.approveUntilDate) return false
        if (complianceLevel != other.complianceLevel) return false
        if (enableNonSecurity != other.enableNonSecurity) return false
        if (patchFilterGroup != other.patchFilterGroup) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of days after the release date of each patch matched by the rule that the patch
         * is marked as approved in the patch baseline. For example, a value of 7 means that
         * patches are approved seven days after they are released. Not supported on Debian Server or Ubuntu
         * Server.
         */
        var approveAfterDays: kotlin.Int = 0
        /**
         * The cutoff date for auto approval of released patches. Any patches released on or before
         * this date are installed automatically. Not supported on Debian Server or Ubuntu Server.
         * Enter dates in the format YYYY-MM-DD. For example,
         * 2021-12-31.
         */
        var approveUntilDate: kotlin.String? = null
        /**
         * A compliance severity level for all approved patches in a patch baseline.
         */
        var complianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = null
        /**
         * For managed nodes identified by the approval rule filters, enables a patch baseline to apply
         * non-security updates available in the specified repository. The default value is
         * false. Applies to Linux managed nodes only.
         */
        var enableNonSecurity: kotlin.Boolean = false
        /**
         * The patch filter group that defines the criteria for the rule.
         */
        var patchFilterGroup: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchRule) : this() {
            this.approveAfterDays = x.approveAfterDays
            this.approveUntilDate = x.approveUntilDate
            this.complianceLevel = x.complianceLevel
            this.enableNonSecurity = x.enableNonSecurity
            this.patchFilterGroup = x.patchFilterGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchRule = PatchRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchFilterGroup] inside the given [block]
         */
        fun patchFilterGroup(block: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.Builder.() -> kotlin.Unit) {
            this.patchFilterGroup = aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.invoke(block)
        }
    }
}
