// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about the patches to use to update the managed nodes, including target operating
 * systems and source repository. Applies to Linux managed nodes only.
 */
class PatchSource private constructor(builder: Builder) {
    /**
     * The value of the yum repo configuration. For example:
     * &#91;main&#93;
     * name=MyCustomRepository
     * baseurl=https://my-custom-repository
     * enabled=1
     * For information about other options available for your yum repository configuration, see
     * <a href="https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5).
     */
    val configuration: kotlin.String? = builder.configuration
    /**
     * The name specified to identify the patch source.
     */
    val name: kotlin.String? = builder.name
    /**
     * The specific operating system versions a patch repository applies to, such as "Ubuntu16.04",
     * "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product
     * values, see PatchFilter.
     */
    val products: List<String>? = builder.products

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchSource(")
        append("configuration=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("products=$products)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (products?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchSource

        if (configuration != other.configuration) return false
        if (name != other.name) return false
        if (products != other.products) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The value of the yum repo configuration. For example:
         * &#91;main&#93;
         * name=MyCustomRepository
         * baseurl=https://my-custom-repository
         * enabled=1
         * For information about other options available for your yum repository configuration, see
         * <a href="https://man7.org/linux/man-pages/man5/dnf.conf.5.html">dnf.conf(5).
         */
        var configuration: kotlin.String? = null
        /**
         * The name specified to identify the patch source.
         */
        var name: kotlin.String? = null
        /**
         * The specific operating system versions a patch repository applies to, such as "Ubuntu16.04",
         * "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product
         * values, see PatchFilter.
         */
        var products: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchSource) : this() {
            this.configuration = x.configuration
            this.name = x.name
            this.products = x.products
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchSource = PatchSource(this)
    }
}
