// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class PutParameterRequest private constructor(builder: Builder) {
    /**
     * A regular expression used to validate the parameter value. For example, for String types
     * with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$
     */
    val allowedPattern: kotlin.String? = builder.allowedPattern
    /**
     * The data type for a String parameter. Supported data types include plain text
     * and Amazon Machine Image (AMI) IDs.
     * The following data type values are supported.
     * text
     * aws:ec2:image
     * When you create a String parameter and specify aws:ec2:image,
     * Amazon Web Services Systems Manager validates the parameter value is in the required format, such as
     * ami-12345abcdeEXAMPLE, and that the specified AMI is available in your
     * Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support
     * for Amazon Machine Image (AMI) IDs in the Amazon Web Services Systems Manager User Guide.
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * Information about the parameter that you want to add to the system. Optional but
     * recommended.
     * Don't enter personally identifiable information in this field.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Key Management Service (KMS) ID that you want to use to encrypt a
     * parameter. Either the default KMS key automatically assigned to your Amazon Web Services account
     * or a custom key. Required for parameters that use the SecureString
     * data type.
     * If you don't specify a key ID, the system uses the default key associated with your
     * Amazon Web Services account.
     * To use your default KMS key, choose the SecureString data type, and do not specify the Key ID when you create the parameter. The system automatically populates
     * Key ID with your default KMS key.
     * To use a custom KMS key, choose the SecureString
     * data type with the Key ID parameter.
     */
    val keyId: kotlin.String? = builder.keyId
    /**
     * The fully qualified name of the parameter that you want to add to the system. The fully
     * qualified name includes the complete hierarchy of the parameter path and name. For parameters in
     * a hierarchy, you must include a leading forward slash character (/) when you create or reference
     * a parameter. For example: /Dev/DBServer/MySQL/db-string13
     * Naming Constraints:
     * Parameter names are case sensitive.
     * A parameter name must be unique within an Amazon Web Services Region
     * A parameter name can't be prefixed with "aws" or "ssm"
     * (case-insensitive).
     * Parameter names can include only the following symbols and letters:
     * a-zA-Z0-9_.-
     * In addition, the slash character ( / ) is used to delineate hierarchies in parameter
     * names. For example: /Dev/Production/East/Project-ABC/MyParameter
     * A parameter name can't include spaces.
     * Parameter hierarchies are limited to a maximum depth of fifteen levels.
     * For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters in the Amazon Web Services Systems Manager User Guide.
     * The maximum length constraint listed below includes capacity for additional system
     * attributes that aren't part of the name. The maximum length for a parameter name, including the
     * full length of the parameter ARN, is 1011 characters. For example, the length of the following
     * parameter name is 65 characters, not 20 characters:
     * arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName
     */
    val name: kotlin.String? = builder.name
    /**
     * Overwrite an existing parameter. The default value is false.
     */
    val overwrite: kotlin.Boolean = builder.overwrite
    /**
     * One or more policies to apply to a parameter. This operation takes a JSON array. Parameter
     * Store, a capability of Amazon Web Services Systems Manager supports the following policy types:
     * Expiration: This policy deletes the parameter after it expires. When you create the policy,
     * you specify the expiration date. You can update the expiration date and time by updating the
     * policy. Updating the parameter doesn't affect the expiration date and time.
     * When the expiration time is reached, Parameter Store deletes the parameter.
     * ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that
     * notifies you about the expiration. By using this policy, you can receive notification before or
     * after the expiration time is reached, in units of days or hours.
     * NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn't
     * been modified for a specified period of time. This policy type is useful when, for example, a
     * secret needs to be changed within a period of time, but it hasn't been changed.
     * All existing policies are preserved until you send new policies or an empty policy. For more
     * information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
     * policies.
     */
    val policies: kotlin.String? = builder.policies
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
     * different ways, such as by purpose, owner, or environment. For example, you might want to tag a
     * Systems Manager parameter to identify the type of resource to which it applies, the environment, or the
     * type of configuration data referenced by the parameter. In this case, you could specify the
     * following key-value pairs:
     * Key=Resource,Value=S3bucket
     * Key=OS,Value=Windows
     * Key=ParameterType,Value=LicenseKey
     * To add tags to an existing Systems Manager parameter, use the AddTagsToResource
     * operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The parameter tier to assign to a parameter.
     * Parameter Store offers a standard tier and an advanced tier for parameters. Standard
     * parameters have a content size limit of 4 KB and can't be configured to use parameter policies.
     * You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account.
     * Standard parameters are offered at no additional cost.
     * Advanced parameters have a content size limit of 8 KB and can be configured to use parameter
     * policies. You can create a maximum of 100,000 advanced parameters for each Region in an
     * Amazon Web Services account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and
     * advanced parameter tiers in the Amazon Web Services Systems Manager User Guide.
     * You can change a standard parameter to an advanced parameter any time. But you can't revert
     * an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard
     * parameter would result in data loss because the system would truncate the size of the parameter
     * from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly,
     * advanced parameters use a different form of encryption than standard parameters.
     * If you no longer need an advanced parameter, or if you no longer want to incur charges for
     * an advanced parameter, you must delete it and recreate it as a new standard parameter.
     * Using the Default Tier Configuration
     * In PutParameter requests, you can specify the tier to create the parameter in.
     * Whenever you specify a tier in the request, Parameter Store creates or updates the parameter
     * according to that request. However, if you don't specify a tier in a request, Parameter Store
     * assigns the tier based on the current Parameter Store default tier configuration.
     * The default tier when you begin using Parameter Store is the standard-parameter tier. If you
     * use the advanced-parameter tier, you can specify one of the following as the default:
     * Advanced: With this option, Parameter Store evaluates all
     * requests as advanced parameters.
     * Intelligent-Tiering: With this option, Parameter Store
     * evaluates each request to determine if the parameter is standard or advanced.
     * If the request doesn't include any options that require an advanced parameter, the
     * parameter is created in the standard-parameter tier. If one or more options requiring an
     * advanced parameter are included in the request, Parameter Store create a parameter in the
     * advanced-parameter tier.
     * This approach helps control your parameter-related costs by always creating standard
     * parameters unless an advanced parameter is necessary.
     * Options that require an advanced parameter include the following:
     * The content size of the parameter is more than 4 KB.
     * The parameter uses a parameter policy.
     * More than 10,000 parameters already exist in your Amazon Web Services account in the current
     * Amazon Web Services Region.
     * For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a
     * default parameter tier in the Amazon Web Services Systems Manager User Guide.
     */
    val tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = builder.tier
    /**
     * The type of parameter that you want to add to the system.
     * SecureString isn't currently supported for CloudFormation templates.
     * Items in a StringList must be separated by a comma (,). You can't
     * use other punctuation or special character to escape items in the list. If you have a parameter
     * value that requires a comma, then use the String data type.
     * Specifying a parameter type isn't required when updating a parameter. You must specify a
     * parameter type when creating a parameter.
     */
    val type: aws.sdk.kotlin.services.ssm.model.ParameterType? = builder.type
    /**
     * The parameter value that you want to add to the system. Standard parameters have a value
     * limit of 4 KB. Advanced parameters have a value limit of 8 KB.
     * Parameters can't be referenced or nested in the values of other parameters. You can't
     * include {{}} or {{ssm:parameter-name}} in a
     * parameter value.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PutParameterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutParameterRequest(")
        append("allowedPattern=$allowedPattern,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("name=$name,")
        append("overwrite=$overwrite,")
        append("policies=$policies,")
        append("tags=$tags,")
        append("tier=$tier,")
        append("type=$type,")
        append("value=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPattern?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (overwrite.hashCode())
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutParameterRequest

        if (allowedPattern != other.allowedPattern) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (name != other.name) return false
        if (overwrite != other.overwrite) return false
        if (policies != other.policies) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PutParameterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A regular expression used to validate the parameter value. For example, for String types
         * with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$
         */
        var allowedPattern: kotlin.String? = null
        /**
         * The data type for a String parameter. Supported data types include plain text
         * and Amazon Machine Image (AMI) IDs.
         * The following data type values are supported.
         * text
         * aws:ec2:image
         * When you create a String parameter and specify aws:ec2:image,
         * Amazon Web Services Systems Manager validates the parameter value is in the required format, such as
         * ami-12345abcdeEXAMPLE, and that the specified AMI is available in your
         * Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support
         * for Amazon Machine Image (AMI) IDs in the Amazon Web Services Systems Manager User Guide.
         */
        var dataType: kotlin.String? = null
        /**
         * Information about the parameter that you want to add to the system. Optional but
         * recommended.
         * Don't enter personally identifiable information in this field.
         */
        var description: kotlin.String? = null
        /**
         * The Key Management Service (KMS) ID that you want to use to encrypt a
         * parameter. Either the default KMS key automatically assigned to your Amazon Web Services account
         * or a custom key. Required for parameters that use the SecureString
         * data type.
         * If you don't specify a key ID, the system uses the default key associated with your
         * Amazon Web Services account.
         * To use your default KMS key, choose the SecureString data type, and do not specify the Key ID when you create the parameter. The system automatically populates
         * Key ID with your default KMS key.
         * To use a custom KMS key, choose the SecureString
         * data type with the Key ID parameter.
         */
        var keyId: kotlin.String? = null
        /**
         * The fully qualified name of the parameter that you want to add to the system. The fully
         * qualified name includes the complete hierarchy of the parameter path and name. For parameters in
         * a hierarchy, you must include a leading forward slash character (/) when you create or reference
         * a parameter. For example: /Dev/DBServer/MySQL/db-string13
         * Naming Constraints:
         * Parameter names are case sensitive.
         * A parameter name must be unique within an Amazon Web Services Region
         * A parameter name can't be prefixed with "aws" or "ssm"
         * (case-insensitive).
         * Parameter names can include only the following symbols and letters:
         * a-zA-Z0-9_.-
         * In addition, the slash character ( / ) is used to delineate hierarchies in parameter
         * names. For example: /Dev/Production/East/Project-ABC/MyParameter
         * A parameter name can't include spaces.
         * Parameter hierarchies are limited to a maximum depth of fifteen levels.
         * For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html">Creating Systems Manager parameters in the Amazon Web Services Systems Manager User Guide.
         * The maximum length constraint listed below includes capacity for additional system
         * attributes that aren't part of the name. The maximum length for a parameter name, including the
         * full length of the parameter ARN, is 1011 characters. For example, the length of the following
         * parameter name is 65 characters, not 20 characters:
         * arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName
         */
        var name: kotlin.String? = null
        /**
         * Overwrite an existing parameter. The default value is false.
         */
        var overwrite: kotlin.Boolean = false
        /**
         * One or more policies to apply to a parameter. This operation takes a JSON array. Parameter
         * Store, a capability of Amazon Web Services Systems Manager supports the following policy types:
         * Expiration: This policy deletes the parameter after it expires. When you create the policy,
         * you specify the expiration date. You can update the expiration date and time by updating the
         * policy. Updating the parameter doesn't affect the expiration date and time.
         * When the expiration time is reached, Parameter Store deletes the parameter.
         * ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that
         * notifies you about the expiration. By using this policy, you can receive notification before or
         * after the expiration time is reached, in units of days or hours.
         * NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn't
         * been modified for a specified period of time. This policy type is useful when, for example, a
         * secret needs to be changed within a period of time, but it hasn't been changed.
         * All existing policies are preserved until you send new policies or an empty policy. For more
         * information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter
         * policies.
         */
        var policies: kotlin.String? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
         * different ways, such as by purpose, owner, or environment. For example, you might want to tag a
         * Systems Manager parameter to identify the type of resource to which it applies, the environment, or the
         * type of configuration data referenced by the parameter. In this case, you could specify the
         * following key-value pairs:
         * Key=Resource,Value=S3bucket
         * Key=OS,Value=Windows
         * Key=ParameterType,Value=LicenseKey
         * To add tags to an existing Systems Manager parameter, use the AddTagsToResource
         * operation.
         */
        var tags: List<Tag>? = null
        /**
         * The parameter tier to assign to a parameter.
         * Parameter Store offers a standard tier and an advanced tier for parameters. Standard
         * parameters have a content size limit of 4 KB and can't be configured to use parameter policies.
         * You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account.
         * Standard parameters are offered at no additional cost.
         * Advanced parameters have a content size limit of 8 KB and can be configured to use parameter
         * policies. You can create a maximum of 100,000 advanced parameters for each Region in an
         * Amazon Web Services account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and
         * advanced parameter tiers in the Amazon Web Services Systems Manager User Guide.
         * You can change a standard parameter to an advanced parameter any time. But you can't revert
         * an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard
         * parameter would result in data loss because the system would truncate the size of the parameter
         * from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly,
         * advanced parameters use a different form of encryption than standard parameters.
         * If you no longer need an advanced parameter, or if you no longer want to incur charges for
         * an advanced parameter, you must delete it and recreate it as a new standard parameter.
         * Using the Default Tier Configuration
         * In PutParameter requests, you can specify the tier to create the parameter in.
         * Whenever you specify a tier in the request, Parameter Store creates or updates the parameter
         * according to that request. However, if you don't specify a tier in a request, Parameter Store
         * assigns the tier based on the current Parameter Store default tier configuration.
         * The default tier when you begin using Parameter Store is the standard-parameter tier. If you
         * use the advanced-parameter tier, you can specify one of the following as the default:
         * Advanced: With this option, Parameter Store evaluates all
         * requests as advanced parameters.
         * Intelligent-Tiering: With this option, Parameter Store
         * evaluates each request to determine if the parameter is standard or advanced.
         * If the request doesn't include any options that require an advanced parameter, the
         * parameter is created in the standard-parameter tier. If one or more options requiring an
         * advanced parameter are included in the request, Parameter Store create a parameter in the
         * advanced-parameter tier.
         * This approach helps control your parameter-related costs by always creating standard
         * parameters unless an advanced parameter is necessary.
         * Options that require an advanced parameter include the following:
         * The content size of the parameter is more than 4 KB.
         * The parameter uses a parameter policy.
         * More than 10,000 parameters already exist in your Amazon Web Services account in the current
         * Amazon Web Services Region.
         * For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a
         * default parameter tier in the Amazon Web Services Systems Manager User Guide.
         */
        var tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = null
        /**
         * The type of parameter that you want to add to the system.
         * SecureString isn't currently supported for CloudFormation templates.
         * Items in a StringList must be separated by a comma (,). You can't
         * use other punctuation or special character to escape items in the list. If you have a parameter
         * value that requires a comma, then use the String data type.
         * Specifying a parameter type isn't required when updating a parameter. You must specify a
         * parameter type when creating a parameter.
         */
        var type: aws.sdk.kotlin.services.ssm.model.ParameterType? = null
        /**
         * The parameter value that you want to add to the system. Standard parameters have a value
         * limit of 4 KB. Advanced parameters have a value limit of 8 KB.
         * Parameters can't be referenced or nested in the values of other parameters. You can't
         * include {{}} or {{ssm:parameter-name}} in a
         * parameter value.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PutParameterRequest) : this() {
            this.allowedPattern = x.allowedPattern
            this.dataType = x.dataType
            this.description = x.description
            this.keyId = x.keyId
            this.name = x.name
            this.overwrite = x.overwrite
            this.policies = x.policies
            this.tags = x.tags
            this.tier = x.tier
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PutParameterRequest = PutParameterRequest(this)
    }
}
