// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class RegisterTargetWithMaintenanceWindowRequest private constructor(builder: Builder) {
    /**
     * User-provided idempotency token.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * An optional description for the target.
     */
    val description: kotlin.String? = builder.description
    /**
     * An optional name for the target.
     */
    val name: kotlin.String? = builder.name
    /**
     * User-provided value that will be included in any Amazon CloudWatch Events events raised while
     * running tasks for these targets in this maintenance window.
     */
    val ownerInformation: kotlin.String? = builder.ownerInformation
    /**
     * The type of target being registered with the maintenance window.
     */
    val resourceType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowResourceType? = builder.resourceType
    /**
     * The targets to register with the maintenance window. In other words, the managed nodes to
     * run commands on when the maintenance window runs.
     * If a single maintenance window task is registered with multiple targets, its task
     * invocations occur sequentially and not in parallel. If your task must run on multiple targets at
     * the same time, register a task for each target individually and assign each task the same
     * priority level.
     * You can specify targets using managed node IDs, resource group names, or tags that have been
     * applied to managed nodes.
     * Example 1: Specify managed node IDs
     * Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>,<instance-id-3>
     * Example 2: Use tag key-pairs applied to managed
     * nodes
     * Key=tag:<my-tag-key>,Values=<my-tag-value-1>,<my-tag-value-2>
     * Example 3: Use tag-keys applied to managed nodes
     * Key=tag-key,Values=<my-tag-key-1>,<my-tag-key-2>
     * Example 4: Use resource group names
     * Key=resource-groups:Name,Values=<resource-group-name>
     * Example 5: Use filters for resource group types
     * Key=resource-groups:ResourceTypeFilters,Values=<resource-type-1>,<resource-type-2>
     * For Key=resource-groups:ResourceTypeFilters, specify resource types in the
     * following format
     * Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC
     * For more information about these examples formats, including the best use case for each one,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register
     * targets with a maintenance window in the Amazon Web Services Systems Manager User Guide.
     */
    val targets: List<Target>? = builder.targets
    /**
     * The ID of the maintenance window the target should be registered with.
     */
    val windowId: kotlin.String? = builder.windowId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterTargetWithMaintenanceWindowRequest(")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("ownerInformation=*** Sensitive Data Redacted ***,")
        append("resourceType=$resourceType,")
        append("targets=$targets,")
        append("windowId=$windowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerInformation?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterTargetWithMaintenanceWindowRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (ownerInformation != other.ownerInformation) return false
        if (resourceType != other.resourceType) return false
        if (targets != other.targets) return false
        if (windowId != other.windowId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * User-provided idempotency token.
         */
        var clientToken: kotlin.String? = null
        /**
         * An optional description for the target.
         */
        var description: kotlin.String? = null
        /**
         * An optional name for the target.
         */
        var name: kotlin.String? = null
        /**
         * User-provided value that will be included in any Amazon CloudWatch Events events raised while
         * running tasks for these targets in this maintenance window.
         */
        var ownerInformation: kotlin.String? = null
        /**
         * The type of target being registered with the maintenance window.
         */
        var resourceType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowResourceType? = null
        /**
         * The targets to register with the maintenance window. In other words, the managed nodes to
         * run commands on when the maintenance window runs.
         * If a single maintenance window task is registered with multiple targets, its task
         * invocations occur sequentially and not in parallel. If your task must run on multiple targets at
         * the same time, register a task for each target individually and assign each task the same
         * priority level.
         * You can specify targets using managed node IDs, resource group names, or tags that have been
         * applied to managed nodes.
         * Example 1: Specify managed node IDs
         * Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>,<instance-id-3>
         * Example 2: Use tag key-pairs applied to managed
         * nodes
         * Key=tag:<my-tag-key>,Values=<my-tag-value-1>,<my-tag-value-2>
         * Example 3: Use tag-keys applied to managed nodes
         * Key=tag-key,Values=<my-tag-key-1>,<my-tag-key-2>
         * Example 4: Use resource group names
         * Key=resource-groups:Name,Values=<resource-group-name>
         * Example 5: Use filters for resource group types
         * Key=resource-groups:ResourceTypeFilters,Values=<resource-type-1>,<resource-type-2>
         * For Key=resource-groups:ResourceTypeFilters, specify resource types in the
         * following format
         * Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC
         * For more information about these examples formats, including the best use case for each one,
         * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register
         * targets with a maintenance window in the Amazon Web Services Systems Manager User Guide.
         */
        var targets: List<Target>? = null
        /**
         * The ID of the maintenance window the target should be registered with.
         */
        var windowId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.name = x.name
            this.ownerInformation = x.ownerInformation
            this.resourceType = x.resourceType
            this.targets = x.targets
            this.windowId = x.windowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest = RegisterTargetWithMaintenanceWindowRequest(this)
    }
}
