// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about the AwsOrganizationsSource resource data sync source. A sync
 * source of this type can synchronize data from Organizations or, if an Amazon Web Services organization isn't
 * present, from multiple Amazon Web Services Regions.
 */
class ResourceDataSyncAwsOrganizationsSource private constructor(builder: Builder) {
    /**
     * If an Amazon Web Services organization is present, this is either OrganizationalUnits or
     * EntireOrganization. For OrganizationalUnits, the data is aggregated
     * from a set of organization units. For EntireOrganization, the data is aggregated
     * from the entire Amazon Web Services organization.
     */
    val organizationSourceType: kotlin.String? = builder.organizationSourceType
    /**
     * The Organizations organization units included in the sync.
     */
    val organizationalUnits: List<ResourceDataSyncOrganizationalUnit>? = builder.organizationalUnits

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataSyncAwsOrganizationsSource(")
        append("organizationSourceType=$organizationSourceType,")
        append("organizationalUnits=$organizationalUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = organizationSourceType?.hashCode() ?: 0
        result = 31 * result + (organizationalUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataSyncAwsOrganizationsSource

        if (organizationSourceType != other.organizationSourceType) return false
        if (organizationalUnits != other.organizationalUnits) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * If an Amazon Web Services organization is present, this is either OrganizationalUnits or
         * EntireOrganization. For OrganizationalUnits, the data is aggregated
         * from a set of organization units. For EntireOrganization, the data is aggregated
         * from the entire Amazon Web Services organization.
         */
        var organizationSourceType: kotlin.String? = null
        /**
         * The Organizations organization units included in the sync.
         */
        var organizationalUnits: List<ResourceDataSyncOrganizationalUnit>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource) : this() {
            this.organizationSourceType = x.organizationSourceType
            this.organizationalUnits = x.organizationalUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = ResourceDataSyncAwsOrganizationsSource(this)
    }
}
