// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

class StartChangeRequestExecutionRequest private constructor(builder: Builder) {
    /**
     * Indicates whether the change request can be approved automatically without the need for
     * manual approvals.
     * If AutoApprovable is enabled in a change template, then setting
     * AutoApprove to true in StartChangeRequestExecution
     * creates a change request that bypasses approver review.
     * Change Calendar restrictions are not bypassed in this scenario. If the state of an
     * associated calendar is CLOSED, change freeze approvers must still grant permission
     * for this change request to run. If they don't, the change won't be processed until the calendar
     * state is again OPEN.
     */
    val autoApprove: kotlin.Boolean = builder.autoApprove
    /**
     * User-provided details about the change. If no details are provided, content specified in the
     * Template information section of the associated change template
     * is added.
     */
    val changeDetails: kotlin.String? = builder.changeDetails
    /**
     * The name of the change request associated with the runbook workflow to be run.
     */
    val changeRequestName: kotlin.String? = builder.changeRequestName
    /**
     * The user-provided idempotency token. The token must be unique, is case insensitive, enforces
     * the UUID format, and can't be reused.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the change template document to run during the runbook workflow.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The version of the change template document to run during the runbook workflow.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * A key-value map of parameters that match the declared parameters in the change template
     * document.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * Information about the Automation runbooks that are run during the runbook workflow.
     * The Automation runbooks specified for the runbook workflow can't run until all required
     * approvals for the change request have been received.
     */
    val runbooks: List<Runbook>? = builder.runbooks
    /**
     * The time that the requester expects the runbook workflow related to the change request to
     * complete. The time is an estimate only that the requester provides for reviewers.
     */
    val scheduledEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledEndTime
    /**
     * The date and time specified in the change request to run the Automation runbooks.
     * The Automation runbooks specified for the runbook workflow can't run until all required
     * approvals for the change request have been received.
     */
    val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime
    /**
     * Optional metadata that you assign to a resource. You can specify a maximum of five tags for
     * a change request. Tags enable you to categorize a resource in different ways, such as by
     * purpose, owner, or environment. For example, you might want to tag a change request to identify
     * an environment or target Amazon Web Services Region. In this case, you could specify the following key-value
     * pairs:
     * Key=Environment,Value=Production
     * Key=Region,Value=us-east-2
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartChangeRequestExecutionRequest(")
        append("autoApprove=$autoApprove,")
        append("changeDetails=$changeDetails,")
        append("changeRequestName=$changeRequestName,")
        append("clientToken=$clientToken,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("parameters=$parameters,")
        append("runbooks=$runbooks,")
        append("scheduledEndTime=$scheduledEndTime,")
        append("scheduledTime=$scheduledTime,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoApprove.hashCode()
        result = 31 * result + (changeDetails?.hashCode() ?: 0)
        result = 31 * result + (changeRequestName?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (runbooks?.hashCode() ?: 0)
        result = 31 * result + (scheduledEndTime?.hashCode() ?: 0)
        result = 31 * result + (scheduledTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartChangeRequestExecutionRequest

        if (autoApprove != other.autoApprove) return false
        if (changeDetails != other.changeDetails) return false
        if (changeRequestName != other.changeRequestName) return false
        if (clientToken != other.clientToken) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (parameters != other.parameters) return false
        if (runbooks != other.runbooks) return false
        if (scheduledEndTime != other.scheduledEndTime) return false
        if (scheduledTime != other.scheduledTime) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the change request can be approved automatically without the need for
         * manual approvals.
         * If AutoApprovable is enabled in a change template, then setting
         * AutoApprove to true in StartChangeRequestExecution
         * creates a change request that bypasses approver review.
         * Change Calendar restrictions are not bypassed in this scenario. If the state of an
         * associated calendar is CLOSED, change freeze approvers must still grant permission
         * for this change request to run. If they don't, the change won't be processed until the calendar
         * state is again OPEN.
         */
        var autoApprove: kotlin.Boolean = false
        /**
         * User-provided details about the change. If no details are provided, content specified in the
         * Template information section of the associated change template
         * is added.
         */
        var changeDetails: kotlin.String? = null
        /**
         * The name of the change request associated with the runbook workflow to be run.
         */
        var changeRequestName: kotlin.String? = null
        /**
         * The user-provided idempotency token. The token must be unique, is case insensitive, enforces
         * the UUID format, and can't be reused.
         */
        var clientToken: kotlin.String? = null
        /**
         * The name of the change template document to run during the runbook workflow.
         */
        var documentName: kotlin.String? = null
        /**
         * The version of the change template document to run during the runbook workflow.
         */
        var documentVersion: kotlin.String? = null
        /**
         * A key-value map of parameters that match the declared parameters in the change template
         * document.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * Information about the Automation runbooks that are run during the runbook workflow.
         * The Automation runbooks specified for the runbook workflow can't run until all required
         * approvals for the change request have been received.
         */
        var runbooks: List<Runbook>? = null
        /**
         * The time that the requester expects the runbook workflow related to the change request to
         * complete. The time is an estimate only that the requester provides for reviewers.
         */
        var scheduledEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time specified in the change request to run the Automation runbooks.
         * The Automation runbooks specified for the runbook workflow can't run until all required
         * approvals for the change request have been received.
         */
        var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for
         * a change request. Tags enable you to categorize a resource in different ways, such as by
         * purpose, owner, or environment. For example, you might want to tag a change request to identify
         * an environment or target Amazon Web Services Region. In this case, you could specify the following key-value
         * pairs:
         * Key=Environment,Value=Production
         * Key=Region,Value=us-east-2
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest) : this() {
            this.autoApprove = x.autoApprove
            this.changeDetails = x.changeDetails
            this.changeRequestName = x.changeRequestName
            this.clientToken = x.clientToken
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.parameters = x.parameters
            this.runbooks = x.runbooks
            this.scheduledEndTime = x.scheduledEndTime
            this.scheduledTime = x.scheduledTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest = StartChangeRequestExecutionRequest(this)
    }
}
