// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
 * execution.
 */
class TargetLocation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services accounts targeted by the current Automation execution.
     */
    val accounts: List<String>? = builder.accounts
    /**
     * The Automation execution role used by the currently running Automation. If not specified,
     * the default value is AWS-SystemsManager-AutomationExecutionRole.
     */
    val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * The Amazon Web Services Regions targeted by the current Automation execution.
     */
    val regions: List<String>? = builder.regions
    /**
     * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation
     * concurrently.
     */
    val targetLocationMaxConcurrency: kotlin.String? = builder.targetLocationMaxConcurrency
    /**
     * The maximum number of errors allowed before the system stops queueing additional Automation
     * executions for the currently running Automation.
     */
    val targetLocationMaxErrors: kotlin.String? = builder.targetLocationMaxErrors

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.TargetLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetLocation(")
        append("accounts=$accounts,")
        append("executionRoleName=$executionRoleName,")
        append("regions=$regions,")
        append("targetLocationMaxConcurrency=$targetLocationMaxConcurrency,")
        append("targetLocationMaxErrors=$targetLocationMaxErrors)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (targetLocationMaxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (targetLocationMaxErrors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetLocation

        if (accounts != other.accounts) return false
        if (executionRoleName != other.executionRoleName) return false
        if (regions != other.regions) return false
        if (targetLocationMaxConcurrency != other.targetLocationMaxConcurrency) return false
        if (targetLocationMaxErrors != other.targetLocationMaxErrors) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.TargetLocation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services accounts targeted by the current Automation execution.
         */
        var accounts: List<String>? = null
        /**
         * The Automation execution role used by the currently running Automation. If not specified,
         * the default value is AWS-SystemsManager-AutomationExecutionRole.
         */
        var executionRoleName: kotlin.String? = null
        /**
         * The Amazon Web Services Regions targeted by the current Automation execution.
         */
        var regions: List<String>? = null
        /**
         * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation
         * concurrently.
         */
        var targetLocationMaxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before the system stops queueing additional Automation
         * executions for the currently running Automation.
         */
        var targetLocationMaxErrors: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.TargetLocation) : this() {
            this.accounts = x.accounts
            this.executionRoleName = x.executionRoleName
            this.regions = x.regions
            this.targetLocationMaxConcurrency = x.targetLocationMaxConcurrency
            this.targetLocationMaxErrors = x.targetLocationMaxErrors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.TargetLocation = TargetLocation(this)
    }
}
