// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class UpdateMaintenanceWindowResponse private constructor(builder: Builder) {
    /**
     * Whether targets must be registered with the maintenance window before tasks can be defined
     * for those targets.
     */
    val allowUnassociatedTargets: kotlin.Boolean = builder.allowUnassociatedTargets
    /**
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
     * new tasks for execution.
     */
    val cutoff: kotlin.Int = builder.cutoff
    /**
     * An optional description of the update.
     */
    val description: kotlin.String? = builder.description
    /**
     * The duration of the maintenance window in hours.
     */
    val duration: kotlin.Int = builder.duration
    /**
     * Whether the maintenance window is enabled.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled
     * to become inactive. The maintenance window won't run after this specified time.
     */
    val endDate: kotlin.String? = builder.endDate
    /**
     * The name of the maintenance window.
     */
    val name: kotlin.String? = builder.name
    /**
     * The schedule of the maintenance window in the form of a cron or rate expression.
     */
    val schedule: kotlin.String? = builder.schedule
    /**
     * The number of days to wait to run a maintenance window after the scheduled cron expression
     * date and time.
     */
    val scheduleOffset: kotlin.Int = builder.scheduleOffset
    /**
     * The time zone that the scheduled maintenance window executions are based on, in Internet
     * Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
     * "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
     * Zone Database on the IANA website.
     */
    val scheduleTimezone: kotlin.String? = builder.scheduleTimezone
    /**
     * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled
     * to become active. The maintenance window won't run before this specified time.
     */
    val startDate: kotlin.String? = builder.startDate
    /**
     * The ID of the created maintenance window.
     */
    val windowId: kotlin.String? = builder.windowId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMaintenanceWindowResponse(")
        append("allowUnassociatedTargets=$allowUnassociatedTargets,")
        append("cutoff=$cutoff,")
        append("description=*** Sensitive Data Redacted ***,")
        append("duration=$duration,")
        append("enabled=$enabled,")
        append("endDate=$endDate,")
        append("name=$name,")
        append("schedule=$schedule,")
        append("scheduleOffset=$scheduleOffset,")
        append("scheduleTimezone=$scheduleTimezone,")
        append("startDate=$startDate,")
        append("windowId=$windowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowUnassociatedTargets.hashCode()
        result = 31 * result + (cutoff)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (duration)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset)
        result = 31 * result + (scheduleTimezone?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMaintenanceWindowResponse

        if (allowUnassociatedTargets != other.allowUnassociatedTargets) return false
        if (cutoff != other.cutoff) return false
        if (description != other.description) return false
        if (duration != other.duration) return false
        if (enabled != other.enabled) return false
        if (endDate != other.endDate) return false
        if (name != other.name) return false
        if (schedule != other.schedule) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (scheduleTimezone != other.scheduleTimezone) return false
        if (startDate != other.startDate) return false
        if (windowId != other.windowId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether targets must be registered with the maintenance window before tasks can be defined
         * for those targets.
         */
        var allowUnassociatedTargets: kotlin.Boolean = false
        /**
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops scheduling
         * new tasks for execution.
         */
        var cutoff: kotlin.Int = 0
        /**
         * An optional description of the update.
         */
        var description: kotlin.String? = null
        /**
         * The duration of the maintenance window in hours.
         */
        var duration: kotlin.Int = 0
        /**
         * Whether the maintenance window is enabled.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled
         * to become inactive. The maintenance window won't run after this specified time.
         */
        var endDate: kotlin.String? = null
        /**
         * The name of the maintenance window.
         */
        var name: kotlin.String? = null
        /**
         * The schedule of the maintenance window in the form of a cron or rate expression.
         */
        var schedule: kotlin.String? = null
        /**
         * The number of days to wait to run a maintenance window after the scheduled cron expression
         * date and time.
         */
        var scheduleOffset: kotlin.Int = 0
        /**
         * The time zone that the scheduled maintenance window executions are based on, in Internet
         * Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or
         * "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time
         * Zone Database on the IANA website.
         */
        var scheduleTimezone: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled
         * to become active. The maintenance window won't run before this specified time.
         */
        var startDate: kotlin.String? = null
        /**
         * The ID of the created maintenance window.
         */
        var windowId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowResponse) : this() {
            this.allowUnassociatedTargets = x.allowUnassociatedTargets
            this.cutoff = x.cutoff
            this.description = x.description
            this.duration = x.duration
            this.enabled = x.enabled
            this.endDate = x.endDate
            this.name = x.name
            this.schedule = x.schedule
            this.scheduleOffset = x.scheduleOffset
            this.scheduleTimezone = x.scheduleTimezone
            this.startDate = x.startDate
            this.windowId = x.windowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowResponse = UpdateMaintenanceWindowResponse(this)
    }
}
