// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

class UpdateOpsItemRequest private constructor(builder: Builder) {
    /**
     * The time a runbook workflow ended. Currently reported only for the OpsItem type
     * /aws/changerequest.
     */
    val actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualEndTime
    /**
     * The time a runbook workflow started. Currently reported only for the OpsItem type
     * /aws/changerequest.
     */
    val actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualStartTime
    /**
     * Specify a new category for an OpsItem.
     */
    val category: kotlin.String? = builder.category
    /**
     * Update the information about the OpsItem. Provide enough information so that users reading
     * this OpsItem for the first time understand the issue.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
     * OpsItem is edited or changed.
     */
    val notifications: List<OpsItemNotification>? = builder.notifications
    /**
     * Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem
     * object.
     * Operational data is custom data that provides useful reference details about the OpsItem.
     * For example, you can specify log files, error strings, license keys, troubleshooting tips, or
     * other relevant data. You enter operational data as key-value pairs. The key has a maximum length
     * of 128 characters. The value has a maximum size of 20 KB.
     * Operational data keys can't begin with the following:
     * amazon, aws, amzn, ssm,
     * /amazon, /aws, /amzn, /ssm.
     * You can choose to make the data searchable by other users in the account or you can restrict
     * search access. Searchable data means that all users with access to the OpsItem Overview page (as
     * provided by the DescribeOpsItems API operation) can view and search on the
     * specified data. Operational data that isn't searchable is only viewable by users who have access
     * to the OpsItem (as provided by the GetOpsItem API operation).
     * Use the /aws/resources key in OperationalData to specify a related resource in
     * the request. Use the /aws/automations key in OperationalData to associate an
     * Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide.
     */
    val operationalData: Map<String, OpsItemDataValue>? = builder.operationalData
    /**
     * Keys that you want to remove from the OperationalData map.
     */
    val operationalDataToDelete: List<String>? = builder.operationalDataToDelete
    /**
     * The ID of the OpsItem.
     */
    val opsItemId: kotlin.String? = builder.opsItemId
    /**
     * The time specified in a change request for a runbook workflow to end. Currently supported
     * only for the OpsItem type /aws/changerequest.
     */
    val plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedEndTime
    /**
     * The time specified in a change request for a runbook workflow to start. Currently supported
     * only for the OpsItem type /aws/changerequest.
     */
    val plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedStartTime
    /**
     * The importance of this OpsItem in relation to other OpsItems in the system.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * One or more OpsItems that share something in common with the current OpsItems. For example,
     * related OpsItems can include OpsItems with similar error messages, impacted resources, or
     * statuses for the impacted resource.
     */
    val relatedOpsItems: List<RelatedOpsItem>? = builder.relatedOpsItems
    /**
     * Specify a new severity for an OpsItem.
     */
    val severity: kotlin.String? = builder.severity
    /**
     * The OpsItem status. Status can be Open, In Progress, or
     * Resolved. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details in the Amazon Web Services Systems Manager User Guide.
     */
    val status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = builder.status
    /**
     * A short heading that describes the nature of the OpsItem and the impacted resource.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateOpsItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOpsItemRequest(")
        append("actualEndTime=$actualEndTime,")
        append("actualStartTime=$actualStartTime,")
        append("category=$category,")
        append("description=$description,")
        append("notifications=$notifications,")
        append("operationalData=$operationalData,")
        append("operationalDataToDelete=$operationalDataToDelete,")
        append("opsItemId=$opsItemId,")
        append("plannedEndTime=$plannedEndTime,")
        append("plannedStartTime=$plannedStartTime,")
        append("priority=$priority,")
        append("relatedOpsItems=$relatedOpsItems,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualEndTime?.hashCode() ?: 0
        result = 31 * result + (actualStartTime?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (notifications?.hashCode() ?: 0)
        result = 31 * result + (operationalData?.hashCode() ?: 0)
        result = 31 * result + (operationalDataToDelete?.hashCode() ?: 0)
        result = 31 * result + (opsItemId?.hashCode() ?: 0)
        result = 31 * result + (plannedEndTime?.hashCode() ?: 0)
        result = 31 * result + (plannedStartTime?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (relatedOpsItems?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOpsItemRequest

        if (actualEndTime != other.actualEndTime) return false
        if (actualStartTime != other.actualStartTime) return false
        if (category != other.category) return false
        if (description != other.description) return false
        if (notifications != other.notifications) return false
        if (operationalData != other.operationalData) return false
        if (operationalDataToDelete != other.operationalDataToDelete) return false
        if (opsItemId != other.opsItemId) return false
        if (plannedEndTime != other.plannedEndTime) return false
        if (plannedStartTime != other.plannedStartTime) return false
        if (priority != other.priority) return false
        if (relatedOpsItems != other.relatedOpsItems) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateOpsItemRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time a runbook workflow ended. Currently reported only for the OpsItem type
         * /aws/changerequest.
         */
        var actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time a runbook workflow started. Currently reported only for the OpsItem type
         * /aws/changerequest.
         */
        var actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specify a new category for an OpsItem.
         */
        var category: kotlin.String? = null
        /**
         * Update the information about the OpsItem. Provide enough information so that users reading
         * this OpsItem for the first time understand the issue.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
         * OpsItem is edited or changed.
         */
        var notifications: List<OpsItemNotification>? = null
        /**
         * Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem
         * object.
         * Operational data is custom data that provides useful reference details about the OpsItem.
         * For example, you can specify log files, error strings, license keys, troubleshooting tips, or
         * other relevant data. You enter operational data as key-value pairs. The key has a maximum length
         * of 128 characters. The value has a maximum size of 20 KB.
         * Operational data keys can't begin with the following:
         * amazon, aws, amzn, ssm,
         * /amazon, /aws, /amzn, /ssm.
         * You can choose to make the data searchable by other users in the account or you can restrict
         * search access. Searchable data means that all users with access to the OpsItem Overview page (as
         * provided by the DescribeOpsItems API operation) can view and search on the
         * specified data. Operational data that isn't searchable is only viewable by users who have access
         * to the OpsItem (as provided by the GetOpsItem API operation).
         * Use the /aws/resources key in OperationalData to specify a related resource in
         * the request. Use the /aws/automations key in OperationalData to associate an
         * Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide.
         */
        var operationalData: Map<String, OpsItemDataValue>? = null
        /**
         * Keys that you want to remove from the OperationalData map.
         */
        var operationalDataToDelete: List<String>? = null
        /**
         * The ID of the OpsItem.
         */
        var opsItemId: kotlin.String? = null
        /**
         * The time specified in a change request for a runbook workflow to end. Currently supported
         * only for the OpsItem type /aws/changerequest.
         */
        var plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time specified in a change request for a runbook workflow to start. Currently supported
         * only for the OpsItem type /aws/changerequest.
         */
        var plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The importance of this OpsItem in relation to other OpsItems in the system.
         */
        var priority: kotlin.Int? = null
        /**
         * One or more OpsItems that share something in common with the current OpsItems. For example,
         * related OpsItems can include OpsItems with similar error messages, impacted resources, or
         * statuses for the impacted resource.
         */
        var relatedOpsItems: List<RelatedOpsItem>? = null
        /**
         * Specify a new severity for an OpsItem.
         */
        var severity: kotlin.String? = null
        /**
         * The OpsItem status. Status can be Open, In Progress, or
         * Resolved. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details in the Amazon Web Services Systems Manager User Guide.
         */
        var status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = null
        /**
         * A short heading that describes the nature of the OpsItem and the impacted resource.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateOpsItemRequest) : this() {
            this.actualEndTime = x.actualEndTime
            this.actualStartTime = x.actualStartTime
            this.category = x.category
            this.description = x.description
            this.notifications = x.notifications
            this.operationalData = x.operationalData
            this.operationalDataToDelete = x.operationalDataToDelete
            this.opsItemId = x.opsItemId
            this.plannedEndTime = x.plannedEndTime
            this.plannedStartTime = x.plannedStartTime
            this.priority = x.priority
            this.relatedOpsItems = x.relatedOpsItems
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateOpsItemRequest = UpdateOpsItemRequest(this)
    }
}
