// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * The request body of the UpdateServiceSetting API operation.
 */
class UpdateServiceSettingRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the service setting to reset. For example,
     * arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled.
     * The setting ID can be one of the following.
     * /ssm/automation/customer-script-log-destination
     * /ssm/automation/customer-script-log-group-name
     * /ssm/documents/console/public-sharing-permission
     * /ssm/parameter-store/default-parameter-tier
     * /ssm/parameter-store/high-throughput-enabled
     * /ssm/managed-instance/activation-tier
     */
    val settingId: kotlin.String? = builder.settingId
    /**
     * The new value to specify for the service setting. The following list specifies the available
     * values for each setting.
     * /ssm/parameter-store/default-parameter-tier: Standard,
     * Advanced, Intelligent-Tiering
     * /ssm/parameter-store/high-throughput-enabled: true or
     * false
     * /ssm/managed-instance/activation-tier: true or
     * false
     * /ssm/automation/customer-script-log-destination: CloudWatch
     * /ssm/automation/customer-script-log-group-name: the name of an Amazon CloudWatch Logs log group
     * /ssm/documents/console/public-sharing-permission: Enable or
     * Disable
     * /ssm/managed-instance/activation-tier: standard or
     * advanced
     */
    val settingValue: kotlin.String? = builder.settingValue

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServiceSettingRequest(")
        append("settingId=$settingId,")
        append("settingValue=$settingValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = settingId?.hashCode() ?: 0
        result = 31 * result + (settingValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServiceSettingRequest

        if (settingId != other.settingId) return false
        if (settingValue != other.settingValue) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the service setting to reset. For example,
         * arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled.
         * The setting ID can be one of the following.
         * /ssm/automation/customer-script-log-destination
         * /ssm/automation/customer-script-log-group-name
         * /ssm/documents/console/public-sharing-permission
         * /ssm/parameter-store/default-parameter-tier
         * /ssm/parameter-store/high-throughput-enabled
         * /ssm/managed-instance/activation-tier
         */
        var settingId: kotlin.String? = null
        /**
         * The new value to specify for the service setting. The following list specifies the available
         * values for each setting.
         * /ssm/parameter-store/default-parameter-tier: Standard,
         * Advanced, Intelligent-Tiering
         * /ssm/parameter-store/high-throughput-enabled: true or
         * false
         * /ssm/managed-instance/activation-tier: true or
         * false
         * /ssm/automation/customer-script-log-destination: CloudWatch
         * /ssm/automation/customer-script-log-group-name: the name of an Amazon CloudWatch Logs log group
         * /ssm/documents/console/public-sharing-permission: Enable or
         * Disable
         * /ssm/managed-instance/activation-tier: standard or
         * advanced
         */
        var settingValue: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest) : this() {
            this.settingId = x.settingId
            this.settingValue = x.settingValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest = UpdateServiceSettingRequest(this)
    }
}
