// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.DeleteInventoryResponse
import aws.sdk.kotlin.services.ssm.model.InventoryDeletionSummary
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteInventoryOperationDeserializer: HttpDeserialize<DeleteInventoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteInventoryResponse {
        if (!response.status.isSuccess()) {
            throwDeleteInventoryError(context, response)
        }
        val builder = DeleteInventoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteInventoryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDeleteInventoryOperationBody(builder: DeleteInventoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELETIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeletionId"))
    val DELETIONSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeletionSummary"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELETIONID_DESCRIPTOR)
        field(DELETIONSUMMARY_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELETIONID_DESCRIPTOR.index -> builder.deletionId = deserializeString()
                DELETIONSUMMARY_DESCRIPTOR.index -> builder.deletionSummary = deserializeInventoryDeletionSummaryDocument(deserializer)
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDeleteInventoryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidDeleteInventoryParametersException" -> InvalidDeleteInventoryParametersExceptionDeserializer()
        "InvalidInventoryRequestException" -> InvalidInventoryRequestExceptionDeserializer()
        "InvalidOptionException" -> InvalidOptionExceptionDeserializer()
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
