// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
import aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeMaintenanceWindowExecutionTaskInvocationsOperationDeserializer: HttpDeserialize<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeMaintenanceWindowExecutionTaskInvocationsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeMaintenanceWindowExecutionTaskInvocationsError(context, response)
        }
        val builder = DescribeMaintenanceWindowExecutionTaskInvocationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeMaintenanceWindowExecutionTaskInvocationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeMaintenanceWindowExecutionTaskInvocationsOperationBody(builder: DescribeMaintenanceWindowExecutionTaskInvocationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val WINDOWEXECUTIONTASKINVOCATIONIDENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WindowExecutionTaskInvocationIdentities"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(WINDOWEXECUTIONTASKINVOCATIONIDENTITIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                WINDOWEXECUTIONTASKINVOCATIONIDENTITIES_DESCRIPTOR.index -> builder.windowExecutionTaskInvocationIdentities =
                    deserializer.deserializeList(WINDOWEXECUTIONTASKINVOCATIONIDENTITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<MaintenanceWindowExecutionTaskInvocationIdentity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMaintenanceWindowExecutionTaskInvocationIdentityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeMaintenanceWindowExecutionTaskInvocationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer()
        "InternalServerError" -> InternalServerErrorDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
