// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.CalendarState
import aws.sdk.kotlin.services.ssm.model.GetCalendarStateResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCalendarStateOperationDeserializer: HttpDeserialize<GetCalendarStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCalendarStateResponse {
        if (!response.status.isSuccess()) {
            throwGetCalendarStateError(context, response)
        }
        val builder = GetCalendarStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCalendarStateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetCalendarStateOperationBody(builder: GetCalendarStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AtTime"))
    val NEXTTRANSITIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextTransitionTime"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTIME_DESCRIPTOR)
        field(NEXTTRANSITIONTIME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTIME_DESCRIPTOR.index -> builder.atTime = deserializeString()
                NEXTTRANSITIONTIME_DESCRIPTOR.index -> builder.nextTransitionTime = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { CalendarState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetCalendarStateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidDocument" -> InvalidDocumentDeserializer()
        "InvalidDocumentType" -> InvalidDocumentTypeDeserializer()
        "UnsupportedCalendarException" -> UnsupportedCalendarExceptionDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
