// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDeployablePatchSnapshotForInstanceOperationDeserializer: HttpDeserialize<GetDeployablePatchSnapshotForInstanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDeployablePatchSnapshotForInstanceResponse {
        if (!response.status.isSuccess()) {
            throwGetDeployablePatchSnapshotForInstanceError(context, response)
        }
        val builder = GetDeployablePatchSnapshotForInstanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDeployablePatchSnapshotForInstanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetDeployablePatchSnapshotForInstanceOperationBody(builder: GetDeployablePatchSnapshotForInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val PRODUCT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Product"))
    val SNAPSHOTDOWNLOADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnapshotDownloadUrl"))
    val SNAPSHOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnapshotId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCEID_DESCRIPTOR)
        field(PRODUCT_DESCRIPTOR)
        field(SNAPSHOTDOWNLOADURL_DESCRIPTOR)
        field(SNAPSHOTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCEID_DESCRIPTOR.index -> builder.instanceId = deserializeString()
                PRODUCT_DESCRIPTOR.index -> builder.product = deserializeString()
                SNAPSHOTDOWNLOADURL_DESCRIPTOR.index -> builder.snapshotDownloadUrl = deserializeString()
                SNAPSHOTID_DESCRIPTOR.index -> builder.snapshotId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetDeployablePatchSnapshotForInstanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "UnsupportedFeatureRequiredException" -> UnsupportedFeatureRequiredExceptionDeserializer()
        "UnsupportedOperatingSystem" -> UnsupportedOperatingSystemDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
