// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.AttachmentContent
import aws.sdk.kotlin.services.ssm.model.DocumentFormat
import aws.sdk.kotlin.services.ssm.model.DocumentRequires
import aws.sdk.kotlin.services.ssm.model.DocumentStatus
import aws.sdk.kotlin.services.ssm.model.DocumentType
import aws.sdk.kotlin.services.ssm.model.GetDocumentResponse
import aws.sdk.kotlin.services.ssm.model.ReviewStatus
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetDocumentOperationDeserializer: HttpDeserialize<GetDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDocumentResponse {
        if (!response.status.isSuccess()) {
            throwGetDocumentError(context, response)
        }
        val builder = GetDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDocumentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetDocumentOperationBody(builder: GetDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTACHMENTSCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttachmentsContent"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val DOCUMENTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentFormat"))
    val DOCUMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentType"))
    val DOCUMENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentVersion"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REQUIRES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Requires"))
    val REVIEWSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReviewStatus"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val STATUSINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusInformation"))
    val VERSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHMENTSCONTENT_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(DOCUMENTFORMAT_DESCRIPTOR)
        field(DOCUMENTTYPE_DESCRIPTOR)
        field(DOCUMENTVERSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUIRES_DESCRIPTOR)
        field(REVIEWSTATUS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSINFORMATION_DESCRIPTOR)
        field(VERSIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTACHMENTSCONTENT_DESCRIPTOR.index -> builder.attachmentsContent =
                    deserializer.deserializeList(ATTACHMENTSCONTENT_DESCRIPTOR) {
                        val col0 = mutableListOf<AttachmentContent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttachmentContentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                DOCUMENTFORMAT_DESCRIPTOR.index -> builder.documentFormat = deserializeString().let { DocumentFormat.fromValue(it) }
                DOCUMENTTYPE_DESCRIPTOR.index -> builder.documentType = deserializeString().let { DocumentType.fromValue(it) }
                DOCUMENTVERSION_DESCRIPTOR.index -> builder.documentVersion = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REQUIRES_DESCRIPTOR.index -> builder.requires =
                    deserializer.deserializeList(REQUIRES_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentRequires>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentRequiresDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REVIEWSTATUS_DESCRIPTOR.index -> builder.reviewStatus = deserializeString().let { ReviewStatus.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DocumentStatus.fromValue(it) }
                STATUSINFORMATION_DESCRIPTOR.index -> builder.statusInformation = deserializeString()
                VERSIONNAME_DESCRIPTOR.index -> builder.versionName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetDocumentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidDocument" -> InvalidDocumentDeserializer()
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
