// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineForPatchGroupResponse
import aws.sdk.kotlin.services.ssm.model.OperatingSystem
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPatchBaselineForPatchGroupOperationDeserializer: HttpDeserialize<GetPatchBaselineForPatchGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPatchBaselineForPatchGroupResponse {
        if (!response.status.isSuccess()) {
            throwGetPatchBaselineForPatchGroupError(context, response)
        }
        val builder = GetPatchBaselineForPatchGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPatchBaselineForPatchGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetPatchBaselineForPatchGroupOperationBody(builder: GetPatchBaselineForPatchGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASELINEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaselineId"))
    val OPERATINGSYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperatingSystem"))
    val PATCHGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PatchGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASELINEID_DESCRIPTOR)
        field(OPERATINGSYSTEM_DESCRIPTOR)
        field(PATCHGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASELINEID_DESCRIPTOR.index -> builder.baselineId = deserializeString()
                OPERATINGSYSTEM_DESCRIPTOR.index -> builder.operatingSystem = deserializeString().let { OperatingSystem.fromValue(it) }
                PATCHGROUP_DESCRIPTOR.index -> builder.patchGroup = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetPatchBaselineForPatchGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
