// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.GetPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.OperatingSystem
import aws.sdk.kotlin.services.ssm.model.PatchAction
import aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel
import aws.sdk.kotlin.services.ssm.model.PatchFilterGroup
import aws.sdk.kotlin.services.ssm.model.PatchRuleGroup
import aws.sdk.kotlin.services.ssm.model.PatchSource
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetPatchBaselineOperationDeserializer: HttpDeserialize<GetPatchBaselineResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPatchBaselineResponse {
        if (!response.status.isSuccess()) {
            throwGetPatchBaselineError(context, response)
        }
        val builder = GetPatchBaselineResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPatchBaselineOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeGetPatchBaselineOperationBody(builder: GetPatchBaselineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROVALRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApprovalRules"))
    val APPROVEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ApprovedPatches"))
    val APPROVEDPATCHESCOMPLIANCELEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApprovedPatchesComplianceLevel"))
    val APPROVEDPATCHESENABLENONSECURITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ApprovedPatchesEnableNonSecurity"))
    val BASELINEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaselineId"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val GLOBALFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GlobalFilters"))
    val MODIFIEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ModifiedDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OPERATINGSYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperatingSystem"))
    val PATCHGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PatchGroups"))
    val REJECTEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RejectedPatches"))
    val REJECTEDPATCHESACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RejectedPatchesAction"))
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Sources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROVALRULES_DESCRIPTOR)
        field(APPROVEDPATCHES_DESCRIPTOR)
        field(APPROVEDPATCHESCOMPLIANCELEVEL_DESCRIPTOR)
        field(APPROVEDPATCHESENABLENONSECURITY_DESCRIPTOR)
        field(BASELINEID_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(GLOBALFILTERS_DESCRIPTOR)
        field(MODIFIEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OPERATINGSYSTEM_DESCRIPTOR)
        field(PATCHGROUPS_DESCRIPTOR)
        field(REJECTEDPATCHES_DESCRIPTOR)
        field(REJECTEDPATCHESACTION_DESCRIPTOR)
        field(SOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROVALRULES_DESCRIPTOR.index -> builder.approvalRules = deserializePatchRuleGroupDocument(deserializer)
                APPROVEDPATCHES_DESCRIPTOR.index -> builder.approvedPatches =
                    deserializer.deserializeList(APPROVEDPATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                APPROVEDPATCHESCOMPLIANCELEVEL_DESCRIPTOR.index -> builder.approvedPatchesComplianceLevel = deserializeString().let { PatchComplianceLevel.fromValue(it) }
                APPROVEDPATCHESENABLENONSECURITY_DESCRIPTOR.index -> builder.approvedPatchesEnableNonSecurity = deserializeBoolean()
                BASELINEID_DESCRIPTOR.index -> builder.baselineId = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                GLOBALFILTERS_DESCRIPTOR.index -> builder.globalFilters = deserializePatchFilterGroupDocument(deserializer)
                MODIFIEDDATE_DESCRIPTOR.index -> builder.modifiedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OPERATINGSYSTEM_DESCRIPTOR.index -> builder.operatingSystem = deserializeString().let { OperatingSystem.fromValue(it) }
                PATCHGROUPS_DESCRIPTOR.index -> builder.patchGroups =
                    deserializer.deserializeList(PATCHGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REJECTEDPATCHES_DESCRIPTOR.index -> builder.rejectedPatches =
                    deserializer.deserializeList(REJECTEDPATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REJECTEDPATCHESACTION_DESCRIPTOR.index -> builder.rejectedPatchesAction = deserializeString().let { PatchAction.fromValue(it) }
                SOURCES_DESCRIPTOR.index -> builder.sources =
                    deserializer.deserializeList(SOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<PatchSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePatchSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetPatchBaselineError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer()
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidResourceId" -> InvalidResourceIdDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
