// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.ParameterTier
import aws.sdk.kotlin.services.ssm.model.PutParameterResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutParameterOperationDeserializer: HttpDeserialize<PutParameterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutParameterResponse {
        if (!response.status.isSuccess()) {
            throwPutParameterError(context, response)
        }
        val builder = PutParameterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutParameterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializePutParameterOperationBody(builder: PutParameterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Tier"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TIER_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString().let { ParameterTier.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwPutParameterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "HierarchyLevelLimitExceededException" -> HierarchyLevelLimitExceededExceptionDeserializer()
        "HierarchyTypeMismatchException" -> HierarchyTypeMismatchExceptionDeserializer()
        "IncompatiblePolicyException" -> IncompatiblePolicyExceptionDeserializer()
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidAllowedPatternException" -> InvalidAllowedPatternExceptionDeserializer()
        "InvalidKeyId" -> InvalidKeyIdDeserializer()
        "InvalidPolicyAttributeException" -> InvalidPolicyAttributeExceptionDeserializer()
        "InvalidPolicyTypeException" -> InvalidPolicyTypeExceptionDeserializer()
        "ParameterAlreadyExists" -> ParameterAlreadyExistsDeserializer()
        "ParameterLimitExceeded" -> ParameterLimitExceededDeserializer()
        "ParameterMaxVersionLimitExceeded" -> ParameterMaxVersionLimitExceededDeserializer()
        "ParameterPatternMismatchException" -> ParameterPatternMismatchExceptionDeserializer()
        "PoliciesLimitExceededException" -> PoliciesLimitExceededExceptionDeserializer()
        "TooManyUpdates" -> TooManyUpdatesDeserializer()
        "UnsupportedParameterType" -> UnsupportedParameterTypeDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
