// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.Command
import aws.sdk.kotlin.services.ssm.model.SendCommandResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendCommandOperationDeserializer: HttpDeserialize<SendCommandResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SendCommandResponse {
        if (!response.status.isSuccess()) {
            throwSendCommandError(context, response)
        }
        val builder = SendCommandResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendCommandOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeSendCommandOperationBody(builder: SendCommandResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMAND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Command"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMAND_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMAND_DESCRIPTOR.index -> builder.command = deserializeCommandDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwSendCommandError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DuplicateInstanceId" -> DuplicateInstanceIdDeserializer()
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidDocument" -> InvalidDocumentDeserializer()
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer()
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer()
        "InvalidNotificationConfig" -> InvalidNotificationConfigDeserializer()
        "InvalidOutputFolder" -> InvalidOutputFolderDeserializer()
        "InvalidParameters" -> InvalidParametersDeserializer()
        "InvalidRole" -> InvalidRoleDeserializer()
        "MaxDocumentSizeExceeded" -> MaxDocumentSizeExceededDeserializer()
        "UnsupportedPlatformType" -> UnsupportedPlatformTypeDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
