// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.UnlabelParameterVersionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UnlabelParameterVersionOperationDeserializer: HttpDeserialize<UnlabelParameterVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UnlabelParameterVersionResponse {
        if (!response.status.isSuccess()) {
            throwUnlabelParameterVersionError(context, response)
        }
        val builder = UnlabelParameterVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUnlabelParameterVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeUnlabelParameterVersionOperationBody(builder: UnlabelParameterVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INVALIDLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InvalidLabels"))
    val REMOVEDLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RemovedLabels"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INVALIDLABELS_DESCRIPTOR)
        field(REMOVEDLABELS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INVALIDLABELS_DESCRIPTOR.index -> builder.invalidLabels =
                    deserializer.deserializeList(INVALIDLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REMOVEDLABELS_DESCRIPTOR.index -> builder.removedLabels =
                    deserializer.deserializeList(REMOVEDLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUnlabelParameterVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "ParameterNotFound" -> ParameterNotFoundDeserializer()
        "ParameterVersionNotFound" -> ParameterVersionNotFoundDeserializer()
        "TooManyUpdates" -> TooManyUpdatesDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
