// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentMetadataResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateDocumentMetadataOperationDeserializer: HttpDeserialize<UpdateDocumentMetadataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDocumentMetadataResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDocumentMetadataError(context, response)
        }
        val builder = UpdateDocumentMetadataResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateDocumentMetadataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidDocument" -> InvalidDocumentDeserializer()
        "InvalidDocumentOperation" -> InvalidDocumentOperationDeserializer()
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
