// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.DocumentDescription
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.UpdateDocumentResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDocumentOperationDeserializer: HttpDeserialize<UpdateDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDocumentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDocumentError(context, response)
        }
        val builder = UpdateDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDocumentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeUpdateDocumentOperationBody(builder: UpdateDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOCUMENTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENTDESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOCUMENTDESCRIPTION_DESCRIPTOR.index -> builder.documentDescription = deserializeDocumentDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwUpdateDocumentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DocumentVersionLimitExceeded" -> DocumentVersionLimitExceededDeserializer()
        "DuplicateDocumentContent" -> DuplicateDocumentContentDeserializer()
        "DuplicateDocumentVersionName" -> DuplicateDocumentVersionNameDeserializer()
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidDocument" -> InvalidDocumentDeserializer()
        "InvalidDocumentContent" -> InvalidDocumentContentDeserializer()
        "InvalidDocumentOperation" -> InvalidDocumentOperationDeserializer()
        "InvalidDocumentSchemaVersion" -> InvalidDocumentSchemaVersionDeserializer()
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer()
        "MaxDocumentSizeExceeded" -> MaxDocumentSizeExceededDeserializer()
        else -> throw SsmException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
