// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ssm.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ssm.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Systems Manager is a collection of capabilities that helps you automate management tasks such as
 * collecting system inventory, applying operating system (OS) patches, automating the creation of
 * Amazon Machine Images (AMIs), and configuring operating systems (OSs) and applications at scale.
 * Systems Manager lets you remotely and securely manage the configuration of your managed nodes. A
 * managed node is any Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises
 * server or virtual machine (VM) that has been configured for Systems Manager.
 *
 * With support for IoT Greengrass core devices, the phrase managed
 * instance has been changed to managed node in most of the Systems Manager
 * documentation. The Systems Manager console, API calls, error messages, and SSM documents still use the
 * term instance.
 *
 * This reference is intended to be used with the <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/">Amazon Web Services Systems Manager User Guide.
 * To get started, verify prerequisites and configure managed nodes. For more information, see
 * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up
 * Amazon Web Services Systems Manager in the Amazon Web Services Systems Manager User Guide.
 * <p class="title">
 * Related resources
 *
 *
 * For information about how to use a Query API, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/making-api-requests.html">Making API requests.
 *
 * For information about other API operations you can perform on EC2 instances, see the
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/">Amazon EC2 API Reference.
 *
 * For information about AppConfig, a capability of Systems Manager, see the <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/">AppConfig User Guide and the <a href="https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/">AppConfig API
 * Reference.
 *
 * For information about Incident Manager, a capability of Systems Manager, see the <a href="https://docs.aws.amazon.com/incident-manager/latest/userguide/">Incident Manager User Guide
 * and the <a href="https://docs.aws.amazon.com/incident-manager/latest/APIReference/">Incident Manager API
 * Reference.
 */
interface SsmClient : SdkClient {

    override val serviceName: String
        get() = "SSM"
    /**
     * SsmClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): SsmClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSsmClient(config)
        }

        operator fun invoke(config: Config): SsmClient = DefaultSsmClient(config)

        /**
         * Construct a [SsmClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SsmClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultSsmClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you
     * can assign to your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and
     * patch baselines. Tags enable you to categorize your resources in different ways, for example, by
     * purpose, owner, or environment. Each tag consists of a key and an optional value, both of which
     * you define. For example, you could define a set of tags for your account's managed nodes that
     * helps you track each node's owner and stack level. For example:
     *
     *
     *
     * Key=Owner,Value=DbAdmin
     *
     *
     *
     * Key=Owner,Value=SysAdmin
     *
     *
     *
     * Key=Owner,Value=Dev
     *
     *
     *
     * Key=Stack,Value=Production
     *
     *
     *
     * Key=Stack,Value=Pre-Production
     *
     *
     *
     * Key=Stack,Value=Test
     *
     *
     *
     * Most resources can have a maximum of 50 tags. Automations can have a maximum of 5 tags.
     * We recommend that you devise a set of tag keys that meets your needs for each resource type.
     * Using a consistent set of tag keys makes it easier for you to manage your resources. You can
     * search and filter the resources based on the tags you add. Tags don't have any semantic meaning
     * to and are interpreted strictly as a string of characters.
     * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2
     * resources in the Amazon EC2 User Guide.
     */
    suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you
     * can assign to your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and
     * patch baselines. Tags enable you to categorize your resources in different ways, for example, by
     * purpose, owner, or environment. Each tag consists of a key and an optional value, both of which
     * you define. For example, you could define a set of tags for your account's managed nodes that
     * helps you track each node's owner and stack level. For example:
     *
     *
     *
     * Key=Owner,Value=DbAdmin
     *
     *
     *
     * Key=Owner,Value=SysAdmin
     *
     *
     *
     * Key=Owner,Value=Dev
     *
     *
     *
     * Key=Stack,Value=Production
     *
     *
     *
     * Key=Stack,Value=Pre-Production
     *
     *
     *
     * Key=Stack,Value=Test
     *
     *
     *
     * Most resources can have a maximum of 50 tags. Automations can have a maximum of 5 tags.
     * We recommend that you devise a set of tag keys that meets your needs for each resource type.
     * Using a consistent set of tag keys makes it easier for you to manage your resources. You can
     * search and filter the resources based on the tags you add. Tags don't have any semantic meaning
     * to and are interpreted strictly as a string of characters.
     * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2
     * resources in the Amazon EC2 User Guide.
     */
    suspend fun addTagsToResource(block: AddTagsToResourceRequest.Builder.() -> Unit) = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

    /**
     * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an
     * Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of
     * Amazon Web Services Systems Manager.
     */
    suspend fun associateOpsItemRelatedItem(input: AssociateOpsItemRelatedItemRequest): AssociateOpsItemRelatedItemResponse

    /**
     * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an
     * Incident Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of
     * Amazon Web Services Systems Manager.
     */
    suspend fun associateOpsItemRelatedItem(block: AssociateOpsItemRelatedItemRequest.Builder.() -> Unit) = associateOpsItemRelatedItem(AssociateOpsItemRelatedItemRequest.Builder().apply(block).build())

    /**
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the
     * command will be terminated and the underlying process stopped.
     */
    suspend fun cancelCommand(input: CancelCommandRequest): CancelCommandResponse

    /**
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the
     * command will be terminated and the underlying process stopped.
     */
    suspend fun cancelCommand(block: CancelCommandRequest.Builder.() -> Unit) = cancelCommand(CancelCommandRequest.Builder().apply(block).build())

    /**
     * Stops a maintenance window execution that is already in progress and cancels any tasks in
     * the window that haven't already starting running. Tasks already in progress will continue to
     * completion.
     */
    suspend fun cancelMaintenanceWindowExecution(input: CancelMaintenanceWindowExecutionRequest): CancelMaintenanceWindowExecutionResponse

    /**
     * Stops a maintenance window execution that is already in progress and cancels any tasks in
     * the window that haven't already starting running. Tasks already in progress will continue to
     * completion.
     */
    suspend fun cancelMaintenanceWindowExecution(block: CancelMaintenanceWindowExecutionRequest.Builder.() -> Unit) = cancelMaintenanceWindowExecution(CancelMaintenanceWindowExecutionRequest.Builder().apply(block).build())

    /**
     * Generates an activation code and activation ID you can use to register your on-premises
     * servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with
     * Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and
     * ID when installing SSM Agent on machines in your hybrid environment. For more information about
     * requirements for managing on-premises machines using Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting up
     * Amazon Web Services Systems Manager for hybrid environments in the Amazon Web Services Systems Manager User Guide.
     *
     * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are
     * configured for Systems Manager are all called managed nodes.
     */
    suspend fun createActivation(input: CreateActivationRequest): CreateActivationResponse

    /**
     * Generates an activation code and activation ID you can use to register your on-premises
     * servers, edge devices, or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with
     * Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and
     * ID when installing SSM Agent on machines in your hybrid environment. For more information about
     * requirements for managing on-premises machines using Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting up
     * Amazon Web Services Systems Manager for hybrid environments in the Amazon Web Services Systems Manager User Guide.
     *
     * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are
     * configured for Systems Manager are all called managed nodes.
     */
    suspend fun createActivation(block: CreateActivationRequest.Builder.() -> Unit) = createActivation(CreateActivationRequest.Builder().apply(block).build())

    /**
     * A State Manager association defines the state that you want to maintain on your managed
     * nodes. For example, an association can specify that anti-virus software must be installed and
     * running on your managed nodes, or that certain ports must be closed. For static targets, the
     * association specifies a schedule for when the configuration is reapplied. For dynamic targets,
     * such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of
     * Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The
     * association also specifies actions to take when applying the configuration. For example, an
     * association for anti-virus software might run once a day. If the software isn't installed, then
     * State Manager installs it. If the software is installed, but the service isn't running, then the
     * association might instruct State Manager to start the service.
     */
    suspend fun createAssociation(input: CreateAssociationRequest): CreateAssociationResponse

    /**
     * A State Manager association defines the state that you want to maintain on your managed
     * nodes. For example, an association can specify that anti-virus software must be installed and
     * running on your managed nodes, or that certain ports must be closed. For static targets, the
     * association specifies a schedule for when the configuration is reapplied. For dynamic targets,
     * such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of
     * Amazon Web Services Systems Manager applies the configuration when new managed nodes are added to the group. The
     * association also specifies actions to take when applying the configuration. For example, an
     * association for anti-virus software might run once a day. If the software isn't installed, then
     * State Manager installs it. If the software is installed, but the service isn't running, then the
     * association might instruct State Manager to start the service.
     */
    suspend fun createAssociation(block: CreateAssociationRequest.Builder.() -> Unit) = createAssociation(CreateAssociationRequest.Builder().apply(block).build())

    /**
     * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes
     * or targets.
     * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager
     * Agent (SSM Agent) running on the managed node processes the document and configures the node as
     * specified.
     * If you associate a document with a managed node that already has an associated document, the
     * system returns the AssociationAlreadyExists exception.
     */
    suspend fun createAssociationBatch(input: CreateAssociationBatchRequest): CreateAssociationBatchResponse

    /**
     * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed nodes
     * or targets.
     * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems Manager
     * Agent (SSM Agent) running on the managed node processes the document and configures the node as
     * specified.
     * If you associate a document with a managed node that already has an associated document, the
     * system returns the AssociationAlreadyExists exception.
     */
    suspend fun createAssociationBatch(block: CreateAssociationBatchRequest.Builder.() -> Unit) = createAssociationBatch(CreateAssociationBatchRequest.Builder().apply(block).build())

    /**
     * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs
     * on your managed nodes. For more information about SSM documents, including information about
     * supported schemas, features, and syntax, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services Systems Manager Documents in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun createDocument(input: CreateDocumentRequest): CreateDocumentResponse

    /**
     * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs
     * on your managed nodes. For more information about SSM documents, including information about
     * supported schemas, features, and syntax, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services Systems Manager Documents in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun createDocument(block: CreateDocumentRequest.Builder.() -> Unit) = createDocument(CreateDocumentRequest.Builder().apply(block).build())

    /**
     * Creates a new maintenance window.
     *
     * The value you specify for Duration determines the specific end time for the
     * maintenance window based on the time it begins. No maintenance window tasks are permitted to
     * start after the resulting endtime minus the number of hours you specify for Cutoff.
     * For example, if the maintenance window starts at 3 PM, the duration is three hours, and the
     * value you specify for Cutoff is one hour, no maintenance window tasks can start
     * after 5 PM.
     */
    suspend fun createMaintenanceWindow(input: CreateMaintenanceWindowRequest): CreateMaintenanceWindowResponse

    /**
     * Creates a new maintenance window.
     *
     * The value you specify for Duration determines the specific end time for the
     * maintenance window based on the time it begins. No maintenance window tasks are permitted to
     * start after the resulting endtime minus the number of hours you specify for Cutoff.
     * For example, if the maintenance window starts at 3 PM, the duration is three hours, and the
     * value you specify for Cutoff is one hour, no maintenance window tasks can start
     * after 5 PM.
     */
    suspend fun createMaintenanceWindow(block: CreateMaintenanceWindowRequest.Builder.() -> Unit) = createMaintenanceWindow(CreateMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems Manager OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun createOpsItem(input: CreateOpsItemRequest): CreateOpsItemResponse

    /**
     * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems Manager OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun createOpsItem(block: CreateOpsItemRequest.Builder.() -> Unit) = createOpsItem(CreateOpsItemRequest.Builder().apply(block).build())

    /**
     * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify
     * information about the new application, including the application type.
     */
    suspend fun createOpsMetadata(input: CreateOpsMetadataRequest): CreateOpsMetadataResponse

    /**
     * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API operation to specify
     * information about the new application, including the application type.
     */
    suspend fun createOpsMetadata(block: CreateOpsMetadataRequest.Builder.() -> Unit) = createOpsMetadata(CreateOpsMetadataRequest.Builder().apply(block).build())

    /**
     * Creates a patch baseline.
     *
     * For information about valid key-value pairs in PatchFilters for each supported
     * operating system type, see PatchFilter.
     */
    suspend fun createPatchBaseline(input: CreatePatchBaselineRequest): CreatePatchBaselineResponse

    /**
     * Creates a patch baseline.
     *
     * For information about valid key-value pairs in PatchFilters for each supported
     * operating system type, see PatchFilter.
     */
    suspend fun createPatchBaseline(block: CreatePatchBaselineRequest.Builder.() -> Unit) = createPatchBaseline(CreatePatchBaselineRequest.Builder().apply(block).build())

    /**
     * A resource data sync helps you view data from multiple sources in a single location.
     * Amazon Web Services Systems Manager offers two types of resource data sync: SyncToDestination and
     * SyncFromSource.
     * You can configure Systems Manager Inventory to use the SyncToDestination type to
     * synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring resource data
     * sync for Inventory in the Amazon Web Services Systems Manager User Guide.
     * You can configure Systems Manager Explorer to use the SyncFromSource type to synchronize
     * operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a
     * single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple
     * Amazon Web Services accounts and Amazon Web Services Regions or EntireOrganization by using Organizations. For more
     * information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up Systems Manager
     * Explorer to display data from multiple accounts and Regions in the
     * Amazon Web Services Systems Manager User Guide.
     * A resource data sync is an asynchronous operation that returns immediately. After a
     * successful initial sync is completed, the system continuously syncs data. To check the status of
     * a sync, use the ListResourceDataSync.
     *
     * By default, data isn't encrypted in Amazon S3. We strongly recommend that you
     * enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you
     * secure access to the Amazon S3 bucket by creating a restrictive bucket policy.
     */
    suspend fun createResourceDataSync(input: CreateResourceDataSyncRequest): CreateResourceDataSyncResponse

    /**
     * A resource data sync helps you view data from multiple sources in a single location.
     * Amazon Web Services Systems Manager offers two types of resource data sync: SyncToDestination and
     * SyncFromSource.
     * You can configure Systems Manager Inventory to use the SyncToDestination type to
     * synchronize Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring resource data
     * sync for Inventory in the Amazon Web Services Systems Manager User Guide.
     * You can configure Systems Manager Explorer to use the SyncFromSource type to synchronize
     * operational work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a
     * single Amazon S3 bucket. This type can synchronize OpsItems and OpsData from multiple
     * Amazon Web Services accounts and Amazon Web Services Regions or EntireOrganization by using Organizations. For more
     * information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up Systems Manager
     * Explorer to display data from multiple accounts and Regions in the
     * Amazon Web Services Systems Manager User Guide.
     * A resource data sync is an asynchronous operation that returns immediately. After a
     * successful initial sync is completed, the system continuously syncs data. To check the status of
     * a sync, use the ListResourceDataSync.
     *
     * By default, data isn't encrypted in Amazon S3. We strongly recommend that you
     * enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you
     * secure access to the Amazon S3 bucket by creating a restrictive bucket policy.
     */
    suspend fun createResourceDataSync(block: CreateResourceDataSyncRequest.Builder.() -> Unit) = createResourceDataSync(CreateResourceDataSyncRequest.Builder().apply(block).build())

    /**
     * Deletes an activation. You aren't required to delete an activation. If you delete an
     * activation, you can no longer use it to register additional managed nodes. Deleting an activation
     * doesn't de-register managed nodes. You must manually de-register managed nodes.
     */
    suspend fun deleteActivation(input: DeleteActivationRequest): DeleteActivationResponse

    /**
     * Deletes an activation. You aren't required to delete an activation. If you delete an
     * activation, you can no longer use it to register additional managed nodes. Deleting an activation
     * doesn't de-register managed nodes. You must manually de-register managed nodes.
     */
    suspend fun deleteActivation(block: DeleteActivationRequest.Builder.() -> Unit) = deleteActivation(DeleteActivationRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed
     * node. If you created the association by using the Targets parameter, then you must
     * delete the association by using the association ID.
     * When you disassociate a document from a managed node, it doesn't change the configuration of
     * the node. To change the configuration state of a managed node after you disassociate a document,
     * you must create a new document with the desired configuration and associate it with the
     * node.
     */
    suspend fun deleteAssociation(input: DeleteAssociationRequest): DeleteAssociationResponse

    /**
     * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified managed
     * node. If you created the association by using the Targets parameter, then you must
     * delete the association by using the association ID.
     * When you disassociate a document from a managed node, it doesn't change the configuration of
     * the node. To change the configuration state of a managed node after you disassociate a document,
     * you must create a new document with the desired configuration and associate it with the
     * node.
     */
    suspend fun deleteAssociation(block: DeleteAssociationRequest.Builder.() -> Unit) = deleteAssociation(DeleteAssociationRequest.Builder().apply(block).build())

    /**
     * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the
     * document.
     * Before you delete the document, we recommend that you use DeleteAssociation to disassociate all managed nodes that are associated with the document.
     */
    suspend fun deleteDocument(input: DeleteDocumentRequest): DeleteDocumentResponse

    /**
     * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the
     * document.
     * Before you delete the document, we recommend that you use DeleteAssociation to disassociate all managed nodes that are associated with the document.
     */
    suspend fun deleteDocument(block: DeleteDocumentRequest.Builder.() -> Unit) = deleteDocument(DeleteDocumentRequest.Builder().apply(block).build())

    /**
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting
     * a custom inventory type is also referred to as deleting a custom inventory schema.
     */
    suspend fun deleteInventory(input: DeleteInventoryRequest): DeleteInventoryResponse

    /**
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting
     * a custom inventory type is also referred to as deleting a custom inventory schema.
     */
    suspend fun deleteInventory(block: DeleteInventoryRequest.Builder.() -> Unit) = deleteInventory(DeleteInventoryRequest.Builder().apply(block).build())

    /**
     * Deletes a maintenance window.
     */
    suspend fun deleteMaintenanceWindow(input: DeleteMaintenanceWindowRequest): DeleteMaintenanceWindowResponse

    /**
     * Deletes a maintenance window.
     */
    suspend fun deleteMaintenanceWindow(block: DeleteMaintenanceWindowRequest.Builder.() -> Unit) = deleteMaintenanceWindow(DeleteMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Delete OpsMetadata related to an application.
     */
    suspend fun deleteOpsMetadata(input: DeleteOpsMetadataRequest): DeleteOpsMetadataResponse

    /**
     * Delete OpsMetadata related to an application.
     */
    suspend fun deleteOpsMetadata(block: DeleteOpsMetadataRequest.Builder.() -> Unit) = deleteOpsMetadata(DeleteOpsMetadataRequest.Builder().apply(block).build())

    /**
     * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds
     * to create a parameter with the same name.
     */
    suspend fun deleteParameter(input: DeleteParameterRequest): DeleteParameterResponse

    /**
     * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds
     * to create a parameter with the same name.
     */
    suspend fun deleteParameter(block: DeleteParameterRequest.Builder.() -> Unit) = deleteParameter(DeleteParameterRequest.Builder().apply(block).build())

    /**
     * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to
     * create a parameter with the same name.
     */
    suspend fun deleteParameters(input: DeleteParametersRequest): DeleteParametersResponse

    /**
     * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to
     * create a parameter with the same name.
     */
    suspend fun deleteParameters(block: DeleteParametersRequest.Builder.() -> Unit) = deleteParameters(DeleteParametersRequest.Builder().apply(block).build())

    /**
     * Deletes a patch baseline.
     */
    suspend fun deletePatchBaseline(input: DeletePatchBaselineRequest): DeletePatchBaselineResponse

    /**
     * Deletes a patch baseline.
     */
    suspend fun deletePatchBaseline(block: DeletePatchBaselineRequest.Builder.() -> Unit) = deletePatchBaseline(DeletePatchBaselineRequest.Builder().apply(block).build())

    /**
     * Deletes a resource data sync configuration. After the configuration is deleted, changes to
     * data on managed nodes are no longer synced to or from the target. Deleting a sync configuration
     * doesn't delete data.
     */
    suspend fun deleteResourceDataSync(input: DeleteResourceDataSyncRequest): DeleteResourceDataSyncResponse

    /**
     * Deletes a resource data sync configuration. After the configuration is deleted, changes to
     * data on managed nodes are no longer synced to or from the target. Deleting a sync configuration
     * doesn't delete data.
     */
    suspend fun deleteResourceDataSync(block: DeleteResourceDataSyncRequest.Builder.() -> Unit) = deleteResourceDataSync(DeleteResourceDataSyncRequest.Builder().apply(block).build())

    /**
     * Removes the server or virtual machine from the list of registered servers. You can
     * reregister the node again at any time. If you don't plan to use Run Command on the server, we
     * suggest uninstalling SSM Agent first.
     */
    suspend fun deregisterManagedInstance(input: DeregisterManagedInstanceRequest): DeregisterManagedInstanceResponse

    /**
     * Removes the server or virtual machine from the list of registered servers. You can
     * reregister the node again at any time. If you don't plan to use Run Command on the server, we
     * suggest uninstalling SSM Agent first.
     */
    suspend fun deregisterManagedInstance(block: DeregisterManagedInstanceRequest.Builder.() -> Unit) = deregisterManagedInstance(DeregisterManagedInstanceRequest.Builder().apply(block).build())

    /**
     * Removes a patch group from a patch baseline.
     */
    suspend fun deregisterPatchBaselineForPatchGroup(input: DeregisterPatchBaselineForPatchGroupRequest): DeregisterPatchBaselineForPatchGroupResponse

    /**
     * Removes a patch group from a patch baseline.
     */
    suspend fun deregisterPatchBaselineForPatchGroup(block: DeregisterPatchBaselineForPatchGroupRequest.Builder.() -> Unit) = deregisterPatchBaselineForPatchGroup(DeregisterPatchBaselineForPatchGroupRequest.Builder().apply(block).build())

    /**
     * Removes a target from a maintenance window.
     */
    suspend fun deregisterTargetFromMaintenanceWindow(input: DeregisterTargetFromMaintenanceWindowRequest): DeregisterTargetFromMaintenanceWindowResponse

    /**
     * Removes a target from a maintenance window.
     */
    suspend fun deregisterTargetFromMaintenanceWindow(block: DeregisterTargetFromMaintenanceWindowRequest.Builder.() -> Unit) = deregisterTargetFromMaintenanceWindow(DeregisterTargetFromMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Removes a task from a maintenance window.
     */
    suspend fun deregisterTaskFromMaintenanceWindow(input: DeregisterTaskFromMaintenanceWindowRequest): DeregisterTaskFromMaintenanceWindowResponse

    /**
     * Removes a task from a maintenance window.
     */
    suspend fun deregisterTaskFromMaintenanceWindow(block: DeregisterTaskFromMaintenanceWindowRequest.Builder.() -> Unit) = deregisterTaskFromMaintenanceWindow(DeregisterTaskFromMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Describes details about the activation, such as the date and time the activation was
     * created, its expiration date, the Identity and Access Management (IAM) role assigned to
     * the managed nodes in the activation, and the number of nodes registered by using this
     * activation.
     */
    suspend fun describeActivations(input: DescribeActivationsRequest): DescribeActivationsResponse

    /**
     * Describes details about the activation, such as the date and time the activation was
     * created, its expiration date, the Identity and Access Management (IAM) role assigned to
     * the managed nodes in the activation, and the number of nodes registered by using this
     * activation.
     */
    suspend fun describeActivations(block: DescribeActivationsRequest.Builder.() -> Unit) = describeActivations(DescribeActivationsRequest.Builder().apply(block).build())

    /**
     * Describes the association for the specified target or managed node. If you created the
     * association by using the Targets parameter, then you must retrieve the association
     * by using the association ID.
     */
    suspend fun describeAssociation(input: DescribeAssociationRequest): DescribeAssociationResponse

    /**
     * Describes the association for the specified target or managed node. If you created the
     * association by using the Targets parameter, then you must retrieve the association
     * by using the association ID.
     */
    suspend fun describeAssociation(block: DescribeAssociationRequest.Builder.() -> Unit) = describeAssociation(DescribeAssociationRequest.Builder().apply(block).build())

    /**
     * Views information about a specific execution of a specific association.
     */
    suspend fun describeAssociationExecutionTargets(input: DescribeAssociationExecutionTargetsRequest): DescribeAssociationExecutionTargetsResponse

    /**
     * Views information about a specific execution of a specific association.
     */
    suspend fun describeAssociationExecutionTargets(block: DescribeAssociationExecutionTargetsRequest.Builder.() -> Unit) = describeAssociationExecutionTargets(DescribeAssociationExecutionTargetsRequest.Builder().apply(block).build())

    /**
     * Views all executions for a specific association ID.
     */
    suspend fun describeAssociationExecutions(input: DescribeAssociationExecutionsRequest): DescribeAssociationExecutionsResponse

    /**
     * Views all executions for a specific association ID.
     */
    suspend fun describeAssociationExecutions(block: DescribeAssociationExecutionsRequest.Builder.() -> Unit) = describeAssociationExecutions(DescribeAssociationExecutionsRequest.Builder().apply(block).build())

    /**
     * Provides details about all active and terminated Automation executions.
     */
    suspend fun describeAutomationExecutions(input: DescribeAutomationExecutionsRequest): DescribeAutomationExecutionsResponse

    /**
     * Provides details about all active and terminated Automation executions.
     */
    suspend fun describeAutomationExecutions(block: DescribeAutomationExecutionsRequest.Builder.() -> Unit) = describeAutomationExecutions(DescribeAutomationExecutionsRequest.Builder().apply(block).build())

    /**
     * Information about all active and terminated step executions in an Automation
     * workflow.
     */
    suspend fun describeAutomationStepExecutions(input: DescribeAutomationStepExecutionsRequest): DescribeAutomationStepExecutionsResponse

    /**
     * Information about all active and terminated step executions in an Automation
     * workflow.
     */
    suspend fun describeAutomationStepExecutions(block: DescribeAutomationStepExecutionsRequest.Builder.() -> Unit) = describeAutomationStepExecutions(DescribeAutomationStepExecutionsRequest.Builder().apply(block).build())

    /**
     * Lists all patches eligible to be included in a patch baseline.
     */
    suspend fun describeAvailablePatches(input: DescribeAvailablePatchesRequest): DescribeAvailablePatchesResponse

    /**
     * Lists all patches eligible to be included in a patch baseline.
     */
    suspend fun describeAvailablePatches(block: DescribeAvailablePatchesRequest.Builder.() -> Unit) = describeAvailablePatches(DescribeAvailablePatchesRequest.Builder().apply(block).build())

    /**
     * Describes the specified Amazon Web Services Systems Manager document (SSM document).
     */
    suspend fun describeDocument(input: DescribeDocumentRequest): DescribeDocumentResponse

    /**
     * Describes the specified Amazon Web Services Systems Manager document (SSM document).
     */
    suspend fun describeDocument(block: DescribeDocumentRequest.Builder.() -> Unit) = describeDocument(DescribeDocumentRequest.Builder().apply(block).build())

    /**
     * Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the
     * document, you are the owner. If a document is shared, it can either be shared privately (by
     * specifying a user's Amazon Web Services account ID) or publicly (All).
     */
    suspend fun describeDocumentPermission(input: DescribeDocumentPermissionRequest): DescribeDocumentPermissionResponse

    /**
     * Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the
     * document, you are the owner. If a document is shared, it can either be shared privately (by
     * specifying a user's Amazon Web Services account ID) or publicly (All).
     */
    suspend fun describeDocumentPermission(block: DescribeDocumentPermissionRequest.Builder.() -> Unit) = describeDocumentPermission(DescribeDocumentPermissionRequest.Builder().apply(block).build())

    /**
     * All associations for the managed node(s).
     */
    suspend fun describeEffectiveInstanceAssociations(input: DescribeEffectiveInstanceAssociationsRequest): DescribeEffectiveInstanceAssociationsResponse

    /**
     * All associations for the managed node(s).
     */
    suspend fun describeEffectiveInstanceAssociations(block: DescribeEffectiveInstanceAssociationsRequest.Builder.() -> Unit) = describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsRequest.Builder().apply(block).build())

    /**
     * Retrieves the current effective patches (the patch and the approval state) for the specified
     * patch baseline. Applies to patch baselines for Windows only.
     */
    suspend fun describeEffectivePatchesForPatchBaseline(input: DescribeEffectivePatchesForPatchBaselineRequest): DescribeEffectivePatchesForPatchBaselineResponse

    /**
     * Retrieves the current effective patches (the patch and the approval state) for the specified
     * patch baseline. Applies to patch baselines for Windows only.
     */
    suspend fun describeEffectivePatchesForPatchBaseline(block: DescribeEffectivePatchesForPatchBaselineRequest.Builder.() -> Unit) = describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineRequest.Builder().apply(block).build())

    /**
     * The status of the associations for the managed node(s).
     */
    suspend fun describeInstanceAssociationsStatus(input: DescribeInstanceAssociationsStatusRequest): DescribeInstanceAssociationsStatusResponse

    /**
     * The status of the associations for the managed node(s).
     */
    suspend fun describeInstanceAssociationsStatus(block: DescribeInstanceAssociationsStatusRequest.Builder.() -> Unit) = describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusRequest.Builder().apply(block).build())

    /**
     * Describes one or more of your managed nodes, including information about the operating
     * system platform, the version of SSM Agent installed on the managed node, node status, and so
     * on.
     * If you specify one or more managed node IDs, it returns information for those managed nodes.
     * If you don't specify node IDs, it returns information for all your managed nodes. If you specify
     * a node ID that isn't valid or a node that you don't own, you receive an error.
     *
     * The IamRole field for this API operation is the Identity and Access Management
     * (IAM) role assigned to on-premises managed nodes. This call doesn't return the
     * IAM role for EC2 instances.
     */
    suspend fun describeInstanceInformation(input: DescribeInstanceInformationRequest): DescribeInstanceInformationResponse

    /**
     * Describes one or more of your managed nodes, including information about the operating
     * system platform, the version of SSM Agent installed on the managed node, node status, and so
     * on.
     * If you specify one or more managed node IDs, it returns information for those managed nodes.
     * If you don't specify node IDs, it returns information for all your managed nodes. If you specify
     * a node ID that isn't valid or a node that you don't own, you receive an error.
     *
     * The IamRole field for this API operation is the Identity and Access Management
     * (IAM) role assigned to on-premises managed nodes. This call doesn't return the
     * IAM role for EC2 instances.
     */
    suspend fun describeInstanceInformation(block: DescribeInstanceInformationRequest.Builder.() -> Unit) = describeInstanceInformation(DescribeInstanceInformationRequest.Builder().apply(block).build())

    /**
     * Retrieves the high-level patch state of one or more managed nodes.
     */
    suspend fun describeInstancePatchStates(input: DescribeInstancePatchStatesRequest): DescribeInstancePatchStatesResponse

    /**
     * Retrieves the high-level patch state of one or more managed nodes.
     */
    suspend fun describeInstancePatchStates(block: DescribeInstancePatchStatesRequest.Builder.() -> Unit) = describeInstancePatchStates(DescribeInstancePatchStatesRequest.Builder().apply(block).build())

    /**
     * Retrieves the high-level patch state for the managed nodes in the specified patch
     * group.
     */
    suspend fun describeInstancePatchStatesForPatchGroup(input: DescribeInstancePatchStatesForPatchGroupRequest): DescribeInstancePatchStatesForPatchGroupResponse

    /**
     * Retrieves the high-level patch state for the managed nodes in the specified patch
     * group.
     */
    suspend fun describeInstancePatchStatesForPatchGroup(block: DescribeInstancePatchStatesForPatchGroupRequest.Builder.() -> Unit) = describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the patches on the specified managed node and their state
     * relative to the patch baseline being used for the node.
     */
    suspend fun describeInstancePatches(input: DescribeInstancePatchesRequest): DescribeInstancePatchesResponse

    /**
     * Retrieves information about the patches on the specified managed node and their state
     * relative to the patch baseline being used for the node.
     */
    suspend fun describeInstancePatches(block: DescribeInstancePatchesRequest.Builder.() -> Unit) = describeInstancePatches(DescribeInstancePatchesRequest.Builder().apply(block).build())

    /**
     * Describes a specific delete inventory operation.
     */
    suspend fun describeInventoryDeletions(input: DescribeInventoryDeletionsRequest): DescribeInventoryDeletionsResponse

    /**
     * Describes a specific delete inventory operation.
     */
    suspend fun describeInventoryDeletions(block: DescribeInventoryDeletionsRequest.Builder.() -> Unit) = describeInventoryDeletions(DescribeInventoryDeletionsRequest.Builder().apply(block).build())

    /**
     * Retrieves the individual task executions (one per target) for a particular task run as part
     * of a maintenance window execution.
     */
    suspend fun describeMaintenanceWindowExecutionTaskInvocations(input: DescribeMaintenanceWindowExecutionTaskInvocationsRequest): DescribeMaintenanceWindowExecutionTaskInvocationsResponse

    /**
     * Retrieves the individual task executions (one per target) for a particular task run as part
     * of a maintenance window execution.
     */
    suspend fun describeMaintenanceWindowExecutionTaskInvocations(block: DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder.() -> Unit) = describeMaintenanceWindowExecutionTaskInvocations(DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder().apply(block).build())

    /**
     * For a given maintenance window execution, lists the tasks that were run.
     */
    suspend fun describeMaintenanceWindowExecutionTasks(input: DescribeMaintenanceWindowExecutionTasksRequest): DescribeMaintenanceWindowExecutionTasksResponse

    /**
     * For a given maintenance window execution, lists the tasks that were run.
     */
    suspend fun describeMaintenanceWindowExecutionTasks(block: DescribeMaintenanceWindowExecutionTasksRequest.Builder.() -> Unit) = describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksRequest.Builder().apply(block).build())

    /**
     * Lists the executions of a maintenance window. This includes information about when the
     * maintenance window was scheduled to be active, and information about tasks registered and run
     * with the maintenance window.
     */
    suspend fun describeMaintenanceWindowExecutions(input: DescribeMaintenanceWindowExecutionsRequest): DescribeMaintenanceWindowExecutionsResponse

    /**
     * Lists the executions of a maintenance window. This includes information about when the
     * maintenance window was scheduled to be active, and information about tasks registered and run
     * with the maintenance window.
     */
    suspend fun describeMaintenanceWindowExecutions(block: DescribeMaintenanceWindowExecutionsRequest.Builder.() -> Unit) = describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsRequest.Builder().apply(block).build())

    /**
     * Retrieves information about upcoming executions of a maintenance window.
     */
    suspend fun describeMaintenanceWindowSchedule(input: DescribeMaintenanceWindowScheduleRequest): DescribeMaintenanceWindowScheduleResponse

    /**
     * Retrieves information about upcoming executions of a maintenance window.
     */
    suspend fun describeMaintenanceWindowSchedule(block: DescribeMaintenanceWindowScheduleRequest.Builder.() -> Unit) = describeMaintenanceWindowSchedule(DescribeMaintenanceWindowScheduleRequest.Builder().apply(block).build())

    /**
     * Lists the targets registered with the maintenance window.
     */
    suspend fun describeMaintenanceWindowTargets(input: DescribeMaintenanceWindowTargetsRequest): DescribeMaintenanceWindowTargetsResponse

    /**
     * Lists the targets registered with the maintenance window.
     */
    suspend fun describeMaintenanceWindowTargets(block: DescribeMaintenanceWindowTargetsRequest.Builder.() -> Unit) = describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsRequest.Builder().apply(block).build())

    /**
     * Lists the tasks in a maintenance window.
     *
     * For maintenance window tasks without a specified target, you can't supply values for
     * --max-errors and --max-concurrency. Instead, the system inserts a
     * placeholder value of 1, which may be reported in the response to this command.
     * These values don't affect the running of your task and can be ignored.
     */
    suspend fun describeMaintenanceWindowTasks(input: DescribeMaintenanceWindowTasksRequest): DescribeMaintenanceWindowTasksResponse

    /**
     * Lists the tasks in a maintenance window.
     *
     * For maintenance window tasks without a specified target, you can't supply values for
     * --max-errors and --max-concurrency. Instead, the system inserts a
     * placeholder value of 1, which may be reported in the response to this command.
     * These values don't affect the running of your task and can be ignored.
     */
    suspend fun describeMaintenanceWindowTasks(block: DescribeMaintenanceWindowTasksRequest.Builder.() -> Unit) = describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksRequest.Builder().apply(block).build())

    /**
     * Retrieves the maintenance windows in an Amazon Web Services account.
     */
    suspend fun describeMaintenanceWindows(input: DescribeMaintenanceWindowsRequest): DescribeMaintenanceWindowsResponse

    /**
     * Retrieves the maintenance windows in an Amazon Web Services account.
     */
    suspend fun describeMaintenanceWindows(block: DescribeMaintenanceWindowsRequest.Builder.() -> Unit) = describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.Builder().apply(block).build())

    /**
     * Retrieves information about the maintenance window targets or tasks that a managed node is
     * associated with.
     */
    suspend fun describeMaintenanceWindowsForTarget(input: DescribeMaintenanceWindowsForTargetRequest): DescribeMaintenanceWindowsForTargetResponse

    /**
     * Retrieves information about the maintenance window targets or tasks that a managed node is
     * associated with.
     */
    suspend fun describeMaintenanceWindowsForTarget(block: DescribeMaintenanceWindowsForTargetRequest.Builder.() -> Unit) = describeMaintenanceWindowsForTarget(DescribeMaintenanceWindowsForTargetRequest.Builder().apply(block).build())

    /**
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun describeOpsItems(input: DescribeOpsItemsRequest): DescribeOpsItemsResponse

    /**
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun describeOpsItems(block: DescribeOpsItemsRequest.Builder.() -> Unit) = describeOpsItems(DescribeOpsItemsRequest.Builder().apply(block).build())

    /**
     * Get information about a parameter.
     * Request results are returned on a best-effort basis. If you specify MaxResults
     * in the request, the response includes information up to the limit specified. The number of items
     * returned, however, can be between zero and the value of MaxResults. If the service
     * reaches an internal limit while processing the results, it stops the operation and returns the
     * matching values up to that point and a NextToken. You can specify the
     * NextToken in a subsequent call to get the next set of results.
     *
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must
     * also update the key alias the parameter uses to reference KMS. Otherwise,
     * DescribeParameters retrieves whatever the original key alias was
     * referencing.
     */
    suspend fun describeParameters(input: DescribeParametersRequest): DescribeParametersResponse

    /**
     * Get information about a parameter.
     * Request results are returned on a best-effort basis. If you specify MaxResults
     * in the request, the response includes information up to the limit specified. The number of items
     * returned, however, can be between zero and the value of MaxResults. If the service
     * reaches an internal limit while processing the results, it stops the operation and returns the
     * matching values up to that point and a NextToken. You can specify the
     * NextToken in a subsequent call to get the next set of results.
     *
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must
     * also update the key alias the parameter uses to reference KMS. Otherwise,
     * DescribeParameters retrieves whatever the original key alias was
     * referencing.
     */
    suspend fun describeParameters(block: DescribeParametersRequest.Builder.() -> Unit) = describeParameters(DescribeParametersRequest.Builder().apply(block).build())

    /**
     * Lists the patch baselines in your Amazon Web Services account.
     */
    suspend fun describePatchBaselines(input: DescribePatchBaselinesRequest): DescribePatchBaselinesResponse

    /**
     * Lists the patch baselines in your Amazon Web Services account.
     */
    suspend fun describePatchBaselines(block: DescribePatchBaselinesRequest.Builder.() -> Unit) = describePatchBaselines(DescribePatchBaselinesRequest.Builder().apply(block).build())

    /**
     * Returns high-level aggregated patch compliance state information for a patch group.
     */
    suspend fun describePatchGroupState(input: DescribePatchGroupStateRequest): DescribePatchGroupStateResponse

    /**
     * Returns high-level aggregated patch compliance state information for a patch group.
     */
    suspend fun describePatchGroupState(block: DescribePatchGroupStateRequest.Builder.() -> Unit) = describePatchGroupState(DescribePatchGroupStateRequest.Builder().apply(block).build())

    /**
     * Lists all patch groups that have been registered with patch baselines.
     */
    suspend fun describePatchGroups(input: DescribePatchGroupsRequest): DescribePatchGroupsResponse

    /**
     * Lists all patch groups that have been registered with patch baselines.
     */
    suspend fun describePatchGroups(block: DescribePatchGroupsRequest.Builder.() -> Unit) = describePatchGroups(DescribePatchGroupsRequest.Builder().apply(block).build())

    /**
     * Lists the properties of available patches organized by product, product family,
     * classification, severity, and other properties of available patches. You can use the reported
     * properties in the filters you specify in requests for operations such as CreatePatchBaseline, UpdatePatchBaseline, DescribeAvailablePatches, and DescribePatchBaselines.
     * The following section lists the properties that can be used in filters for each major
     * operating system type:
     *
     * AMAZON_LINUX
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * AMAZON_LINUX_2
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * CENTOS
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * DEBIAN
     *
     * Valid properties: PRODUCT | PRIORITY
     *
     *
     * MACOS
     *
     * Valid properties: PRODUCT | CLASSIFICATION
     *
     *
     * ORACLE_LINUX
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * REDHAT_ENTERPRISE_LINUX
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * SUSE
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * UBUNTU
     *
     * Valid properties: PRODUCT | PRIORITY
     *
     *
     * WINDOWS
     *
     * Valid properties: PRODUCT | PRODUCT_FAMILY |
     * CLASSIFICATION | MSRC_SEVERITY
     */
    suspend fun describePatchProperties(input: DescribePatchPropertiesRequest): DescribePatchPropertiesResponse

    /**
     * Lists the properties of available patches organized by product, product family,
     * classification, severity, and other properties of available patches. You can use the reported
     * properties in the filters you specify in requests for operations such as CreatePatchBaseline, UpdatePatchBaseline, DescribeAvailablePatches, and DescribePatchBaselines.
     * The following section lists the properties that can be used in filters for each major
     * operating system type:
     *
     * AMAZON_LINUX
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * AMAZON_LINUX_2
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * CENTOS
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * DEBIAN
     *
     * Valid properties: PRODUCT | PRIORITY
     *
     *
     * MACOS
     *
     * Valid properties: PRODUCT | CLASSIFICATION
     *
     *
     * ORACLE_LINUX
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * REDHAT_ENTERPRISE_LINUX
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * SUSE
     *
     * Valid properties: PRODUCT | CLASSIFICATION |
     * SEVERITY
     *
     *
     * UBUNTU
     *
     * Valid properties: PRODUCT | PRIORITY
     *
     *
     * WINDOWS
     *
     * Valid properties: PRODUCT | PRODUCT_FAMILY |
     * CLASSIFICATION | MSRC_SEVERITY
     */
    suspend fun describePatchProperties(block: DescribePatchPropertiesRequest.Builder.() -> Unit) = describePatchProperties(DescribePatchPropertiesRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated
     * sessions from the past 30 days.
     */
    suspend fun describeSessions(input: DescribeSessionsRequest): DescribeSessionsResponse

    /**
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated
     * sessions from the past 30 days.
     */
    suspend fun describeSessions(block: DescribeSessionsRequest.Builder.() -> Unit) = describeSessions(DescribeSessionsRequest.Builder().apply(block).build())

    /**
     * Deletes the association between an OpsItem and a related item. For example, this API
     * operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of
     * Amazon Web Services Systems Manager.
     */
    suspend fun disassociateOpsItemRelatedItem(input: DisassociateOpsItemRelatedItemRequest): DisassociateOpsItemRelatedItemResponse

    /**
     * Deletes the association between an OpsItem and a related item. For example, this API
     * operation can delete an Incident Manager incident from an OpsItem. Incident Manager is a capability of
     * Amazon Web Services Systems Manager.
     */
    suspend fun disassociateOpsItemRelatedItem(block: DisassociateOpsItemRelatedItemRequest.Builder.() -> Unit) = disassociateOpsItemRelatedItem(DisassociateOpsItemRelatedItemRequest.Builder().apply(block).build())

    /**
     * Get detailed information about a particular Automation execution.
     */
    suspend fun getAutomationExecution(input: GetAutomationExecutionRequest): GetAutomationExecutionResponse

    /**
     * Get detailed information about a particular Automation execution.
     */
    suspend fun getAutomationExecution(block: GetAutomationExecutionRequest.Builder.() -> Unit) = getAutomationExecution(GetAutomationExecutionRequest.Builder().apply(block).build())

    /**
     * Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If
     * you specify a time, GetCalendarState returns the state of the calendar at that
     * specific time, and returns the next time that the change calendar state will transition. If you
     * don't specify a time, GetCalendarState uses the current time. Change Calendar
     * entries have two possible states: OPEN or CLOSED.
     * If you specify more than one calendar in a request, the command returns the status of
     * OPEN only if all calendars in the request are open. If one or more calendars in the
     * request are closed, the status returned is CLOSED.
     * For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon Web Services Systems Manager Change Calendar in the Amazon Web Services Systems Manager User Guide.
     */
    suspend fun getCalendarState(input: GetCalendarStateRequest): GetCalendarStateResponse

    /**
     * Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time. If
     * you specify a time, GetCalendarState returns the state of the calendar at that
     * specific time, and returns the next time that the change calendar state will transition. If you
     * don't specify a time, GetCalendarState uses the current time. Change Calendar
     * entries have two possible states: OPEN or CLOSED.
     * If you specify more than one calendar in a request, the command returns the status of
     * OPEN only if all calendars in the request are open. If one or more calendars in the
     * request are closed, the status returned is CLOSED.
     * For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon Web Services Systems Manager Change Calendar in the Amazon Web Services Systems Manager User Guide.
     */
    suspend fun getCalendarState(block: GetCalendarStateRequest.Builder.() -> Unit) = getCalendarState(GetCalendarStateRequest.Builder().apply(block).build())

    /**
     * Returns detailed information about command execution for an invocation or plugin.
     *
     * GetCommandInvocation only gives the execution status of a plugin in a document.
     * To get the command execution status on a specific managed node, use ListCommandInvocations. To get the command execution status across managed nodes,
     * use ListCommands.
     */
    suspend fun getCommandInvocation(input: GetCommandInvocationRequest): GetCommandInvocationResponse

    /**
     * Returns detailed information about command execution for an invocation or plugin.
     *
     * GetCommandInvocation only gives the execution status of a plugin in a document.
     * To get the command execution status on a specific managed node, use ListCommandInvocations. To get the command execution status across managed nodes,
     * use ListCommands.
     */
    suspend fun getCommandInvocation(block: GetCommandInvocationRequest.Builder.() -> Unit) = getCommandInvocation(GetCommandInvocationRequest.Builder().apply(block).build())

    /**
     * Retrieves the Session Manager connection status for a managed node to determine whether it is running
     * and ready to receive Session Manager connections.
     */
    suspend fun getConnectionStatus(input: GetConnectionStatusRequest): GetConnectionStatusResponse

    /**
     * Retrieves the Session Manager connection status for a managed node to determine whether it is running
     * and ready to receive Session Manager connections.
     */
    suspend fun getConnectionStatus(block: GetConnectionStatusRequest.Builder.() -> Unit) = getConnectionStatus(GetConnectionStatusRequest.Builder().apply(block).build())

    /**
     * Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * If you don't specify an operating system value, the default patch baseline for Windows is
     * returned.
     */
    suspend fun getDefaultPatchBaseline(input: GetDefaultPatchBaselineRequest): GetDefaultPatchBaselineResponse

    /**
     * Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * If you don't specify an operating system value, the default patch baseline for Windows is
     * returned.
     */
    suspend fun getDefaultPatchBaseline(block: GetDefaultPatchBaselineRequest.Builder.() -> Unit) = getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.Builder().apply(block).build())

    /**
     * Retrieves the current snapshot for the patch baseline the managed node uses. This API is
     * primarily used by the AWS-RunPatchBaseline Systems Manager document (SSM document).
     *
     * If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid
     * this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a capability of
     * Amazon Web Services Systems Manager, with an SSM document that enables you to target a managed node with a script or
     * command. For example, run the command using the AWS-RunShellScript document or the
     * AWS-RunPowerShellScript document.
     */
    suspend fun getDeployablePatchSnapshotForInstance(input: GetDeployablePatchSnapshotForInstanceRequest): GetDeployablePatchSnapshotForInstanceResponse

    /**
     * Retrieves the current snapshot for the patch baseline the managed node uses. This API is
     * primarily used by the AWS-RunPatchBaseline Systems Manager document (SSM document).
     *
     * If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local Amazon Web Services credentials and the operation fails. To avoid
     * this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a capability of
     * Amazon Web Services Systems Manager, with an SSM document that enables you to target a managed node with a script or
     * command. For example, run the command using the AWS-RunShellScript document or the
     * AWS-RunPowerShellScript document.
     */
    suspend fun getDeployablePatchSnapshotForInstance(block: GetDeployablePatchSnapshotForInstanceRequest.Builder.() -> Unit) = getDeployablePatchSnapshotForInstance(GetDeployablePatchSnapshotForInstanceRequest.Builder().apply(block).build())

    /**
     * Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
     */
    suspend fun getDocument(input: GetDocumentRequest): GetDocumentResponse

    /**
     * Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
     */
    suspend fun getDocument(block: GetDocumentRequest.Builder.() -> Unit) = getDocument(GetDocumentRequest.Builder().apply(block).build())

    /**
     * Query inventory information. This includes managed node status, such as Stopped
     * or Terminated.
     */
    suspend fun getInventory(input: GetInventoryRequest): GetInventoryResponse

    /**
     * Query inventory information. This includes managed node status, such as Stopped
     * or Terminated.
     */
    suspend fun getInventory(block: GetInventoryRequest.Builder.() -> Unit) = getInventory(GetInventoryRequest.Builder().apply(block).build())

    /**
     * Return a list of inventory type names for the account, or return a list of attribute names
     * for a specific Inventory item type.
     */
    suspend fun getInventorySchema(input: GetInventorySchemaRequest): GetInventorySchemaResponse

    /**
     * Return a list of inventory type names for the account, or return a list of attribute names
     * for a specific Inventory item type.
     */
    suspend fun getInventorySchema(block: GetInventorySchemaRequest.Builder.() -> Unit) = getInventorySchema(GetInventorySchemaRequest.Builder().apply(block).build())

    /**
     * Retrieves a maintenance window.
     */
    suspend fun getMaintenanceWindow(input: GetMaintenanceWindowRequest): GetMaintenanceWindowResponse

    /**
     * Retrieves a maintenance window.
     */
    suspend fun getMaintenanceWindow(block: GetMaintenanceWindowRequest.Builder.() -> Unit) = getMaintenanceWindow(GetMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Retrieves details about a specific a maintenance window execution.
     */
    suspend fun getMaintenanceWindowExecution(input: GetMaintenanceWindowExecutionRequest): GetMaintenanceWindowExecutionResponse

    /**
     * Retrieves details about a specific a maintenance window execution.
     */
    suspend fun getMaintenanceWindowExecution(block: GetMaintenanceWindowExecutionRequest.Builder.() -> Unit) = getMaintenanceWindowExecution(GetMaintenanceWindowExecutionRequest.Builder().apply(block).build())

    /**
     * Retrieves the details about a specific task run as part of a maintenance window
     * execution.
     */
    suspend fun getMaintenanceWindowExecutionTask(input: GetMaintenanceWindowExecutionTaskRequest): GetMaintenanceWindowExecutionTaskResponse

    /**
     * Retrieves the details about a specific task run as part of a maintenance window
     * execution.
     */
    suspend fun getMaintenanceWindowExecutionTask(block: GetMaintenanceWindowExecutionTaskRequest.Builder.() -> Unit) = getMaintenanceWindowExecutionTask(GetMaintenanceWindowExecutionTaskRequest.Builder().apply(block).build())

    /**
     * Retrieves information about a specific task running on a specific target.
     */
    suspend fun getMaintenanceWindowExecutionTaskInvocation(input: GetMaintenanceWindowExecutionTaskInvocationRequest): GetMaintenanceWindowExecutionTaskInvocationResponse

    /**
     * Retrieves information about a specific task running on a specific target.
     */
    suspend fun getMaintenanceWindowExecutionTaskInvocation(block: GetMaintenanceWindowExecutionTaskInvocationRequest.Builder.() -> Unit) = getMaintenanceWindowExecutionTaskInvocation(GetMaintenanceWindowExecutionTaskInvocationRequest.Builder().apply(block).build())

    /**
     * Retrieves the details of a maintenance window task.
     *
     * For maintenance window tasks without a specified target, you can't supply values for
     * --max-errors and --max-concurrency. Instead, the system inserts a
     * placeholder value of 1, which may be reported in the response to this command.
     * These values don't affect the running of your task and can be ignored.
     *
     * To retrieve a list of tasks in a maintenance window, instead use the DescribeMaintenanceWindowTasks command.
     */
    suspend fun getMaintenanceWindowTask(input: GetMaintenanceWindowTaskRequest): GetMaintenanceWindowTaskResponse

    /**
     * Retrieves the details of a maintenance window task.
     *
     * For maintenance window tasks without a specified target, you can't supply values for
     * --max-errors and --max-concurrency. Instead, the system inserts a
     * placeholder value of 1, which may be reported in the response to this command.
     * These values don't affect the running of your task and can be ignored.
     *
     * To retrieve a list of tasks in a maintenance window, instead use the DescribeMaintenanceWindowTasks command.
     */
    suspend fun getMaintenanceWindowTask(block: GetMaintenanceWindowTaskRequest.Builder.() -> Unit) = getMaintenanceWindowTask(GetMaintenanceWindowTaskRequest.Builder().apply(block).build())

    /**
     * Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun getOpsItem(input: GetOpsItemRequest): GetOpsItemResponse

    /**
     * Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management (IAM) to view information about an OpsItem. For more information,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun getOpsItem(block: GetOpsItemRequest.Builder.() -> Unit) = getOpsItem(GetOpsItemRequest.Builder().apply(block).build())

    /**
     * View operational metadata related to an application in Application Manager.
     */
    suspend fun getOpsMetadata(input: GetOpsMetadataRequest): GetOpsMetadataResponse

    /**
     * View operational metadata related to an application in Application Manager.
     */
    suspend fun getOpsMetadata(block: GetOpsMetadataRequest.Builder.() -> Unit) = getOpsMetadata(GetOpsMetadataRequest.Builder().apply(block).build())

    /**
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators.
     * OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as
     * well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager
     * Explorer.
     */
    suspend fun getOpsSummary(input: GetOpsSummaryRequest): GetOpsSummaryResponse

    /**
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators.
     * OpsData can include information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as
     * well as information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services Systems Manager
     * Explorer.
     */
    suspend fun getOpsSummary(block: GetOpsSummaryRequest.Builder.() -> Unit) = getOpsSummary(GetOpsSummaryRequest.Builder().apply(block).build())

    /**
     * Get information about a single parameter by specifying the parameter name.
     *
     * To get information about more than one parameter at a time, use the GetParameters operation.
     */
    suspend fun getParameter(input: GetParameterRequest): GetParameterResponse

    /**
     * Get information about a single parameter by specifying the parameter name.
     *
     * To get information about more than one parameter at a time, use the GetParameters operation.
     */
    suspend fun getParameter(block: GetParameterRequest.Builder.() -> Unit) = getParameter(GetParameterRequest.Builder().apply(block).build())

    /**
     * Retrieves the history of all changes to a parameter.
     *
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must
     * also update the key alias the parameter uses to reference KMS. Otherwise,
     * GetParameterHistory retrieves whatever the original key alias was
     * referencing.
     */
    suspend fun getParameterHistory(input: GetParameterHistoryRequest): GetParameterHistoryResponse

    /**
     * Retrieves the history of all changes to a parameter.
     *
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must
     * also update the key alias the parameter uses to reference KMS. Otherwise,
     * GetParameterHistory retrieves whatever the original key alias was
     * referencing.
     */
    suspend fun getParameterHistory(block: GetParameterHistoryRequest.Builder.() -> Unit) = getParameterHistory(GetParameterHistoryRequest.Builder().apply(block).build())

    /**
     * Get information about one or more parameters by specifying multiple parameter names.
     *
     * To get information about a single parameter, you can use the GetParameter
     * operation instead.
     */
    suspend fun getParameters(input: GetParametersRequest): GetParametersResponse

    /**
     * Get information about one or more parameters by specifying multiple parameter names.
     *
     * To get information about a single parameter, you can use the GetParameter
     * operation instead.
     */
    suspend fun getParameters(block: GetParametersRequest.Builder.() -> Unit) = getParameters(GetParametersRequest.Builder().apply(block).build())

    /**
     * Retrieve information about one or more parameters in a specific hierarchy.
     * Request results are returned on a best-effort basis. If you specify MaxResults
     * in the request, the response includes information up to the limit specified. The number of items
     * returned, however, can be between zero and the value of MaxResults. If the service
     * reaches an internal limit while processing the results, it stops the operation and returns the
     * matching values up to that point and a NextToken. You can specify the
     * NextToken in a subsequent call to get the next set of results.
     */
    suspend fun getParametersByPath(input: GetParametersByPathRequest): GetParametersByPathResponse

    /**
     * Retrieve information about one or more parameters in a specific hierarchy.
     * Request results are returned on a best-effort basis. If you specify MaxResults
     * in the request, the response includes information up to the limit specified. The number of items
     * returned, however, can be between zero and the value of MaxResults. If the service
     * reaches an internal limit while processing the results, it stops the operation and returns the
     * matching values up to that point and a NextToken. You can specify the
     * NextToken in a subsequent call to get the next set of results.
     */
    suspend fun getParametersByPath(block: GetParametersByPathRequest.Builder.() -> Unit) = getParametersByPath(GetParametersByPathRequest.Builder().apply(block).build())

    /**
     * Retrieves information about a patch baseline.
     */
    suspend fun getPatchBaseline(input: GetPatchBaselineRequest): GetPatchBaselineResponse

    /**
     * Retrieves information about a patch baseline.
     */
    suspend fun getPatchBaseline(block: GetPatchBaselineRequest.Builder.() -> Unit) = getPatchBaseline(GetPatchBaselineRequest.Builder().apply(block).build())

    /**
     * Retrieves the patch baseline that should be used for the specified patch group.
     */
    suspend fun getPatchBaselineForPatchGroup(input: GetPatchBaselineForPatchGroupRequest): GetPatchBaselineForPatchGroupResponse

    /**
     * Retrieves the patch baseline that should be used for the specified patch group.
     */
    suspend fun getPatchBaselineForPatchGroup(block: GetPatchBaselineForPatchGroupRequest.Builder.() -> Unit) = getPatchBaselineForPatchGroup(GetPatchBaselineForPatchGroupRequest.Builder().apply(block).build())

    /**
     * ServiceSetting is an account-level setting for an Amazon Web Services service. This setting
     * defines how a user interacts with or uses a service or a feature of a service. For example, if an
     * Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
     * service team might create a default setting of false. This means the user can't use
     * this feature unless they change the setting to true and intentionally opt in for a
     * paid feature.
     * Services map a SettingId object to a setting value. Amazon Web Services services teams define
     * the default value for a SettingId. You can't create a new SettingId,
     * but you can overwrite the default value if you have the ssm:UpdateServiceSetting
     * permission for the setting. Use the UpdateServiceSetting API operation to
     * change the default setting. Or use the ResetServiceSetting to change the value
     * back to the original value defined by the Amazon Web Services service team.
     * Query the current service setting for the Amazon Web Services account.
     */
    suspend fun getServiceSetting(input: GetServiceSettingRequest): GetServiceSettingResponse

    /**
     * ServiceSetting is an account-level setting for an Amazon Web Services service. This setting
     * defines how a user interacts with or uses a service or a feature of a service. For example, if an
     * Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
     * service team might create a default setting of false. This means the user can't use
     * this feature unless they change the setting to true and intentionally opt in for a
     * paid feature.
     * Services map a SettingId object to a setting value. Amazon Web Services services teams define
     * the default value for a SettingId. You can't create a new SettingId,
     * but you can overwrite the default value if you have the ssm:UpdateServiceSetting
     * permission for the setting. Use the UpdateServiceSetting API operation to
     * change the default setting. Or use the ResetServiceSetting to change the value
     * back to the original value defined by the Amazon Web Services service team.
     * Query the current service setting for the Amazon Web Services account.
     */
    suspend fun getServiceSetting(block: GetServiceSettingRequest.Builder.() -> Unit) = getServiceSetting(GetServiceSettingRequest.Builder().apply(block).build())

    /**
     * A parameter label is a user-defined alias to help you manage different versions of a
     * parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and
     * increments the version number by one. A label can help you remember the purpose of a parameter
     * when there are multiple versions.
     * Parameter labels have the following requirements and restrictions.
     *
     *
     * A version of a parameter can have a maximum of 10 labels.
     *
     * You can't attach the same label to different versions of the same parameter. For example,
     * if version 1 has the label Production, then you can't attach Production to version 2.
     *
     * You can move a label from one version of a parameter to another.
     *
     * You can't create a label when you create a new parameter. You must attach a label to a
     * specific version of a parameter.
     *
     * If you no longer want to use a parameter label, then you can either delete it or move it
     * to a different version of a parameter.
     *
     * A label can have a maximum of 100 characters.
     *
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or
     * underscores (_).
     *
     * Labels can't begin with a number, "aws" or "ssm" (not case
     * sensitive). If a label fails to meet these requirements, then the label isn't associated with a
     * parameter and the system displays it in the list of InvalidLabels.
     */
    suspend fun labelParameterVersion(input: LabelParameterVersionRequest): LabelParameterVersionResponse

    /**
     * A parameter label is a user-defined alias to help you manage different versions of a
     * parameter. When you modify a parameter, Amazon Web Services Systems Manager automatically saves a new version and
     * increments the version number by one. A label can help you remember the purpose of a parameter
     * when there are multiple versions.
     * Parameter labels have the following requirements and restrictions.
     *
     *
     * A version of a parameter can have a maximum of 10 labels.
     *
     * You can't attach the same label to different versions of the same parameter. For example,
     * if version 1 has the label Production, then you can't attach Production to version 2.
     *
     * You can move a label from one version of a parameter to another.
     *
     * You can't create a label when you create a new parameter. You must attach a label to a
     * specific version of a parameter.
     *
     * If you no longer want to use a parameter label, then you can either delete it or move it
     * to a different version of a parameter.
     *
     * A label can have a maximum of 100 characters.
     *
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or
     * underscores (_).
     *
     * Labels can't begin with a number, "aws" or "ssm" (not case
     * sensitive). If a label fails to meet these requirements, then the label isn't associated with a
     * parameter and the system displays it in the list of InvalidLabels.
     */
    suspend fun labelParameterVersion(block: LabelParameterVersionRequest.Builder.() -> Unit) = labelParameterVersion(LabelParameterVersionRequest.Builder().apply(block).build())

    /**
     * Retrieves all versions of an association for a specific association ID.
     */
    suspend fun listAssociationVersions(input: ListAssociationVersionsRequest): ListAssociationVersionsResponse

    /**
     * Retrieves all versions of an association for a specific association ID.
     */
    suspend fun listAssociationVersions(block: ListAssociationVersionsRequest.Builder.() -> Unit) = listAssociationVersions(ListAssociationVersionsRequest.Builder().apply(block).build())

    /**
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You
     * can limit the results to a specific State Manager association document or managed node by
     * specifying a filter. State Manager is a capability of Amazon Web Services Systems Manager.
     */
    suspend fun listAssociations(input: ListAssociationsRequest): ListAssociationsResponse

    /**
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region. You
     * can limit the results to a specific State Manager association document or managed node by
     * specifying a filter. State Manager is a capability of Amazon Web Services Systems Manager.
     */
    suspend fun listAssociations(block: ListAssociationsRequest.Builder.() -> Unit) = listAssociations(ListAssociationsRequest.Builder().apply(block).build())

    /**
     * An invocation is copy of a command sent to a specific managed node. A command can apply to
     * one or more managed nodes. A command invocation applies to one managed node. For example, if a
     * user runs SendCommand against three managed nodes, then a command invocation is
     * created for each requested managed node ID. ListCommandInvocations provide status
     * about command execution.
     */
    suspend fun listCommandInvocations(input: ListCommandInvocationsRequest): ListCommandInvocationsResponse

    /**
     * An invocation is copy of a command sent to a specific managed node. A command can apply to
     * one or more managed nodes. A command invocation applies to one managed node. For example, if a
     * user runs SendCommand against three managed nodes, then a command invocation is
     * created for each requested managed node ID. ListCommandInvocations provide status
     * about command execution.
     */
    suspend fun listCommandInvocations(block: ListCommandInvocationsRequest.Builder.() -> Unit) = listCommandInvocations(ListCommandInvocationsRequest.Builder().apply(block).build())

    /**
     * Lists the commands requested by users of the Amazon Web Services account.
     */
    suspend fun listCommands(input: ListCommandsRequest): ListCommandsResponse

    /**
     * Lists the commands requested by users of the Amazon Web Services account.
     */
    suspend fun listCommands(block: ListCommandsRequest.Builder.() -> Unit) = listCommands(ListCommandsRequest.Builder().apply(block).build())

    /**
     * For a specified resource ID, this API operation returns a list of compliance statuses for
     * different resource types. Currently, you can only specify one resource ID per call. List results
     * depend on the criteria specified in the filter.
     */
    suspend fun listComplianceItems(input: ListComplianceItemsRequest): ListComplianceItemsResponse

    /**
     * For a specified resource ID, this API operation returns a list of compliance statuses for
     * different resource types. Currently, you can only specify one resource ID per call. List results
     * depend on the criteria specified in the filter.
     */
    suspend fun listComplianceItems(block: ListComplianceItemsRequest.Builder.() -> Unit) = listComplianceItems(ListComplianceItemsRequest.Builder().apply(block).build())

    /**
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For
     * example, this call can return State Manager associations, patches, or custom compliance types
     * according to the filter criteria that you specify.
     */
    suspend fun listComplianceSummaries(input: ListComplianceSummariesRequest): ListComplianceSummariesResponse

    /**
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For
     * example, this call can return State Manager associations, patches, or custom compliance types
     * according to the filter criteria that you specify.
     */
    suspend fun listComplianceSummaries(block: ListComplianceSummariesRequest.Builder.() -> Unit) = listComplianceSummaries(ListComplianceSummariesRequest.Builder().apply(block).build())

    /**
     * Information about approval reviews for a version of a change template in Change Manager.
     */
    suspend fun listDocumentMetadataHistory(input: ListDocumentMetadataHistoryRequest): ListDocumentMetadataHistoryResponse

    /**
     * Information about approval reviews for a version of a change template in Change Manager.
     */
    suspend fun listDocumentMetadataHistory(block: ListDocumentMetadataHistoryRequest.Builder.() -> Unit) = listDocumentMetadataHistory(ListDocumentMetadataHistoryRequest.Builder().apply(block).build())

    /**
     * List all versions for a document.
     */
    suspend fun listDocumentVersions(input: ListDocumentVersionsRequest): ListDocumentVersionsResponse

    /**
     * List all versions for a document.
     */
    suspend fun listDocumentVersions(block: ListDocumentVersionsRequest.Builder.() -> Unit) = listDocumentVersions(ListDocumentVersionsRequest.Builder().apply(block).build())

    /**
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can
     * limit the results of this request by using a filter.
     */
    suspend fun listDocuments(input: ListDocumentsRequest): ListDocumentsResponse

    /**
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services Region. You can
     * limit the results of this request by using a filter.
     */
    suspend fun listDocuments(block: ListDocumentsRequest.Builder.() -> Unit) = listDocuments(ListDocumentsRequest.Builder().apply(block).build())

    /**
     * A list of inventory items returned by the request.
     */
    suspend fun listInventoryEntries(input: ListInventoryEntriesRequest): ListInventoryEntriesResponse

    /**
     * A list of inventory items returned by the request.
     */
    suspend fun listInventoryEntries(block: ListInventoryEntriesRequest.Builder.() -> Unit) = listInventoryEntries(ListInventoryEntriesRequest.Builder().apply(block).build())

    /**
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can
     * limit the results to events associated with specific OpsItems by specifying a filter.
     */
    suspend fun listOpsItemEvents(input: ListOpsItemEventsRequest): ListOpsItemEventsResponse

    /**
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account. You can
     * limit the results to events associated with specific OpsItems by specifying a filter.
     */
    suspend fun listOpsItemEvents(block: ListOpsItemEventsRequest.Builder.() -> Unit) = listOpsItemEvents(ListOpsItemEventsRequest.Builder().apply(block).build())

    /**
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a
     * capability of Amazon Web Services Systems Manager.
     */
    suspend fun listOpsItemRelatedItems(input: ListOpsItemRelatedItemsRequest): ListOpsItemRelatedItemsResponse

    /**
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a
     * capability of Amazon Web Services Systems Manager.
     */
    suspend fun listOpsItemRelatedItems(block: ListOpsItemRelatedItemsRequest.Builder.() -> Unit) = listOpsItemRelatedItems(ListOpsItemRelatedItemsRequest.Builder().apply(block).build())

    /**
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or
     * blobs.
     */
    suspend fun listOpsMetadata(input: ListOpsMetadataRequest): ListOpsMetadataResponse

    /**
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata objects or
     * blobs.
     */
    suspend fun listOpsMetadata(block: ListOpsMetadataRequest.Builder.() -> Unit) = listOpsMetadata(ListOpsMetadataRequest.Builder().apply(block).build())

    /**
     * Returns a resource-level summary count. The summary includes information about compliant and
     * non-compliant statuses and detailed compliance-item severity counts, according to the filter
     * criteria you specify.
     */
    suspend fun listResourceComplianceSummaries(input: ListResourceComplianceSummariesRequest): ListResourceComplianceSummariesResponse

    /**
     * Returns a resource-level summary count. The summary includes information about compliant and
     * non-compliant statuses and detailed compliance-item severity counts, according to the filter
     * criteria you specify.
     */
    suspend fun listResourceComplianceSummaries(block: ListResourceComplianceSummariesRequest.Builder.() -> Unit) = listResourceComplianceSummaries(ListResourceComplianceSummariesRequest.Builder().apply(block).build())

    /**
     * Lists your resource data sync configurations. Includes information about the last time a
     * sync attempted to start, the last sync status, and the last time a sync successfully
     * completed.
     * The number of sync configurations might be too large to return using a single call to
     * ListResourceDataSync. You can limit the number of sync configurations returned by
     * using the MaxResults parameter. To determine whether there are more sync
     * configurations to list, check the value of NextToken in the output. If there are
     * more sync configurations to list, you can request them by specifying the NextToken
     * returned in the call to the parameter of a subsequent call.
     */
    suspend fun listResourceDataSync(input: ListResourceDataSyncRequest): ListResourceDataSyncResponse

    /**
     * Lists your resource data sync configurations. Includes information about the last time a
     * sync attempted to start, the last sync status, and the last time a sync successfully
     * completed.
     * The number of sync configurations might be too large to return using a single call to
     * ListResourceDataSync. You can limit the number of sync configurations returned by
     * using the MaxResults parameter. To determine whether there are more sync
     * configurations to list, check the value of NextToken in the output. If there are
     * more sync configurations to list, you can request them by specifying the NextToken
     * returned in the call to the parameter of a subsequent call.
     */
    suspend fun listResourceDataSync(block: ListResourceDataSyncRequest.Builder.() -> Unit) = listResourceDataSync(ListResourceDataSyncRequest.Builder().apply(block).build())

    /**
     * Returns a list of the tags assigned to the specified resource.
     * For information about the ID format for each supported resource type, see AddTagsToResource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the tags assigned to the specified resource.
     * For information about the ID format for each supported resource type, see AddTagsToResource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document
     * privately, you must specify the Amazon Web Services user account IDs for those people who can use the
     * document. If you share a document publicly, you must specify All as the
     * account ID.
     */
    suspend fun modifyDocumentPermission(input: ModifyDocumentPermissionRequest): ModifyDocumentPermissionResponse

    /**
     * Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document
     * privately, you must specify the Amazon Web Services user account IDs for those people who can use the
     * document. If you share a document publicly, you must specify All as the
     * account ID.
     */
    suspend fun modifyDocumentPermission(block: ModifyDocumentPermissionRequest.Builder.() -> Unit) = modifyDocumentPermission(ModifyDocumentPermissionRequest.Builder().apply(block).build())

    /**
     * Registers a compliance type and other compliance details on a designated resource. This
     * operation lets you register custom compliance details with a resource. This call overwrites
     * existing compliance information on the resource, so you must provide a full list of compliance
     * items each time that you send the request.
     * ComplianceType can be one of the following:
     *
     *
     * ExecutionId: The execution ID when the patch, association, or custom compliance item was
     * applied.
     *
     * ExecutionType: Specify patch, association, or Custom:string.
     *
     * ExecutionTime. The time the patch, association, or custom compliance item was applied to
     * the managed node.
     *
     * Id: The patch, association, or custom compliance ID.
     *
     * Title: A title.
     *
     * Status: The status of the compliance item. For example, approved for patches,
     * or Failed for associations.
     *
     * Severity: A patch severity. For example, critical.
     *
     * DocumentName: An SSM document name. For example, AWS-RunPatchBaseline.
     *
     * DocumentVersion: An SSM document version number. For example, 4.
     *
     * Classification: A patch classification. For example, security updates.
     *
     * PatchBaselineId: A patch baseline ID.
     *
     * PatchSeverity: A patch severity. For example, Critical.
     *
     * PatchState: A patch state. For example, InstancesWithFailedPatches.
     *
     * PatchGroup: The name of a patch group.
     *
     * InstalledTime: The time the association, patch, or custom compliance item was applied to
     * the resource. Specify the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'
     */
    suspend fun putComplianceItems(input: PutComplianceItemsRequest): PutComplianceItemsResponse

    /**
     * Registers a compliance type and other compliance details on a designated resource. This
     * operation lets you register custom compliance details with a resource. This call overwrites
     * existing compliance information on the resource, so you must provide a full list of compliance
     * items each time that you send the request.
     * ComplianceType can be one of the following:
     *
     *
     * ExecutionId: The execution ID when the patch, association, or custom compliance item was
     * applied.
     *
     * ExecutionType: Specify patch, association, or Custom:string.
     *
     * ExecutionTime. The time the patch, association, or custom compliance item was applied to
     * the managed node.
     *
     * Id: The patch, association, or custom compliance ID.
     *
     * Title: A title.
     *
     * Status: The status of the compliance item. For example, approved for patches,
     * or Failed for associations.
     *
     * Severity: A patch severity. For example, critical.
     *
     * DocumentName: An SSM document name. For example, AWS-RunPatchBaseline.
     *
     * DocumentVersion: An SSM document version number. For example, 4.
     *
     * Classification: A patch classification. For example, security updates.
     *
     * PatchBaselineId: A patch baseline ID.
     *
     * PatchSeverity: A patch severity. For example, Critical.
     *
     * PatchState: A patch state. For example, InstancesWithFailedPatches.
     *
     * PatchGroup: The name of a patch group.
     *
     * InstalledTime: The time the association, patch, or custom compliance item was applied to
     * the resource. Specify the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'
     */
    suspend fun putComplianceItems(block: PutComplianceItemsRequest.Builder.() -> Unit) = putComplianceItems(PutComplianceItemsRequest.Builder().apply(block).build())

    /**
     * Bulk update custom inventory items on one or more managed nodes. The request adds an
     * inventory item, if it doesn't already exist, or updates an inventory item, if it does
     * exist.
     */
    suspend fun putInventory(input: PutInventoryRequest): PutInventoryResponse

    /**
     * Bulk update custom inventory items on one or more managed nodes. The request adds an
     * inventory item, if it doesn't already exist, or updates an inventory item, if it does
     * exist.
     */
    suspend fun putInventory(block: PutInventoryRequest.Builder.() -> Unit) = putInventory(PutInventoryRequest.Builder().apply(block).build())

    /**
     * Add a parameter to the system.
     */
    suspend fun putParameter(input: PutParameterRequest): PutParameterResponse

    /**
     * Add a parameter to the system.
     */
    suspend fun putParameter(block: PutParameterRequest.Builder.() -> Unit) = putParameter(PutParameterRequest.Builder().apply(block).build())

    /**
     * Defines the default patch baseline for the relevant operating system.
     * To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline
     * Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify
     * arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed instead of
     * pb-0574b43a65ea646ed.
     */
    suspend fun registerDefaultPatchBaseline(input: RegisterDefaultPatchBaselineRequest): RegisterDefaultPatchBaselineResponse

    /**
     * Defines the default patch baseline for the relevant operating system.
     * To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline
     * Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify
     * arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed instead of
     * pb-0574b43a65ea646ed.
     */
    suspend fun registerDefaultPatchBaseline(block: RegisterDefaultPatchBaselineRequest.Builder.() -> Unit) = registerDefaultPatchBaseline(RegisterDefaultPatchBaselineRequest.Builder().apply(block).build())

    /**
     * Registers a patch baseline for a patch group.
     */
    suspend fun registerPatchBaselineForPatchGroup(input: RegisterPatchBaselineForPatchGroupRequest): RegisterPatchBaselineForPatchGroupResponse

    /**
     * Registers a patch baseline for a patch group.
     */
    suspend fun registerPatchBaselineForPatchGroup(block: RegisterPatchBaselineForPatchGroupRequest.Builder.() -> Unit) = registerPatchBaselineForPatchGroup(RegisterPatchBaselineForPatchGroupRequest.Builder().apply(block).build())

    /**
     * Registers a target with a maintenance window.
     */
    suspend fun registerTargetWithMaintenanceWindow(input: RegisterTargetWithMaintenanceWindowRequest): RegisterTargetWithMaintenanceWindowResponse

    /**
     * Registers a target with a maintenance window.
     */
    suspend fun registerTargetWithMaintenanceWindow(block: RegisterTargetWithMaintenanceWindowRequest.Builder.() -> Unit) = registerTargetWithMaintenanceWindow(RegisterTargetWithMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Adds a new task to a maintenance window.
     */
    suspend fun registerTaskWithMaintenanceWindow(input: RegisterTaskWithMaintenanceWindowRequest): RegisterTaskWithMaintenanceWindowResponse

    /**
     * Adds a new task to a maintenance window.
     */
    suspend fun registerTaskWithMaintenanceWindow(block: RegisterTaskWithMaintenanceWindowRequest.Builder.() -> Unit) = registerTaskWithMaintenanceWindow(RegisterTaskWithMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Removes tag keys from the specified resource.
     */
    suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Removes tag keys from the specified resource.
     */
    suspend fun removeTagsFromResource(block: RemoveTagsFromResourceRequest.Builder.() -> Unit) = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

    /**
     * ServiceSetting is an account-level setting for an Amazon Web Services service. This setting
     * defines how a user interacts with or uses a service or a feature of a service. For example, if an
     * Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
     * service team might create a default setting of "false". This means the user can't use this
     * feature unless they change the setting to "true" and intentionally opt in for a paid
     * feature.
     * Services map a SettingId object to a setting value. Amazon Web Services services teams define
     * the default value for a SettingId. You can't create a new SettingId,
     * but you can overwrite the default value if you have the ssm:UpdateServiceSetting
     * permission for the setting. Use the GetServiceSetting API operation to view the
     * current value. Use the UpdateServiceSetting API operation to change the default
     * setting.
     * Reset the service setting for the account to the default value as provisioned by the Amazon Web Services
     * service team.
     */
    suspend fun resetServiceSetting(input: ResetServiceSettingRequest): ResetServiceSettingResponse

    /**
     * ServiceSetting is an account-level setting for an Amazon Web Services service. This setting
     * defines how a user interacts with or uses a service or a feature of a service. For example, if an
     * Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
     * service team might create a default setting of "false". This means the user can't use this
     * feature unless they change the setting to "true" and intentionally opt in for a paid
     * feature.
     * Services map a SettingId object to a setting value. Amazon Web Services services teams define
     * the default value for a SettingId. You can't create a new SettingId,
     * but you can overwrite the default value if you have the ssm:UpdateServiceSetting
     * permission for the setting. Use the GetServiceSetting API operation to view the
     * current value. Use the UpdateServiceSetting API operation to change the default
     * setting.
     * Reset the service setting for the account to the default value as provisioned by the Amazon Web Services
     * service team.
     */
    suspend fun resetServiceSetting(block: ResetServiceSettingRequest.Builder.() -> Unit) = resetServiceSetting(ResetServiceSettingRequest.Builder().apply(block).build())

    /**
     * Reconnects a session to a managed node after it has been disconnected. Connections can be
     * resumed for disconnected sessions, but not terminated sessions.
     *
     * This command is primarily for use by client machines to automatically reconnect during
     * intermittent network issues. It isn't intended for any other use.
     */
    suspend fun resumeSession(input: ResumeSessionRequest): ResumeSessionResponse

    /**
     * Reconnects a session to a managed node after it has been disconnected. Connections can be
     * resumed for disconnected sessions, but not terminated sessions.
     *
     * This command is primarily for use by client machines to automatically reconnect during
     * intermittent network issues. It isn't intended for any other use.
     */
    suspend fun resumeSession(block: ResumeSessionRequest.Builder.() -> Unit) = resumeSession(ResumeSessionRequest.Builder().apply(block).build())

    /**
     * Sends a signal to an Automation execution to change the current behavior or status of the
     * execution.
     */
    suspend fun sendAutomationSignal(input: SendAutomationSignalRequest): SendAutomationSignalResponse

    /**
     * Sends a signal to an Automation execution to change the current behavior or status of the
     * execution.
     */
    suspend fun sendAutomationSignal(block: SendAutomationSignalRequest.Builder.() -> Unit) = sendAutomationSignal(SendAutomationSignalRequest.Builder().apply(block).build())

    /**
     * Runs commands on one or more managed nodes.
     */
    suspend fun sendCommand(input: SendCommandRequest): SendCommandResponse

    /**
     * Runs commands on one or more managed nodes.
     */
    suspend fun sendCommand(block: SendCommandRequest.Builder.() -> Unit) = sendCommand(SendCommandRequest.Builder().apply(block).build())

    /**
     * Runs an association immediately and only one time. This operation can be helpful when
     * troubleshooting associations.
     */
    suspend fun startAssociationsOnce(input: StartAssociationsOnceRequest): StartAssociationsOnceResponse

    /**
     * Runs an association immediately and only one time. This operation can be helpful when
     * troubleshooting associations.
     */
    suspend fun startAssociationsOnce(block: StartAssociationsOnceRequest.Builder.() -> Unit) = startAssociationsOnce(StartAssociationsOnceRequest.Builder().apply(block).build())

    /**
     * Initiates execution of an Automation runbook.
     */
    suspend fun startAutomationExecution(input: StartAutomationExecutionRequest): StartAutomationExecutionResponse

    /**
     * Initiates execution of an Automation runbook.
     */
    suspend fun startAutomationExecution(block: StartAutomationExecutionRequest.Builder.() -> Unit) = startAutomationExecution(StartAutomationExecutionRequest.Builder().apply(block).build())

    /**
     * Creates a change request for Change Manager. The Automation runbooks specified in the
     * change request run only after all required approvals for the change request have been
     * received.
     */
    suspend fun startChangeRequestExecution(input: StartChangeRequestExecutionRequest): StartChangeRequestExecutionResponse

    /**
     * Creates a change request for Change Manager. The Automation runbooks specified in the
     * change request run only after all required approvals for the change request have been
     * received.
     */
    suspend fun startChangeRequestExecution(block: StartChangeRequestExecutionRequest.Builder.() -> Unit) = startChangeRequestExecution(StartChangeRequestExecutionRequest.Builder().apply(block).build())

    /**
     * Initiates a connection to a target (for example, a managed node) for a Session Manager session.
     * Returns a URL and token that can be used to open a WebSocket connection for sending input and
     * receiving outputs.
     *
     * Amazon Web Services CLI usage: start-session is an interactive command that requires the Session Manager
     * plugin to be installed on the client machine making the call. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html">Install
     * the Session Manager plugin for the Amazon Web Services CLI in the Amazon Web Services Systems Manager User Guide.
     * Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services Tools
     * for PowerShell on Windows local machines.
     */
    suspend fun startSession(input: StartSessionRequest): StartSessionResponse

    /**
     * Initiates a connection to a target (for example, a managed node) for a Session Manager session.
     * Returns a URL and token that can be used to open a WebSocket connection for sending input and
     * receiving outputs.
     *
     * Amazon Web Services CLI usage: start-session is an interactive command that requires the Session Manager
     * plugin to be installed on the client machine making the call. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html">Install
     * the Session Manager plugin for the Amazon Web Services CLI in the Amazon Web Services Systems Manager User Guide.
     * Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services Tools
     * for PowerShell on Windows local machines.
     */
    suspend fun startSession(block: StartSessionRequest.Builder.() -> Unit) = startSession(StartSessionRequest.Builder().apply(block).build())

    /**
     * Stop an Automation that is currently running.
     */
    suspend fun stopAutomationExecution(input: StopAutomationExecutionRequest): StopAutomationExecutionResponse

    /**
     * Stop an Automation that is currently running.
     */
    suspend fun stopAutomationExecution(block: StopAutomationExecutionRequest.Builder.() -> Unit) = stopAutomationExecution(StopAutomationExecutionRequest.Builder().apply(block).build())

    /**
     * Permanently ends a session and closes the data connection between the Session Manager client and
     * SSM Agent on the managed node. A terminated session can't be resumed.
     */
    suspend fun terminateSession(input: TerminateSessionRequest): TerminateSessionResponse

    /**
     * Permanently ends a session and closes the data connection between the Session Manager client and
     * SSM Agent on the managed node. A terminated session can't be resumed.
     */
    suspend fun terminateSession(block: TerminateSessionRequest.Builder.() -> Unit) = terminateSession(TerminateSessionRequest.Builder().apply(block).build())

    /**
     * Remove a label or labels from a parameter.
     */
    suspend fun unlabelParameterVersion(input: UnlabelParameterVersionRequest): UnlabelParameterVersionResponse

    /**
     * Remove a label or labels from a parameter.
     */
    suspend fun unlabelParameterVersion(block: UnlabelParameterVersionRequest.Builder.() -> Unit) = unlabelParameterVersion(UnlabelParameterVersionRequest.Builder().apply(block).build())

    /**
     * Updates an association. You can update the association name and version, the document
     * version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you
     * call UpdateAssociation, the system removes all optional parameters from the request
     * and overwrites the association with null values for those parameters. This is by design. You must
     * specify all optional parameters in the call, even if you are not changing the parameters. This
     * includes the Name parameter. Before calling this API action, we recommend that you
     * call the DescribeAssociation API operation and make a note of all optional
     * parameters required for your UpdateAssociation call.
     *
     * In order to call this API operation, your Identity and Access Management (IAM) user
     * account, group, or role must be configured with permission to call the DescribeAssociation API operation. If you don't have permission to call
     * DescribeAssociation, then you receive the following error: An error occurred
     * (AccessDeniedException) when calling the UpdateAssociation operation: User: <user_arn>
     * isn't authorized to perform: ssm:DescribeAssociation on resource:
     * <resource_arn>
     *
     * When you update an association, the association immediately runs against the specified
     * targets. You can add the ApplyOnlyAtCronInterval parameter to run the association
     * during the next schedule run.
     */
    suspend fun updateAssociation(input: UpdateAssociationRequest): UpdateAssociationResponse

    /**
     * Updates an association. You can update the association name and version, the document
     * version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output. When you
     * call UpdateAssociation, the system removes all optional parameters from the request
     * and overwrites the association with null values for those parameters. This is by design. You must
     * specify all optional parameters in the call, even if you are not changing the parameters. This
     * includes the Name parameter. Before calling this API action, we recommend that you
     * call the DescribeAssociation API operation and make a note of all optional
     * parameters required for your UpdateAssociation call.
     *
     * In order to call this API operation, your Identity and Access Management (IAM) user
     * account, group, or role must be configured with permission to call the DescribeAssociation API operation. If you don't have permission to call
     * DescribeAssociation, then you receive the following error: An error occurred
     * (AccessDeniedException) when calling the UpdateAssociation operation: User: <user_arn>
     * isn't authorized to perform: ssm:DescribeAssociation on resource:
     * <resource_arn>
     *
     * When you update an association, the association immediately runs against the specified
     * targets. You can add the ApplyOnlyAtCronInterval parameter to run the association
     * during the next schedule run.
     */
    suspend fun updateAssociation(block: UpdateAssociationRequest.Builder.() -> Unit) = updateAssociation(UpdateAssociationRequest.Builder().apply(block).build())

    /**
     * Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified
     * managed node.
     *
     * UpdateAssociationStatus is primarily used by the Amazon Web Services Systems Manager Agent (SSM Agent) to
     * report status updates about your associations and is only used for associations created with the
     * InstanceId legacy parameter.
     */
    suspend fun updateAssociationStatus(input: UpdateAssociationStatusRequest): UpdateAssociationStatusResponse

    /**
     * Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified
     * managed node.
     *
     * UpdateAssociationStatus is primarily used by the Amazon Web Services Systems Manager Agent (SSM Agent) to
     * report status updates about your associations and is only used for associations created with the
     * InstanceId legacy parameter.
     */
    suspend fun updateAssociationStatus(block: UpdateAssociationStatusRequest.Builder.() -> Unit) = updateAssociationStatus(UpdateAssociationStatusRequest.Builder().apply(block).build())

    /**
     * Updates one or more values for an SSM document.
     */
    suspend fun updateDocument(input: UpdateDocumentRequest): UpdateDocumentResponse

    /**
     * Updates one or more values for an SSM document.
     */
    suspend fun updateDocument(block: UpdateDocumentRequest.Builder.() -> Unit) = updateDocument(UpdateDocumentRequest.Builder().apply(block).build())

    /**
     * Set the default version of a document.
     *
     * If you change a document version for a State Manager association, Systems Manager immediately runs
     * the association unless you previously specifed the apply-only-at-cron-interval
     * parameter.
     */
    suspend fun updateDocumentDefaultVersion(input: UpdateDocumentDefaultVersionRequest): UpdateDocumentDefaultVersionResponse

    /**
     * Set the default version of a document.
     *
     * If you change a document version for a State Manager association, Systems Manager immediately runs
     * the association unless you previously specifed the apply-only-at-cron-interval
     * parameter.
     */
    suspend fun updateDocumentDefaultVersion(block: UpdateDocumentDefaultVersionRequest.Builder.() -> Unit) = updateDocumentDefaultVersion(UpdateDocumentDefaultVersionRequest.Builder().apply(block).build())

    /**
     * Updates information related to approval reviews for a specific version of a change template
     * in Change Manager.
     */
    suspend fun updateDocumentMetadata(input: UpdateDocumentMetadataRequest): UpdateDocumentMetadataResponse

    /**
     * Updates information related to approval reviews for a specific version of a change template
     * in Change Manager.
     */
    suspend fun updateDocumentMetadata(block: UpdateDocumentMetadataRequest.Builder.() -> Unit) = updateDocumentMetadata(UpdateDocumentMetadataRequest.Builder().apply(block).build())

    /**
     * Updates an existing maintenance window. Only specified parameters are modified.
     *
     * The value you specify for Duration determines the specific end time for the
     * maintenance window based on the time it begins. No maintenance window tasks are permitted to
     * start after the resulting endtime minus the number of hours you specify for Cutoff.
     * For example, if the maintenance window starts at 3 PM, the duration is three hours, and the
     * value you specify for Cutoff is one hour, no maintenance window tasks can start
     * after 5 PM.
     */
    suspend fun updateMaintenanceWindow(input: UpdateMaintenanceWindowRequest): UpdateMaintenanceWindowResponse

    /**
     * Updates an existing maintenance window. Only specified parameters are modified.
     *
     * The value you specify for Duration determines the specific end time for the
     * maintenance window based on the time it begins. No maintenance window tasks are permitted to
     * start after the resulting endtime minus the number of hours you specify for Cutoff.
     * For example, if the maintenance window starts at 3 PM, the duration is three hours, and the
     * value you specify for Cutoff is one hour, no maintenance window tasks can start
     * after 5 PM.
     */
    suspend fun updateMaintenanceWindow(block: UpdateMaintenanceWindowRequest.Builder.() -> Unit) = updateMaintenanceWindow(UpdateMaintenanceWindowRequest.Builder().apply(block).build())

    /**
     * Modifies the target of an existing maintenance window. You
     * can change the following:
     *
     *
     *
     * Name
     *
     * Description
     *
     * Owner
     *
     * IDs for an ID target
     *
     * Tags for a Tag target
     *
     * From any supported tag type to another. The three supported tag types are ID target, Tag
     * target, and resource group. For more information, see Target.
     *
     *
     * If a parameter is null, then the corresponding field isn't modified.
     */
    suspend fun updateMaintenanceWindowTarget(input: UpdateMaintenanceWindowTargetRequest): UpdateMaintenanceWindowTargetResponse

    /**
     * Modifies the target of an existing maintenance window. You
     * can change the following:
     *
     *
     *
     * Name
     *
     * Description
     *
     * Owner
     *
     * IDs for an ID target
     *
     * Tags for a Tag target
     *
     * From any supported tag type to another. The three supported tag types are ID target, Tag
     * target, and resource group. For more information, see Target.
     *
     *
     * If a parameter is null, then the corresponding field isn't modified.
     */
    suspend fun updateMaintenanceWindowTarget(block: UpdateMaintenanceWindowTargetRequest.Builder.() -> Unit) = updateMaintenanceWindowTarget(UpdateMaintenanceWindowTargetRequest.Builder().apply(block).build())

    /**
     * Modifies a task assigned to a maintenance window. You can't change the task type, but you
     * can change the following values:
     *
     *
     *
     * TaskARN. For example, you can change a RUN_COMMAND task from
     * AWS-RunPowerShellScript to AWS-RunShellScript.
     *
     *
     * ServiceRoleArn
     *
     *
     *
     * TaskInvocationParameters
     *
     *
     *
     * Priority
     *
     *
     *
     * MaxConcurrency
     *
     *
     *
     * MaxErrors
     *
     *
     *
     * One or more targets must be specified for maintenance window Run Command-type tasks.
     * Depending on the task, targets are optional for other maintenance window task types (Automation,
     * Lambda, and Step Functions). For more information about running tasks
     * that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
     * maintenance window tasks without targets in the
     * Amazon Web Services Systems Manager User Guide.
     *
     * If the value for a parameter in UpdateMaintenanceWindowTask is null, then the
     * corresponding field isn't modified. If you set Replace to true, then all fields
     * required by the RegisterTaskWithMaintenanceWindow operation are required for
     * this request. Optional fields that aren't specified are set to null.
     *
     * When you update a maintenance window task that has options specified in
     * TaskInvocationParameters, you must provide again all the
     * TaskInvocationParameters values that you want to retain. The values you don't
     * specify again are removed. For example, suppose that when you registered a Run Command task, you
     * specified TaskInvocationParameters values for Comment,
     * NotificationConfig, and OutputS3BucketName. If you update the
     * maintenance window task and specify only a different OutputS3BucketName value, the
     * values for Comment and NotificationConfig are removed.
     */
    suspend fun updateMaintenanceWindowTask(input: UpdateMaintenanceWindowTaskRequest): UpdateMaintenanceWindowTaskResponse

    /**
     * Modifies a task assigned to a maintenance window. You can't change the task type, but you
     * can change the following values:
     *
     *
     *
     * TaskARN. For example, you can change a RUN_COMMAND task from
     * AWS-RunPowerShellScript to AWS-RunShellScript.
     *
     *
     * ServiceRoleArn
     *
     *
     *
     * TaskInvocationParameters
     *
     *
     *
     * Priority
     *
     *
     *
     * MaxConcurrency
     *
     *
     *
     * MaxErrors
     *
     *
     *
     * One or more targets must be specified for maintenance window Run Command-type tasks.
     * Depending on the task, targets are optional for other maintenance window task types (Automation,
     * Lambda, and Step Functions). For more information about running tasks
     * that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
     * maintenance window tasks without targets in the
     * Amazon Web Services Systems Manager User Guide.
     *
     * If the value for a parameter in UpdateMaintenanceWindowTask is null, then the
     * corresponding field isn't modified. If you set Replace to true, then all fields
     * required by the RegisterTaskWithMaintenanceWindow operation are required for
     * this request. Optional fields that aren't specified are set to null.
     *
     * When you update a maintenance window task that has options specified in
     * TaskInvocationParameters, you must provide again all the
     * TaskInvocationParameters values that you want to retain. The values you don't
     * specify again are removed. For example, suppose that when you registered a Run Command task, you
     * specified TaskInvocationParameters values for Comment,
     * NotificationConfig, and OutputS3BucketName. If you update the
     * maintenance window task and specify only a different OutputS3BucketName value, the
     * values for Comment and NotificationConfig are removed.
     */
    suspend fun updateMaintenanceWindowTask(block: UpdateMaintenanceWindowTaskRequest.Builder.() -> Unit) = updateMaintenanceWindowTask(UpdateMaintenanceWindowTaskRequest.Builder().apply(block).build())

    /**
     * Changes the Identity and Access Management (IAM) role that is assigned to the
     * on-premises server, edge device, or virtual machines (VM). IAM roles are first
     * assigned to these hybrid nodes during the activation process. For more information, see CreateActivation.
     */
    suspend fun updateManagedInstanceRole(input: UpdateManagedInstanceRoleRequest): UpdateManagedInstanceRoleResponse

    /**
     * Changes the Identity and Access Management (IAM) role that is assigned to the
     * on-premises server, edge device, or virtual machines (VM). IAM roles are first
     * assigned to these hybrid nodes during the activation process. For more information, see CreateActivation.
     */
    suspend fun updateManagedInstanceRole(block: UpdateManagedInstanceRoleRequest.Builder.() -> Unit) = updateManagedInstanceRole(UpdateManagedInstanceRoleRequest.Builder().apply(block).build())

    /**
     * Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun updateOpsItem(input: UpdateOpsItemRequest): UpdateOpsItemResponse

    /**
     * Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with
     * OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
     * remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the
     * Amazon Web Services Systems Manager User Guide.
     */
    suspend fun updateOpsItem(block: UpdateOpsItemRequest.Builder.() -> Unit) = updateOpsItem(UpdateOpsItemRequest.Builder().apply(block).build())

    /**
     * Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
     */
    suspend fun updateOpsMetadata(input: UpdateOpsMetadataRequest): UpdateOpsMetadataResponse

    /**
     * Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
     */
    suspend fun updateOpsMetadata(block: UpdateOpsMetadataRequest.Builder.() -> Unit) = updateOpsMetadata(UpdateOpsMetadataRequest.Builder().apply(block).build())

    /**
     * Modifies an existing patch baseline. Fields not specified in the request are left
     * unchanged.
     *
     * For information about valid key-value pairs in PatchFilters for each supported
     * operating system type, see PatchFilter.
     */
    suspend fun updatePatchBaseline(input: UpdatePatchBaselineRequest): UpdatePatchBaselineResponse

    /**
     * Modifies an existing patch baseline. Fields not specified in the request are left
     * unchanged.
     *
     * For information about valid key-value pairs in PatchFilters for each supported
     * operating system type, see PatchFilter.
     */
    suspend fun updatePatchBaseline(block: UpdatePatchBaselineRequest.Builder.() -> Unit) = updatePatchBaseline(UpdatePatchBaselineRequest.Builder().apply(block).build())

    /**
     * Update a resource data sync. After you create a resource data sync for a Region, you can't
     * change the account options for that sync. For example, if you create a sync in the us-east-2
     * (Ohio) Region and you choose the Include only the current account option, you can't
     * edit that sync later and choose the Include all accounts from my Organizations
     * configuration option. Instead, you must delete the first resource data sync, and create a
     * new one.
     *
     * This API operation only supports a resource data sync that was created with a
     * SyncFromSource SyncType.
     */
    suspend fun updateResourceDataSync(input: UpdateResourceDataSyncRequest): UpdateResourceDataSyncResponse

    /**
     * Update a resource data sync. After you create a resource data sync for a Region, you can't
     * change the account options for that sync. For example, if you create a sync in the us-east-2
     * (Ohio) Region and you choose the Include only the current account option, you can't
     * edit that sync later and choose the Include all accounts from my Organizations
     * configuration option. Instead, you must delete the first resource data sync, and create a
     * new one.
     *
     * This API operation only supports a resource data sync that was created with a
     * SyncFromSource SyncType.
     */
    suspend fun updateResourceDataSync(block: UpdateResourceDataSyncRequest.Builder.() -> Unit) = updateResourceDataSync(UpdateResourceDataSyncRequest.Builder().apply(block).build())

    /**
     * ServiceSetting is an account-level setting for an Amazon Web Services service. This setting
     * defines how a user interacts with or uses a service or a feature of a service. For example, if an
     * Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
     * service team might create a default setting of "false". This means the user can't use this
     * feature unless they change the setting to "true" and intentionally opt in for a paid
     * feature.
     * Services map a SettingId object to a setting value. Amazon Web Services services teams define
     * the default value for a SettingId. You can't create a new SettingId,
     * but you can overwrite the default value if you have the ssm:UpdateServiceSetting
     * permission for the setting. Use the GetServiceSetting API operation to view the
     * current value. Or, use the ResetServiceSetting to change the value back to the
     * original value defined by the Amazon Web Services service team.
     * Update the service setting for the account.
     */
    suspend fun updateServiceSetting(input: UpdateServiceSettingRequest): UpdateServiceSettingResponse

    /**
     * ServiceSetting is an account-level setting for an Amazon Web Services service. This setting
     * defines how a user interacts with or uses a service or a feature of a service. For example, if an
     * Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services
     * service team might create a default setting of "false". This means the user can't use this
     * feature unless they change the setting to "true" and intentionally opt in for a paid
     * feature.
     * Services map a SettingId object to a setting value. Amazon Web Services services teams define
     * the default value for a SettingId. You can't create a new SettingId,
     * but you can overwrite the default value if you have the ssm:UpdateServiceSetting
     * permission for the setting. Use the GetServiceSetting API operation to view the
     * current value. Or, use the ResetServiceSetting to change the value back to the
     * original value defined by the Amazon Web Services service team.
     * Update the service setting for the account.
     */
    suspend fun updateServiceSetting(block: UpdateServiceSettingRequest.Builder.() -> Unit) = updateServiceSetting(UpdateServiceSettingRequest.Builder().apply(block).build())
}
