// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class AddTagsToResourceRequest private constructor(builder: Builder) {
    /**
     * The resource ID you want to tag.
     * Use the ID of the resource. Here are some examples:
     *
     * MaintenanceWindow: mw-012345abcde
     *
     * PatchBaseline: pb-012345abcde
     *
     * Automation: example-c160-4567-8519-012345abcde
     *
     * OpsMetadata object: ResourceID for tagging is created from the
     * Amazon Resource Name (ARN) for the object. Specifically, ResourceID is created from
     * the strings that come after the word opsmetadata in the ARN. For example, an
     * OpsMetadata object with an ARN of
     * arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager has a
     * ResourceID of either aws/ssm/MyGroup/appmanager or
     * /aws/ssm/MyGroup/appmanager.
     * For the Document and Parameter values, use the name of the
     * resource.
     *
     * ManagedInstance: mi-012345abcde
     *
     * The ManagedInstance type for this API operation is only for on-premises
     * managed nodes. You must specify the name of the managed node in the following format:
     * mi-ID_number
     * . For example,
     * mi-1a2b3c4d5e6f.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * Specifies the type of resource you are tagging.
     *
     * The ManagedInstance type for this API operation is for on-premises managed
     * nodes. You must specify the name of the managed node in the following format:
     * mi-ID_number
     * . For example,
     * mi-1a2b3c4d5e6f.
     */
    val resourceType: aws.sdk.kotlin.services.ssm.model.ResourceTypeForTagging? = builder.resourceType
    /**
     * One or more tags. The value parameter is required.
     *
     * Don't enter personally identifiable information in this field.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AddTagsToResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AddTagsToResourceRequest(")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AddTagsToResourceRequest

        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AddTagsToResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The resource ID you want to tag.
         * Use the ID of the resource. Here are some examples:
         *
         * MaintenanceWindow: mw-012345abcde
         *
         * PatchBaseline: pb-012345abcde
         *
         * Automation: example-c160-4567-8519-012345abcde
         *
         * OpsMetadata object: ResourceID for tagging is created from the
         * Amazon Resource Name (ARN) for the object. Specifically, ResourceID is created from
         * the strings that come after the word opsmetadata in the ARN. For example, an
         * OpsMetadata object with an ARN of
         * arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager has a
         * ResourceID of either aws/ssm/MyGroup/appmanager or
         * /aws/ssm/MyGroup/appmanager.
         * For the Document and Parameter values, use the name of the
         * resource.
         *
         * ManagedInstance: mi-012345abcde
         *
         * The ManagedInstance type for this API operation is only for on-premises
         * managed nodes. You must specify the name of the managed node in the following format:
         * mi-ID_number
         * . For example,
         * mi-1a2b3c4d5e6f.
         */
        var resourceId: kotlin.String? = null
        /**
         * Specifies the type of resource you are tagging.
         *
         * The ManagedInstance type for this API operation is for on-premises managed
         * nodes. You must specify the name of the managed node in the following format:
         * mi-ID_number
         * . For example,
         * mi-1a2b3c4d5e6f.
         */
        var resourceType: aws.sdk.kotlin.services.ssm.model.ResourceTypeForTagging? = null
        /**
         * One or more tags. The value parameter is required.
         *
         * Don't enter personally identifiable information in this field.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AddTagsToResourceRequest) : this() {
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AddTagsToResourceRequest = AddTagsToResourceRequest(this)
    }
}
