// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * A structure that includes attributes that describe a document attachment.
 */
class AttachmentContent private constructor(builder: Builder) {
    /**
     * The cryptographic hash value of the document content.
     */
    val hash: kotlin.String? = builder.hash
    /**
     * The hash algorithm used to calculate the hash value.
     */
    val hashType: aws.sdk.kotlin.services.ssm.model.AttachmentHashType? = builder.hashType
    /**
     * The name of an attachment.
     */
    val name: kotlin.String? = builder.name
    /**
     * The size of an attachment in bytes.
     */
    val size: kotlin.Long = builder.size
    /**
     * The URL location of the attachment content.
     */
    val url: kotlin.String? = builder.url

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AttachmentContent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttachmentContent(")
        append("hash=$hash,")
        append("hashType=$hashType,")
        append("name=$name,")
        append("size=$size,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hash?.hashCode() ?: 0
        result = 31 * result + (hashType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttachmentContent

        if (hash != other.hash) return false
        if (hashType != other.hashType) return false
        if (name != other.name) return false
        if (size != other.size) return false
        if (url != other.url) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AttachmentContent = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cryptographic hash value of the document content.
         */
        var hash: kotlin.String? = null
        /**
         * The hash algorithm used to calculate the hash value.
         */
        var hashType: aws.sdk.kotlin.services.ssm.model.AttachmentHashType? = null
        /**
         * The name of an attachment.
         */
        var name: kotlin.String? = null
        /**
         * The size of an attachment in bytes.
         */
        var size: kotlin.Long = 0L
        /**
         * The URL location of the attachment content.
         */
        var url: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AttachmentContent) : this() {
            this.hash = x.hash
            this.hashType = x.hashType
            this.name = x.name
            this.size = x.size
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AttachmentContent = AttachmentContent(this)
    }
}
