// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a specific Automation execution.
 */
class AutomationExecutionMetadata private constructor(builder: Builder) {
    /**
     * The ID of a State Manager association used in the Automation operation.
     */
    val associationId: kotlin.String? = builder.associationId
    /**
     * The execution ID.
     */
    val automationExecutionId: kotlin.String? = builder.automationExecutionId
    /**
     * The status of the execution.
     */
    val automationExecutionStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = builder.automationExecutionStatus
    /**
     * The subtype of the Automation operation. Currently, the only supported value is
     * ChangeRequest.
     */
    val automationSubtype: aws.sdk.kotlin.services.ssm.model.AutomationSubtype? = builder.automationSubtype
    /**
     * Use this filter with DescribeAutomationExecutions. Specify either Local or
     * CrossAccount. CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and
     * Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and accounts in the
     * Amazon Web Services Systems Manager User Guide.
     */
    val automationType: aws.sdk.kotlin.services.ssm.model.AutomationType? = builder.automationType
    /**
     * The name of the Change Manager change request.
     */
    val changeRequestName: kotlin.String? = builder.changeRequestName
    /**
     * The action of the step that is currently running.
     */
    val currentAction: kotlin.String? = builder.currentAction
    /**
     * The name of the step that is currently running.
     */
    val currentStepName: kotlin.String? = builder.currentStepName
    /**
     * The name of the Automation runbook used during execution.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The document version used during the execution.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The IAM role ARN of the user who ran the automation.
     */
    val executedBy: kotlin.String? = builder.executedBy
    /**
     * The time the execution finished. This isn't populated if the execution is still in
     * progress.
     */
    val executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionEndTime
    /**
     * The time the execution started.
     */
    val executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionStartTime
    /**
     * The list of execution outputs as defined in the Automation runbook.
     */
    val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * An S3 bucket where execution information is stored.
     */
    val logFile: kotlin.String? = builder.logFile
    /**
     * The MaxConcurrency value specified by the user when starting the
     * automation.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The MaxErrors value specified by the user when starting the automation.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The Automation execution mode.
     */
    val mode: aws.sdk.kotlin.services.ssm.model.ExecutionMode? = builder.mode
    /**
     * The ID of an OpsItem that is created to represent a Change Manager change request.
     */
    val opsItemId: kotlin.String? = builder.opsItemId
    /**
     * The list of execution outputs as defined in the Automation runbook.
     */
    val outputs: Map<String, List<String>>? = builder.outputs
    /**
     * The execution ID of the parent automation.
     */
    val parentAutomationExecutionId: kotlin.String? = builder.parentAutomationExecutionId
    /**
     * A list of targets that resolved during the execution.
     */
    val resolvedTargets: aws.sdk.kotlin.services.ssm.model.ResolvedTargets? = builder.resolvedTargets
    /**
     * Information about the Automation runbooks that are run during a runbook workflow in
     * Change Manager.
     *
     * The Automation runbooks specified for the runbook workflow can't run until all required
     * approvals for the change request have been received.
     */
    val runbooks: List<Runbook>? = builder.runbooks
    /**
     * The date and time the Automation operation is scheduled to start.
     */
    val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime
    /**
     * The list of execution outputs as defined in the Automation runbook.
     */
    val target: kotlin.String? = builder.target
    /**
     * The specified key-value mapping of document parameters to target resources.
     */
    val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The list of execution outputs as defined in the Automation runbook.
     */
    val targetParameterName: kotlin.String? = builder.targetParameterName
    /**
     * The targets defined by the user when starting the automation.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AutomationExecutionMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomationExecutionMetadata(")
        append("associationId=$associationId,")
        append("automationExecutionId=$automationExecutionId,")
        append("automationExecutionStatus=$automationExecutionStatus,")
        append("automationSubtype=$automationSubtype,")
        append("automationType=$automationType,")
        append("changeRequestName=$changeRequestName,")
        append("currentAction=$currentAction,")
        append("currentStepName=$currentStepName,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("executedBy=$executedBy,")
        append("executionEndTime=$executionEndTime,")
        append("executionStartTime=$executionStartTime,")
        append("failureMessage=$failureMessage,")
        append("logFile=$logFile,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("mode=$mode,")
        append("opsItemId=$opsItemId,")
        append("outputs=$outputs,")
        append("parentAutomationExecutionId=$parentAutomationExecutionId,")
        append("resolvedTargets=$resolvedTargets,")
        append("runbooks=$runbooks,")
        append("scheduledTime=$scheduledTime,")
        append("target=$target,")
        append("targetMaps=$targetMaps,")
        append("targetParameterName=$targetParameterName,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (automationExecutionId?.hashCode() ?: 0)
        result = 31 * result + (automationExecutionStatus?.hashCode() ?: 0)
        result = 31 * result + (automationSubtype?.hashCode() ?: 0)
        result = 31 * result + (automationType?.hashCode() ?: 0)
        result = 31 * result + (changeRequestName?.hashCode() ?: 0)
        result = 31 * result + (currentAction?.hashCode() ?: 0)
        result = 31 * result + (currentStepName?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (executedBy?.hashCode() ?: 0)
        result = 31 * result + (executionEndTime?.hashCode() ?: 0)
        result = 31 * result + (executionStartTime?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (logFile?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (opsItemId?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (parentAutomationExecutionId?.hashCode() ?: 0)
        result = 31 * result + (resolvedTargets?.hashCode() ?: 0)
        result = 31 * result + (runbooks?.hashCode() ?: 0)
        result = 31 * result + (scheduledTime?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (targetMaps?.hashCode() ?: 0)
        result = 31 * result + (targetParameterName?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomationExecutionMetadata

        if (associationId != other.associationId) return false
        if (automationExecutionId != other.automationExecutionId) return false
        if (automationExecutionStatus != other.automationExecutionStatus) return false
        if (automationSubtype != other.automationSubtype) return false
        if (automationType != other.automationType) return false
        if (changeRequestName != other.changeRequestName) return false
        if (currentAction != other.currentAction) return false
        if (currentStepName != other.currentStepName) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (executedBy != other.executedBy) return false
        if (executionEndTime != other.executionEndTime) return false
        if (executionStartTime != other.executionStartTime) return false
        if (failureMessage != other.failureMessage) return false
        if (logFile != other.logFile) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (mode != other.mode) return false
        if (opsItemId != other.opsItemId) return false
        if (outputs != other.outputs) return false
        if (parentAutomationExecutionId != other.parentAutomationExecutionId) return false
        if (resolvedTargets != other.resolvedTargets) return false
        if (runbooks != other.runbooks) return false
        if (scheduledTime != other.scheduledTime) return false
        if (target != other.target) return false
        if (targetMaps != other.targetMaps) return false
        if (targetParameterName != other.targetParameterName) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AutomationExecutionMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of a State Manager association used in the Automation operation.
         */
        var associationId: kotlin.String? = null
        /**
         * The execution ID.
         */
        var automationExecutionId: kotlin.String? = null
        /**
         * The status of the execution.
         */
        var automationExecutionStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = null
        /**
         * The subtype of the Automation operation. Currently, the only supported value is
         * ChangeRequest.
         */
        var automationSubtype: aws.sdk.kotlin.services.ssm.model.AutomationSubtype? = null
        /**
         * Use this filter with DescribeAutomationExecutions. Specify either Local or
         * CrossAccount. CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and
         * Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and accounts in the
         * Amazon Web Services Systems Manager User Guide.
         */
        var automationType: aws.sdk.kotlin.services.ssm.model.AutomationType? = null
        /**
         * The name of the Change Manager change request.
         */
        var changeRequestName: kotlin.String? = null
        /**
         * The action of the step that is currently running.
         */
        var currentAction: kotlin.String? = null
        /**
         * The name of the step that is currently running.
         */
        var currentStepName: kotlin.String? = null
        /**
         * The name of the Automation runbook used during execution.
         */
        var documentName: kotlin.String? = null
        /**
         * The document version used during the execution.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The IAM role ARN of the user who ran the automation.
         */
        var executedBy: kotlin.String? = null
        /**
         * The time the execution finished. This isn't populated if the execution is still in
         * progress.
         */
        var executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the execution started.
         */
        var executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of execution outputs as defined in the Automation runbook.
         */
        var failureMessage: kotlin.String? = null
        /**
         * An S3 bucket where execution information is stored.
         */
        var logFile: kotlin.String? = null
        /**
         * The MaxConcurrency value specified by the user when starting the
         * automation.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The MaxErrors value specified by the user when starting the automation.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The Automation execution mode.
         */
        var mode: aws.sdk.kotlin.services.ssm.model.ExecutionMode? = null
        /**
         * The ID of an OpsItem that is created to represent a Change Manager change request.
         */
        var opsItemId: kotlin.String? = null
        /**
         * The list of execution outputs as defined in the Automation runbook.
         */
        var outputs: Map<String, List<String>>? = null
        /**
         * The execution ID of the parent automation.
         */
        var parentAutomationExecutionId: kotlin.String? = null
        /**
         * A list of targets that resolved during the execution.
         */
        var resolvedTargets: aws.sdk.kotlin.services.ssm.model.ResolvedTargets? = null
        /**
         * Information about the Automation runbooks that are run during a runbook workflow in
         * Change Manager.
         *
         * The Automation runbooks specified for the runbook workflow can't run until all required
         * approvals for the change request have been received.
         */
        var runbooks: List<Runbook>? = null
        /**
         * The date and time the Automation operation is scheduled to start.
         */
        var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of execution outputs as defined in the Automation runbook.
         */
        var target: kotlin.String? = null
        /**
         * The specified key-value mapping of document parameters to target resources.
         */
        var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The list of execution outputs as defined in the Automation runbook.
         */
        var targetParameterName: kotlin.String? = null
        /**
         * The targets defined by the user when starting the automation.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AutomationExecutionMetadata) : this() {
            this.associationId = x.associationId
            this.automationExecutionId = x.automationExecutionId
            this.automationExecutionStatus = x.automationExecutionStatus
            this.automationSubtype = x.automationSubtype
            this.automationType = x.automationType
            this.changeRequestName = x.changeRequestName
            this.currentAction = x.currentAction
            this.currentStepName = x.currentStepName
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.executedBy = x.executedBy
            this.executionEndTime = x.executionEndTime
            this.executionStartTime = x.executionStartTime
            this.failureMessage = x.failureMessage
            this.logFile = x.logFile
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.mode = x.mode
            this.opsItemId = x.opsItemId
            this.outputs = x.outputs
            this.parentAutomationExecutionId = x.parentAutomationExecutionId
            this.resolvedTargets = x.resolvedTargets
            this.runbooks = x.runbooks
            this.scheduledTime = x.scheduledTime
            this.target = x.target
            this.targetMaps = x.targetMaps
            this.targetParameterName = x.targetParameterName
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AutomationExecutionMetadata = AutomationExecutionMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResolvedTargets] inside the given [block]
         */
        fun resolvedTargets(block: aws.sdk.kotlin.services.ssm.model.ResolvedTargets.Builder.() -> kotlin.Unit) {
            this.resolvedTargets = aws.sdk.kotlin.services.ssm.model.ResolvedTargets.invoke(block)
        }
    }
}
