// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Configuration options for sending command output to Amazon CloudWatch Logs.
 */
class CloudWatchOutputConfig private constructor(builder: Builder) {
    /**
     * The name of the CloudWatch Logs log group where you want to send command output. If you
     * don't specify a group name, Amazon Web Services Systems Manager automatically creates a log group for you. The log group
     * uses the following naming format:
     *
     * aws/ssm/SystemsManagerDocumentName
     */
    val cloudWatchLogGroupName: kotlin.String? = builder.cloudWatchLogGroupName
    /**
     * Enables Systems Manager to send command output to CloudWatch Logs.
     */
    val cloudWatchOutputEnabled: kotlin.Boolean = builder.cloudWatchOutputEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchOutputConfig(")
        append("cloudWatchLogGroupName=$cloudWatchLogGroupName,")
        append("cloudWatchOutputEnabled=$cloudWatchOutputEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupName?.hashCode() ?: 0
        result = 31 * result + (cloudWatchOutputEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchOutputConfig

        if (cloudWatchLogGroupName != other.cloudWatchLogGroupName) return false
        if (cloudWatchOutputEnabled != other.cloudWatchOutputEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the CloudWatch Logs log group where you want to send command output. If you
         * don't specify a group name, Amazon Web Services Systems Manager automatically creates a log group for you. The log group
         * uses the following naming format:
         *
         * aws/ssm/SystemsManagerDocumentName
         */
        var cloudWatchLogGroupName: kotlin.String? = null
        /**
         * Enables Systems Manager to send command output to CloudWatch Logs.
         */
        var cloudWatchOutputEnabled: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig) : this() {
            this.cloudWatchLogGroupName = x.cloudWatchLogGroupName
            this.cloudWatchOutputEnabled = x.cloudWatchOutputEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig = CloudWatchOutputConfig(this)
    }
}
