// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Describes the association of a Amazon Web Services Systems Manager document (SSM document) and a managed node.
 */
class CreateAssociationBatchRequestEntry private constructor(builder: Builder) {
    /**
     * By default, when you create a new associations, the system runs it immediately after it is
     * created and then according to the schedule you specified. Specify this option if you don't want
     * an association to run immediately after you create it. This parameter isn't supported for rate
     * expressions.
     */
    val applyOnlyAtCronInterval: kotlin.Boolean = builder.applyOnlyAtCronInterval
    /**
     * Specify a descriptive name for the association.
     */
    val associationName: kotlin.String? = builder.associationName
    /**
     * Specify the target for the association. This target is required for associations that use an
     * Automation runbook and target resources by using rate controls. Automation is a capability of
     * Amazon Web Services Systems Manager.
     */
    val automationTargetParameterName: kotlin.String? = builder.automationTargetParameterName
    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
     * associations are gated under. The associations only run when that Change Calendar is open. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
     * Calendar.
     */
    val calendarNames: List<String>? = builder.calendarNames
    /**
     * The severity level to assign to the association.
     */
    val complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = builder.complianceSeverity
    /**
     * The document version.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The managed node ID.
     *
     *
     * InstanceId has been deprecated. To specify a managed node ID for an
     * association, use the Targets parameter. Requests that
     * include the parameter InstanceID with Systems Manager documents (SSM documents) that use
     * schema version 2.0 or later will fail. In addition, if you use the
     * parameter InstanceId, you can't use the parameters AssociationName,
     * DocumentVersion, MaxErrors, MaxConcurrency,
     * OutputLocation, or ScheduleExpression. To use these parameters, you
     * must use the Targets parameter.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The maximum number of targets allowed to run the association at the same time. You can
     * specify a number, for example 10, or a percentage of the target set, for example 10%. The default
     * value is 100%, which means all targets run the association at the same time.
     * If a new managed node starts and attempts to run an association while Systems Manager is running
     * MaxConcurrency associations, the association is allowed to run. During the next
     * association interval, the new managed node will process its association within the limit
     * specified for MaxConcurrency.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The number of errors that are allowed before the system stops sending requests to run the
     * association on additional targets. You can specify either an absolute number of errors, for
     * example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
     * the system stops sending requests when the fourth error is received. If you specify 0, then the
     * system stops sending requests after the first error is returned. If you run an association on 50
     * managed nodes and set MaxError to 10%, then the system stops sending the request
     * when the sixth error is received.
     * Executions that are already running an association when MaxErrors is reached
     * are allowed to complete, but some of these executions may fail as well. If you need to ensure
     * that there won't be more than max-errors failed executions, set MaxConcurrency to 1
     * so that executions proceed one at a time.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The name of the SSM document that contains the configuration information for the managed
     * node. You can specify Command or Automation runbooks.
     * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
     * shared with you from another account.
     * For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify the
     * complete SSM document ARN, in the following format:
     *
     * arn:aws:ssm:region:account-id:document/document-name
     *
     *
     * For example:
     *
     * arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document
     *
     * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
     * to specify the document name. For example, AWS-ApplyPatchBaseline or
     * My-Document.
     */
    val name: kotlin.String? = builder.name
    /**
     * An S3 bucket where you want to store the results of this request.
     */
    val outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = builder.outputLocation
    /**
     * A description of the parameters for a document.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * A cron expression that specifies a schedule when the association runs.
     */
    val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Number of days to wait after the scheduled day to run an association.
     */
    val scheduleOffset: kotlin.Int = builder.scheduleOffset
    /**
     * The mode for generating association compliance. You can specify AUTO or
     * MANUAL. In AUTO mode, the system uses the status of the association
     * execution to determine the compliance status. If the association execution runs successfully,
     * then the association is COMPLIANT. If the association execution doesn't run
     * successfully, the association is NON-COMPLIANT.
     * In MANUAL mode, you must specify the AssociationId as a parameter
     * for the PutComplianceItems API operation. In this case, compliance data isn't
     * managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     * PutComplianceItems API operation.
     * By default, all associations use AUTO mode.
     */
    val syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = builder.syncCompliance
    /**
     * Use this action to create an association in multiple Regions and multiple accounts.
     */
    val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * The managed nodes targeted by the request.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssociationBatchRequestEntry(")
        append("applyOnlyAtCronInterval=$applyOnlyAtCronInterval,")
        append("associationName=$associationName,")
        append("automationTargetParameterName=$automationTargetParameterName,")
        append("calendarNames=$calendarNames,")
        append("complianceSeverity=$complianceSeverity,")
        append("documentVersion=$documentVersion,")
        append("instanceId=$instanceId,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("outputLocation=$outputLocation,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleOffset=$scheduleOffset,")
        append("syncCompliance=$syncCompliance,")
        append("targetLocations=$targetLocations,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnlyAtCronInterval.hashCode()
        result = 31 * result + (associationName?.hashCode() ?: 0)
        result = 31 * result + (automationTargetParameterName?.hashCode() ?: 0)
        result = 31 * result + (calendarNames?.hashCode() ?: 0)
        result = 31 * result + (complianceSeverity?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset)
        result = 31 * result + (syncCompliance?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssociationBatchRequestEntry

        if (applyOnlyAtCronInterval != other.applyOnlyAtCronInterval) return false
        if (associationName != other.associationName) return false
        if (automationTargetParameterName != other.automationTargetParameterName) return false
        if (calendarNames != other.calendarNames) return false
        if (complianceSeverity != other.complianceSeverity) return false
        if (documentVersion != other.documentVersion) return false
        if (instanceId != other.instanceId) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (outputLocation != other.outputLocation) return false
        if (parameters != other.parameters) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (syncCompliance != other.syncCompliance) return false
        if (targetLocations != other.targetLocations) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchRequestEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * By default, when you create a new associations, the system runs it immediately after it is
         * created and then according to the schedule you specified. Specify this option if you don't want
         * an association to run immediately after you create it. This parameter isn't supported for rate
         * expressions.
         */
        var applyOnlyAtCronInterval: kotlin.Boolean = false
        /**
         * Specify a descriptive name for the association.
         */
        var associationName: kotlin.String? = null
        /**
         * Specify the target for the association. This target is required for associations that use an
         * Automation runbook and target resources by using rate controls. Automation is a capability of
         * Amazon Web Services Systems Manager.
         */
        var automationTargetParameterName: kotlin.String? = null
        /**
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your
         * associations are gated under. The associations only run when that Change Calendar is open. For
         * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
         * Calendar.
         */
        var calendarNames: List<String>? = null
        /**
         * The severity level to assign to the association.
         */
        var complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = null
        /**
         * The document version.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The managed node ID.
         *
         *
         * InstanceId has been deprecated. To specify a managed node ID for an
         * association, use the Targets parameter. Requests that
         * include the parameter InstanceID with Systems Manager documents (SSM documents) that use
         * schema version 2.0 or later will fail. In addition, if you use the
         * parameter InstanceId, you can't use the parameters AssociationName,
         * DocumentVersion, MaxErrors, MaxConcurrency,
         * OutputLocation, or ScheduleExpression. To use these parameters, you
         * must use the Targets parameter.
         */
        var instanceId: kotlin.String? = null
        /**
         * The maximum number of targets allowed to run the association at the same time. You can
         * specify a number, for example 10, or a percentage of the target set, for example 10%. The default
         * value is 100%, which means all targets run the association at the same time.
         * If a new managed node starts and attempts to run an association while Systems Manager is running
         * MaxConcurrency associations, the association is allowed to run. During the next
         * association interval, the new managed node will process its association within the limit
         * specified for MaxConcurrency.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The number of errors that are allowed before the system stops sending requests to run the
         * association on additional targets. You can specify either an absolute number of errors, for
         * example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
         * the system stops sending requests when the fourth error is received. If you specify 0, then the
         * system stops sending requests after the first error is returned. If you run an association on 50
         * managed nodes and set MaxError to 10%, then the system stops sending the request
         * when the sixth error is received.
         * Executions that are already running an association when MaxErrors is reached
         * are allowed to complete, but some of these executions may fail as well. If you need to ensure
         * that there won't be more than max-errors failed executions, set MaxConcurrency to 1
         * so that executions proceed one at a time.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The name of the SSM document that contains the configuration information for the managed
         * node. You can specify Command or Automation runbooks.
         * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
         * shared with you from another account.
         * For SSM documents that are shared with you from other Amazon Web Services accounts, you must specify the
         * complete SSM document ARN, in the following format:
         *
         * arn:aws:ssm:region:account-id:document/document-name
         *
         *
         * For example:
         *
         * arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document
         *
         * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
         * to specify the document name. For example, AWS-ApplyPatchBaseline or
         * My-Document.
         */
        var name: kotlin.String? = null
        /**
         * An S3 bucket where you want to store the results of this request.
         */
        var outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = null
        /**
         * A description of the parameters for a document.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * A cron expression that specifies a schedule when the association runs.
         */
        var scheduleExpression: kotlin.String? = null
        /**
         * Number of days to wait after the scheduled day to run an association.
         */
        var scheduleOffset: kotlin.Int = 0
        /**
         * The mode for generating association compliance. You can specify AUTO or
         * MANUAL. In AUTO mode, the system uses the status of the association
         * execution to determine the compliance status. If the association execution runs successfully,
         * then the association is COMPLIANT. If the association execution doesn't run
         * successfully, the association is NON-COMPLIANT.
         * In MANUAL mode, you must specify the AssociationId as a parameter
         * for the PutComplianceItems API operation. In this case, compliance data isn't
         * managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         * PutComplianceItems API operation.
         * By default, all associations use AUTO mode.
         */
        var syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = null
        /**
         * Use this action to create an association in multiple Regions and multiple accounts.
         */
        var targetLocations: List<TargetLocation>? = null
        /**
         * The managed nodes targeted by the request.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchRequestEntry) : this() {
            this.applyOnlyAtCronInterval = x.applyOnlyAtCronInterval
            this.associationName = x.associationName
            this.automationTargetParameterName = x.automationTargetParameterName
            this.calendarNames = x.calendarNames
            this.complianceSeverity = x.complianceSeverity
            this.documentVersion = x.documentVersion
            this.instanceId = x.instanceId
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.outputLocation = x.outputLocation
            this.parameters = x.parameters
            this.scheduleExpression = x.scheduleExpression
            this.scheduleOffset = x.scheduleOffset
            this.syncCompliance = x.syncCompliance
            this.targetLocations = x.targetLocations
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchRequestEntry = CreateAssociationBatchRequestEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation] inside the given [block]
         */
        fun outputLocation(block: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.invoke(block)
        }
    }
}
