// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class CreateDocumentRequest private constructor(builder: Builder) {
    /**
     * A list of key-value pairs that describe attachments to a version of a document.
     */
    val attachments: List<AttachmentsSource>? = builder.attachments
    /**
     * The content for the new SSM document in JSON or YAML format. We recommend storing the
     * contents for your new document in an external JSON or YAML file and referencing the file in a
     * command.
     * For examples, see the following topics in the Amazon Web Services Systems Manager User Guide.
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)
     */
    val content: kotlin.String? = builder.content
    /**
     * An optional field where you can specify a friendly name for the SSM document. This value can
     * differ for each version of the document. You can update this value at a later time using the
     * UpdateDocument operation.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * Specify the document format for the request. The document format can be JSON, YAML, or TEXT.
     * JSON is the default format.
     */
    val documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = builder.documentFormat
    /**
     * The type of document to create.
     *
     * The DeploymentStrategy document type is an internal-use-only document type
     * reserved for AppConfig.
     */
    val documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = builder.documentType
    /**
     * A name for the SSM document.
     *
     * You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services
     * for use as document name prefixes:
     *
     *
     *
     * aws-
     *
     *
     *
     * amazon
     *
     *
     *
     * amzn
     */
    val name: kotlin.String? = builder.name
    /**
     * A list of SSM documents required by a document. This parameter is used exclusively by
     * AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also
     * specify a required document for validation purposes. In this case, an
     * ApplicationConfiguration document requires an
     * ApplicationConfigurationSchema document for validation purposes. For more
     * information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig? in the
     * AppConfig User Guide.
     */
    val requires: List<DocumentRequires>? = builder.requires
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
     * different ways, such as by purpose, owner, or environment. For example, you might want to tag an
     * SSM document to identify the types of targets or the environment where it will run. In this case,
     * you could specify the following key-value pairs:
     *
     *
     *
     * Key=OS,Value=Windows
     *
     *
     *
     * Key=Environment,Value=Production
     *
     *
     *
     * To add tags to an existing SSM document, use the AddTagsToResource
     * operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Specify a target type to define the kinds of resources the document can run on. For example,
     * to run a document on EC2 instances, specify the following value:
     * /AWS::EC2::Instance. If you specify a value of '/' the document can run on all types
     * of resources. If you don't specify a value, the document can't run on any resources. For a list
     * of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
     * property types reference in the CloudFormation User Guide.
     */
    val targetType: kotlin.String? = builder.targetType
    /**
     * An optional field specifying the version of the artifact you are creating with the document.
     * For example, "Release 12, Update 6". This value is unique across all versions of a document, and
     * can't be changed.
     */
    val versionName: kotlin.String? = builder.versionName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDocumentRequest(")
        append("attachments=$attachments,")
        append("content=$content,")
        append("displayName=$displayName,")
        append("documentFormat=$documentFormat,")
        append("documentType=$documentType,")
        append("name=$name,")
        append("requires=$requires,")
        append("tags=$tags,")
        append("targetType=$targetType,")
        append("versionName=$versionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (documentFormat?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requires?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDocumentRequest

        if (attachments != other.attachments) return false
        if (content != other.content) return false
        if (displayName != other.displayName) return false
        if (documentFormat != other.documentFormat) return false
        if (documentType != other.documentType) return false
        if (name != other.name) return false
        if (requires != other.requires) return false
        if (tags != other.tags) return false
        if (targetType != other.targetType) return false
        if (versionName != other.versionName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of key-value pairs that describe attachments to a version of a document.
         */
        var attachments: List<AttachmentsSource>? = null
        /**
         * The content for the new SSM document in JSON or YAML format. We recommend storing the
         * contents for your new document in an external JSON or YAML file and referencing the file in a
         * command.
         * For examples, see the following topics in the Amazon Web Services Systems Manager User Guide.
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (Amazon Web Services API)
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (Amazon Web Services CLI)
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)
         */
        var content: kotlin.String? = null
        /**
         * An optional field where you can specify a friendly name for the SSM document. This value can
         * differ for each version of the document. You can update this value at a later time using the
         * UpdateDocument operation.
         */
        var displayName: kotlin.String? = null
        /**
         * Specify the document format for the request. The document format can be JSON, YAML, or TEXT.
         * JSON is the default format.
         */
        var documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = null
        /**
         * The type of document to create.
         *
         * The DeploymentStrategy document type is an internal-use-only document type
         * reserved for AppConfig.
         */
        var documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = null
        /**
         * A name for the SSM document.
         *
         * You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services
         * for use as document name prefixes:
         *
         *
         *
         * aws-
         *
         *
         *
         * amazon
         *
         *
         *
         * amzn
         */
        var name: kotlin.String? = null
        /**
         * A list of SSM documents required by a document. This parameter is used exclusively by
         * AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also
         * specify a required document for validation purposes. In this case, an
         * ApplicationConfiguration document requires an
         * ApplicationConfigurationSchema document for validation purposes. For more
         * information, see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html">What is AppConfig? in the
         * AppConfig User Guide.
         */
        var requires: List<DocumentRequires>? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in
         * different ways, such as by purpose, owner, or environment. For example, you might want to tag an
         * SSM document to identify the types of targets or the environment where it will run. In this case,
         * you could specify the following key-value pairs:
         *
         *
         *
         * Key=OS,Value=Windows
         *
         *
         *
         * Key=Environment,Value=Production
         *
         *
         *
         * To add tags to an existing SSM document, use the AddTagsToResource
         * operation.
         */
        var tags: List<Tag>? = null
        /**
         * Specify a target type to define the kinds of resources the document can run on. For example,
         * to run a document on EC2 instances, specify the following value:
         * /AWS::EC2::Instance. If you specify a value of '/' the document can run on all types
         * of resources. If you don't specify a value, the document can't run on any resources. For a list
         * of valid resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and
         * property types reference in the CloudFormation User Guide.
         */
        var targetType: kotlin.String? = null
        /**
         * An optional field specifying the version of the artifact you are creating with the document.
         * For example, "Release 12, Update 6". This value is unique across all versions of a document, and
         * can't be changed.
         */
        var versionName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest) : this() {
            this.attachments = x.attachments
            this.content = x.content
            this.displayName = x.displayName
            this.documentFormat = x.documentFormat
            this.documentType = x.documentType
            this.name = x.name
            this.requires = x.requires
            this.tags = x.tags
            this.targetType = x.targetType
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateDocumentRequest = CreateDocumentRequest(this)
    }
}
