// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateOpsItemRequest private constructor(builder: Builder) {
    /**
     * The time a runbook workflow ended. Currently reported only for the OpsItem type
     * /aws/changerequest.
     */
    val actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualEndTime
    /**
     * The time a runbook workflow started. Currently reported only for the OpsItem type
     * /aws/changerequest.
     */
    val actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualStartTime
    /**
     * Specify a category to assign to an OpsItem.
     */
    val category: kotlin.String? = builder.category
    /**
     * Information about the OpsItem.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
     * OpsItem is edited or changed.
     */
    val notifications: List<OpsItemNotification>? = builder.notifications
    /**
     * Operational data is custom data that provides useful reference details about the OpsItem.
     * For example, you can specify log files, error strings, license keys, troubleshooting tips, or
     * other relevant data. You enter operational data as key-value pairs. The key has a maximum length
     * of 128 characters. The value has a maximum size of 20 KB.
     *
     * Operational data keys can't begin with the following:
     * amazon, aws, amzn, ssm,
     * /amazon, /aws, /amzn, /ssm.
     *
     * You can choose to make the data searchable by other users in the account or you can restrict
     * search access. Searchable data means that all users with access to the OpsItem Overview page (as
     * provided by the DescribeOpsItems API operation) can view and search on the
     * specified data. Operational data that isn't searchable is only viewable by users who have access
     * to the OpsItem (as provided by the GetOpsItem API operation).
     * Use the /aws/resources key in OperationalData to specify a related resource in
     * the request. Use the /aws/automations key in OperationalData to associate an
     * Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide.
     */
    val operationalData: Map<String, OpsItemDataValue>? = builder.operationalData
    /**
     * The type of OpsItem to create. Currently, the only valid values are
     * /aws/changerequest and /aws/issue.
     */
    val opsItemType: kotlin.String? = builder.opsItemType
    /**
     * The time specified in a change request for a runbook workflow to end. Currently supported
     * only for the OpsItem type /aws/changerequest.
     */
    val plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedEndTime
    /**
     * The time specified in a change request for a runbook workflow to start. Currently supported
     * only for the OpsItem type /aws/changerequest.
     */
    val plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedStartTime
    /**
     * The importance of this OpsItem in relation to other OpsItems in the system.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * One or more OpsItems that share something in common with the current OpsItems. For example,
     * related OpsItems can include OpsItems with similar error messages, impacted resources, or
     * statuses for the impacted resource.
     */
    val relatedOpsItems: List<RelatedOpsItem>? = builder.relatedOpsItems
    /**
     * Specify a severity to assign to an OpsItem.
     */
    val severity: kotlin.String? = builder.severity
    /**
     * The origin of the OpsItem, such as Amazon EC2 or Systems Manager.
     *
     * The source name can't contain the following strings: aws, amazon,
     * and amzn.
     */
    val source: kotlin.String? = builder.source
    /**
     * Optional metadata that you assign to a resource. You can restrict access to OpsItems by
     * using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide.
     * Tags use a key-value pair. For example:
     *
     * Key=Department,Value=Finance
     *
     * To add tags to a new OpsItem, a user must have IAM permissions for both the
     * ssm:CreateOpsItems operation and the ssm:AddTagsToResource operation.
     * To add tags to an existing OpsItem, use the AddTagsToResource
     * operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A short heading that describes the nature of the OpsItem and the impacted resource.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CreateOpsItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOpsItemRequest(")
        append("actualEndTime=$actualEndTime,")
        append("actualStartTime=$actualStartTime,")
        append("category=$category,")
        append("description=$description,")
        append("notifications=$notifications,")
        append("operationalData=$operationalData,")
        append("opsItemType=$opsItemType,")
        append("plannedEndTime=$plannedEndTime,")
        append("plannedStartTime=$plannedStartTime,")
        append("priority=$priority,")
        append("relatedOpsItems=$relatedOpsItems,")
        append("severity=$severity,")
        append("source=$source,")
        append("tags=$tags,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualEndTime?.hashCode() ?: 0
        result = 31 * result + (actualStartTime?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (notifications?.hashCode() ?: 0)
        result = 31 * result + (operationalData?.hashCode() ?: 0)
        result = 31 * result + (opsItemType?.hashCode() ?: 0)
        result = 31 * result + (plannedEndTime?.hashCode() ?: 0)
        result = 31 * result + (plannedStartTime?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (relatedOpsItems?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOpsItemRequest

        if (actualEndTime != other.actualEndTime) return false
        if (actualStartTime != other.actualStartTime) return false
        if (category != other.category) return false
        if (description != other.description) return false
        if (notifications != other.notifications) return false
        if (operationalData != other.operationalData) return false
        if (opsItemType != other.opsItemType) return false
        if (plannedEndTime != other.plannedEndTime) return false
        if (plannedStartTime != other.plannedStartTime) return false
        if (priority != other.priority) return false
        if (relatedOpsItems != other.relatedOpsItems) return false
        if (severity != other.severity) return false
        if (source != other.source) return false
        if (tags != other.tags) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CreateOpsItemRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time a runbook workflow ended. Currently reported only for the OpsItem type
         * /aws/changerequest.
         */
        var actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time a runbook workflow started. Currently reported only for the OpsItem type
         * /aws/changerequest.
         */
        var actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specify a category to assign to an OpsItem.
         */
        var category: kotlin.String? = null
        /**
         * Information about the OpsItem.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this
         * OpsItem is edited or changed.
         */
        var notifications: List<OpsItemNotification>? = null
        /**
         * Operational data is custom data that provides useful reference details about the OpsItem.
         * For example, you can specify log files, error strings, license keys, troubleshooting tips, or
         * other relevant data. You enter operational data as key-value pairs. The key has a maximum length
         * of 128 characters. The value has a maximum size of 20 KB.
         *
         * Operational data keys can't begin with the following:
         * amazon, aws, amzn, ssm,
         * /amazon, /aws, /amzn, /ssm.
         *
         * You can choose to make the data searchable by other users in the account or you can restrict
         * search access. Searchable data means that all users with access to the OpsItem Overview page (as
         * provided by the DescribeOpsItems API operation) can view and search on the
         * specified data. Operational data that isn't searchable is only viewable by users who have access
         * to the OpsItem (as provided by the GetOpsItem API operation).
         * Use the /aws/resources key in OperationalData to specify a related resource in
         * the request. Use the /aws/automations key in OperationalData to associate an
         * Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide.
         */
        var operationalData: Map<String, OpsItemDataValue>? = null
        /**
         * The type of OpsItem to create. Currently, the only valid values are
         * /aws/changerequest and /aws/issue.
         */
        var opsItemType: kotlin.String? = null
        /**
         * The time specified in a change request for a runbook workflow to end. Currently supported
         * only for the OpsItem type /aws/changerequest.
         */
        var plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time specified in a change request for a runbook workflow to start. Currently supported
         * only for the OpsItem type /aws/changerequest.
         */
        var plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The importance of this OpsItem in relation to other OpsItems in the system.
         */
        var priority: kotlin.Int? = null
        /**
         * One or more OpsItems that share something in common with the current OpsItems. For example,
         * related OpsItems can include OpsItems with similar error messages, impacted resources, or
         * statuses for the impacted resource.
         */
        var relatedOpsItems: List<RelatedOpsItem>? = null
        /**
         * Specify a severity to assign to an OpsItem.
         */
        var severity: kotlin.String? = null
        /**
         * The origin of the OpsItem, such as Amazon EC2 or Systems Manager.
         *
         * The source name can't contain the following strings: aws, amazon,
         * and amzn.
         */
        var source: kotlin.String? = null
        /**
         * Optional metadata that you assign to a resource. You can restrict access to OpsItems by
         * using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter in the Amazon Web Services Systems Manager User Guide.
         * Tags use a key-value pair. For example:
         *
         * Key=Department,Value=Finance
         *
         * To add tags to a new OpsItem, a user must have IAM permissions for both the
         * ssm:CreateOpsItems operation and the ssm:AddTagsToResource operation.
         * To add tags to an existing OpsItem, use the AddTagsToResource
         * operation.
         */
        var tags: List<Tag>? = null
        /**
         * A short heading that describes the nature of the OpsItem and the impacted resource.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CreateOpsItemRequest) : this() {
            this.actualEndTime = x.actualEndTime
            this.actualStartTime = x.actualStartTime
            this.category = x.category
            this.description = x.description
            this.notifications = x.notifications
            this.operationalData = x.operationalData
            this.opsItemType = x.opsItemType
            this.plannedEndTime = x.plannedEndTime
            this.plannedStartTime = x.plannedStartTime
            this.priority = x.priority
            this.relatedOpsItems = x.relatedOpsItems
            this.severity = x.severity
            this.source = x.source
            this.tags = x.tags
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CreateOpsItemRequest = CreateOpsItemRequest(this)
    }
}
