// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class DeleteInventoryRequest private constructor(builder: Builder) {
    /**
     * User-provided idempotency token.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Use this option to view a summary of the deletion request without deleting any data or the
     * data type. This option is useful when you only want to understand what will be deleted. Once you
     * validate that the data to be deleted is what you intend to delete, you can run the same command
     * without specifying the DryRun option.
     */
    val dryRun: kotlin.Boolean = builder.dryRun
    /**
     * Use the SchemaDeleteOption to delete a custom inventory type (schema). If you
     * don't choose this option, the system only deletes existing inventory data associated with the
     * custom inventory type. Choose one of the following options:
     * DisableSchema: If you choose this option, the system ignores all inventory data for the
     * specified version, and any earlier versions. To enable this schema again, you must call the
     * PutInventory operation for a version greater than the disabled version.
     * DeleteSchema: This option deletes the specified custom type from the Inventory service. You
     * can recreate the schema later, if you want.
     */
    val schemaDeleteOption: aws.sdk.kotlin.services.ssm.model.InventorySchemaDeleteOption? = builder.schemaDeleteOption
    /**
     * The name of the custom inventory type for which you want to delete either all previously
     * collected data or the inventory type itself.
     */
    val typeName: kotlin.String? = builder.typeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DeleteInventoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteInventoryRequest(")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("schemaDeleteOption=$schemaDeleteOption,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dryRun.hashCode())
        result = 31 * result + (schemaDeleteOption?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteInventoryRequest

        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (schemaDeleteOption != other.schemaDeleteOption) return false
        if (typeName != other.typeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DeleteInventoryRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * User-provided idempotency token.
         */
        var clientToken: kotlin.String? = null
        /**
         * Use this option to view a summary of the deletion request without deleting any data or the
         * data type. This option is useful when you only want to understand what will be deleted. Once you
         * validate that the data to be deleted is what you intend to delete, you can run the same command
         * without specifying the DryRun option.
         */
        var dryRun: kotlin.Boolean = false
        /**
         * Use the SchemaDeleteOption to delete a custom inventory type (schema). If you
         * don't choose this option, the system only deletes existing inventory data associated with the
         * custom inventory type. Choose one of the following options:
         * DisableSchema: If you choose this option, the system ignores all inventory data for the
         * specified version, and any earlier versions. To enable this schema again, you must call the
         * PutInventory operation for a version greater than the disabled version.
         * DeleteSchema: This option deletes the specified custom type from the Inventory service. You
         * can recreate the schema later, if you want.
         */
        var schemaDeleteOption: aws.sdk.kotlin.services.ssm.model.InventorySchemaDeleteOption? = null
        /**
         * The name of the custom inventory type for which you want to delete either all previously
         * collected data or the inventory type itself.
         */
        var typeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DeleteInventoryRequest) : this() {
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.schemaDeleteOption = x.schemaDeleteOption
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DeleteInventoryRequest = DeleteInventoryRequest(this)
    }
}
