// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * The EffectivePatch structure defines metadata about a patch along with the
 * approval state of the patch in a particular patch baseline. The approval state includes
 * information about whether the patch is currently approved, due to be approved by a rule,
 * explicitly approved, or explicitly rejected and the date the patch was or will be
 * approved.
 */
class EffectivePatch private constructor(builder: Builder) {
    /**
     * Provides metadata for a patch, including information such as the KB ID, severity,
     * classification and a URL for where more information can be obtained about the patch.
     */
    val patch: aws.sdk.kotlin.services.ssm.model.Patch? = builder.patch
    /**
     * The status of the patch in a patch baseline. This includes information about whether the
     * patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly
     * rejected and the date the patch was or will be approved.
     */
    val patchStatus: aws.sdk.kotlin.services.ssm.model.PatchStatus? = builder.patchStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.EffectivePatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EffectivePatch(")
        append("patch=$patch,")
        append("patchStatus=$patchStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = patch?.hashCode() ?: 0
        result = 31 * result + (patchStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EffectivePatch

        if (patch != other.patch) return false
        if (patchStatus != other.patchStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.EffectivePatch = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides metadata for a patch, including information such as the KB ID, severity,
         * classification and a URL for where more information can be obtained about the patch.
         */
        var patch: aws.sdk.kotlin.services.ssm.model.Patch? = null
        /**
         * The status of the patch in a patch baseline. This includes information about whether the
         * patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly
         * rejected and the date the patch was or will be approved.
         */
        var patchStatus: aws.sdk.kotlin.services.ssm.model.PatchStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.EffectivePatch) : this() {
            this.patch = x.patch
            this.patchStatus = x.patchStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.EffectivePatch = EffectivePatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.Patch] inside the given [block]
         */
        fun patch(block: aws.sdk.kotlin.services.ssm.model.Patch.Builder.() -> kotlin.Unit) {
            this.patch = aws.sdk.kotlin.services.ssm.model.Patch.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchStatus] inside the given [block]
         */
        fun patchStatus(block: aws.sdk.kotlin.services.ssm.model.PatchStatus.Builder.() -> kotlin.Unit) {
            this.patchStatus = aws.sdk.kotlin.services.ssm.model.PatchStatus.invoke(block)
        }
    }
}
