// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

class GetMaintenanceWindowExecutionTaskResponse private constructor(builder: Builder) {
    /**
     * The time the task execution completed.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The defined maximum number of task executions that could be run in parallel.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The defined maximum number of task execution errors allowed before scheduling of the task
     * execution would have been stopped.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The priority of the task.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * The role that was assumed when running the task.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The time the task execution started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task.
     */
    val status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = builder.status
    /**
     * The details explaining the status. Not available for all status values.
     */
    val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The Amazon Resource Name (ARN) of the task that ran.
     */
    val taskArn: kotlin.String? = builder.taskArn
    /**
     * The ID of the specific task execution in the maintenance window task that was
     * retrieved.
     */
    val taskExecutionId: kotlin.String? = builder.taskExecutionId
    /**
     * The parameters passed to the task when it was run.
     *
     *
     * TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
     * instead use the Parameters option in the TaskInvocationParameters structure. For information
     * about how Systems Manager handles these options for the supported maintenance window task
     * types, see MaintenanceWindowTaskInvocationParameters.
     *
     * The map has the following format:
     *
     *
     *
     * Key: string, between 1 and 255 characters
     *
     *
     * Value: an array of strings, each between 1 and 255 characters
     */
    val taskParameters: List<Map<String, MaintenanceWindowTaskParameterValueExpression>>? = builder.taskParameters
    /**
     * The type of task that was run.
     */
    val type: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.type
    /**
     * The ID of the maintenance window execution that includes the task.
     */
    val windowExecutionId: kotlin.String? = builder.windowExecutionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMaintenanceWindowExecutionTaskResponse(")
        append("endTime=$endTime,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("priority=$priority,")
        append("serviceRole=$serviceRole,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("taskArn=$taskArn,")
        append("taskExecutionId=$taskExecutionId,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("type=$type,")
        append("windowExecutionId=$windowExecutionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionId?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (windowExecutionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMaintenanceWindowExecutionTaskResponse

        if (endTime != other.endTime) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (priority != other.priority) return false
        if (serviceRole != other.serviceRole) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (taskArn != other.taskArn) return false
        if (taskExecutionId != other.taskExecutionId) return false
        if (taskParameters != other.taskParameters) return false
        if (type != other.type) return false
        if (windowExecutionId != other.windowExecutionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time the task execution completed.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The defined maximum number of task executions that could be run in parallel.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The defined maximum number of task execution errors allowed before scheduling of the task
         * execution would have been stopped.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The priority of the task.
         */
        var priority: kotlin.Int = 0
        /**
         * The role that was assumed when running the task.
         */
        var serviceRole: kotlin.String? = null
        /**
         * The time the task execution started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task.
         */
        var status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = null
        /**
         * The details explaining the status. Not available for all status values.
         */
        var statusDetails: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the task that ran.
         */
        var taskArn: kotlin.String? = null
        /**
         * The ID of the specific task execution in the maintenance window task that was
         * retrieved.
         */
        var taskExecutionId: kotlin.String? = null
        /**
         * The parameters passed to the task when it was run.
         *
         *
         * TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
         * instead use the Parameters option in the TaskInvocationParameters structure. For information
         * about how Systems Manager handles these options for the supported maintenance window task
         * types, see MaintenanceWindowTaskInvocationParameters.
         *
         * The map has the following format:
         *
         *
         *
         * Key: string, between 1 and 255 characters
         *
         *
         * Value: an array of strings, each between 1 and 255 characters
         */
        var taskParameters: List<Map<String, MaintenanceWindowTaskParameterValueExpression>>? = null
        /**
         * The type of task that was run.
         */
        var type: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The ID of the maintenance window execution that includes the task.
         */
        var windowExecutionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse) : this() {
            this.endTime = x.endTime
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.priority = x.priority
            this.serviceRole = x.serviceRole
            this.startTime = x.startTime
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.taskArn = x.taskArn
            this.taskExecutionId = x.taskExecutionId
            this.taskParameters = x.taskParameters
            this.type = x.type
            this.windowExecutionId = x.windowExecutionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = GetMaintenanceWindowExecutionTaskResponse(this)
    }
}
