// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class GetMaintenanceWindowTaskResponse private constructor(builder: Builder) {
    /**
     * The action to take on tasks when the maintenance window cutoff time is reached.
     * CONTINUE_TASK means that tasks continue to run. For Automation, Lambda, Step Functions tasks, CANCEL_TASK means that currently
     * running task invocations continue, but no new task invocations are started. For Run Command
     * tasks, CANCEL_TASK means the system attempts to stop the task by sending a
     * CancelCommand operation.
     */
    val cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = builder.cutoffBehavior
    /**
     * The retrieved task description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The location in Amazon Simple Storage Service (Amazon S3) where the task results are
     * logged.
     *
     *
     * LoggingInfo has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
     * OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters structure.
     * For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
     * window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    val loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = builder.loggingInfo
    /**
     * The maximum number of targets allowed to run this task in parallel.
     *
     * For maintenance window tasks without a target specified, you can't supply a value for this
     * option. Instead, the system inserts a placeholder value of 1, which may be reported
     * in the response to this command. This value doesn't affect the running of your task and can be
     * ignored.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The maximum number of errors allowed before the task stops being scheduled.
     *
     * For maintenance window tasks without a target specified, you can't supply a value for this
     * option. Instead, the system inserts a placeholder value of 1, which may be reported
     * in the response to this command. This value doesn't affect the running of your task and can be
     * ignored.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The retrieved task name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The priority of the task when it runs. The lower the number, the higher the priority. Tasks
     * that have the same priority are scheduled in parallel.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
     * (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The targets where the task should run.
     */
    val targets: List<Target>? = builder.targets
    /**
     * The resource that the task used during execution. For RUN_COMMAND and
     * AUTOMATION task types, the value of TaskArn is the SSM document
     * name/ARN. For LAMBDA tasks, the value is the function name/ARN. For
     * STEP_FUNCTIONS tasks, the value is the state machine ARN.
     */
    val taskArn: kotlin.String? = builder.taskArn
    /**
     * The parameters to pass to the task when it runs.
     */
    val taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = builder.taskInvocationParameters
    /**
     * The parameters to pass to the task when it runs.
     *
     *
     * TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
     * instead use the Parameters option in the TaskInvocationParameters structure. For information
     * about how Systems Manager handles these options for the supported maintenance window task
     * types, see MaintenanceWindowTaskInvocationParameters.
     */
    val taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = builder.taskParameters
    /**
     * The type of task to run.
     */
    val taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.taskType
    /**
     * The retrieved maintenance window ID.
     */
    val windowId: kotlin.String? = builder.windowId
    /**
     * The retrieved maintenance window task ID.
     */
    val windowTaskId: kotlin.String? = builder.windowTaskId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMaintenanceWindowTaskResponse(")
        append("cutoffBehavior=$cutoffBehavior,")
        append("description=*** Sensitive Data Redacted ***,")
        append("loggingInfo=$loggingInfo,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("priority=$priority,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targets=$targets,")
        append("taskArn=$taskArn,")
        append("taskInvocationParameters=$taskInvocationParameters,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("taskType=$taskType,")
        append("windowId=$windowId,")
        append("windowTaskId=$windowTaskId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cutoffBehavior?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskInvocationParameters?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (taskType?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        result = 31 * result + (windowTaskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMaintenanceWindowTaskResponse

        if (cutoffBehavior != other.cutoffBehavior) return false
        if (description != other.description) return false
        if (loggingInfo != other.loggingInfo) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targets != other.targets) return false
        if (taskArn != other.taskArn) return false
        if (taskInvocationParameters != other.taskInvocationParameters) return false
        if (taskParameters != other.taskParameters) return false
        if (taskType != other.taskType) return false
        if (windowId != other.windowId) return false
        if (windowTaskId != other.windowTaskId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowTaskResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action to take on tasks when the maintenance window cutoff time is reached.
         * CONTINUE_TASK means that tasks continue to run. For Automation, Lambda, Step Functions tasks, CANCEL_TASK means that currently
         * running task invocations continue, but no new task invocations are started. For Run Command
         * tasks, CANCEL_TASK means the system attempts to stop the task by sending a
         * CancelCommand operation.
         */
        var cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = null
        /**
         * The retrieved task description.
         */
        var description: kotlin.String? = null
        /**
         * The location in Amazon Simple Storage Service (Amazon S3) where the task results are
         * logged.
         *
         *
         * LoggingInfo has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
         * OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters structure.
         * For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
         * window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        var loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = null
        /**
         * The maximum number of targets allowed to run this task in parallel.
         *
         * For maintenance window tasks without a target specified, you can't supply a value for this
         * option. Instead, the system inserts a placeholder value of 1, which may be reported
         * in the response to this command. This value doesn't affect the running of your task and can be
         * ignored.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before the task stops being scheduled.
         *
         * For maintenance window tasks without a target specified, you can't supply a value for this
         * option. Instead, the system inserts a placeholder value of 1, which may be reported
         * in the response to this command. This value doesn't affect the running of your task and can be
         * ignored.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The retrieved task name.
         */
        var name: kotlin.String? = null
        /**
         * The priority of the task when it runs. The lower the number, the higher the priority. Tasks
         * that have the same priority are scheduled in parallel.
         */
        var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
         * (Amazon SNS) notifications for maintenance window Run Command tasks.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * The targets where the task should run.
         */
        var targets: List<Target>? = null
        /**
         * The resource that the task used during execution. For RUN_COMMAND and
         * AUTOMATION task types, the value of TaskArn is the SSM document
         * name/ARN. For LAMBDA tasks, the value is the function name/ARN. For
         * STEP_FUNCTIONS tasks, the value is the state machine ARN.
         */
        var taskArn: kotlin.String? = null
        /**
         * The parameters to pass to the task when it runs.
         */
        var taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = null
        /**
         * The parameters to pass to the task when it runs.
         *
         *
         * TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
         * instead use the Parameters option in the TaskInvocationParameters structure. For information
         * about how Systems Manager handles these options for the supported maintenance window task
         * types, see MaintenanceWindowTaskInvocationParameters.
         */
        var taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = null
        /**
         * The type of task to run.
         */
        var taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The retrieved maintenance window ID.
         */
        var windowId: kotlin.String? = null
        /**
         * The retrieved maintenance window task ID.
         */
        var windowTaskId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowTaskResponse) : this() {
            this.cutoffBehavior = x.cutoffBehavior
            this.description = x.description
            this.loggingInfo = x.loggingInfo
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.priority = x.priority
            this.serviceRoleArn = x.serviceRoleArn
            this.targets = x.targets
            this.taskArn = x.taskArn
            this.taskInvocationParameters = x.taskInvocationParameters
            this.taskParameters = x.taskParameters
            this.taskType = x.taskType
            this.windowId = x.windowId
            this.windowTaskId = x.windowTaskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowTaskResponse = GetMaintenanceWindowTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.LoggingInfo] inside the given [block]
         */
        fun loggingInfo(block: aws.sdk.kotlin.services.ssm.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.ssm.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters] inside the given [block]
         */
        fun taskInvocationParameters(block: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.Builder.() -> kotlin.Unit) {
            this.taskInvocationParameters = aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.invoke(block)
        }
    }
}
