// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines the high-level patch compliance state for a managed node, providing information
 * about the number of installed, missing, not applicable, and failed patches along with metadata
 * about the operation when this information was gathered for the managed node.
 */
class InstancePatchState private constructor(builder: Builder) {
    /**
     * The ID of the patch baseline used to patch the managed node.
     */
    val baselineId: kotlin.String? = builder.baselineId
    /**
     * The number of managed nodes where patches that are specified as Critical for
     * compliance reporting in the patch baseline aren't installed. These patches might be missing, have
     * failed installation, were rejected, or were installed but awaiting a required managed node
     * reboot. The status of these managed nodes is NON_COMPLIANT.
     */
    val criticalNonCompliantCount: kotlin.Int = builder.criticalNonCompliantCount
    /**
     * The number of patches from the patch baseline that were attempted to be installed during the
     * last patching operation, but failed to install.
     */
    val failedCount: kotlin.Int = builder.failedCount
    /**
     * An https URL or an Amazon Simple Storage Service (Amazon S3) path-style URL to a list of
     * patches to be installed. This patch installation list, which you maintain in an S3 bucket in YAML
     * format and specify in the SSM document AWS-RunPatchBaseline, overrides the patches
     * specified by the default patch baseline.
     * For more information about the InstallOverrideList parameter, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html">About the
     * AWS-RunPatchBaseline
     * SSM document in the
     * Amazon Web Services Systems Manager User Guide.
     */
    val installOverrideList: kotlin.String? = builder.installOverrideList
    /**
     * The number of patches from the patch baseline that are installed on the managed node.
     */
    val installedCount: kotlin.Int = builder.installedCount
    /**
     * The number of patches not specified in the patch baseline that are installed on the managed
     * node.
     */
    val installedOtherCount: kotlin.Int = builder.installedOtherCount
    /**
     * The number of patches installed by Patch Manager since the last time the managed node was
     * rebooted.
     */
    val installedPendingRebootCount: kotlin.Int = builder.installedPendingRebootCount
    /**
     * The number of patches installed on a managed node that are specified in a
     * RejectedPatches list. Patches with a status of InstalledRejected were
     * typically installed before they were added to a RejectedPatches list.
     *
     * If ALLOW_AS_DEPENDENCY is the specified option for
     * RejectedPatchesAction, the value of InstalledRejectedCount will
     * always be 0 (zero).
     */
    val installedRejectedCount: kotlin.Int = builder.installedRejectedCount
    /**
     * The ID of the managed node the high-level patch compliance information was collected
     * for.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The time of the last attempt to patch the managed node with NoReboot specified
     * as the reboot option.
     */
    val lastNoRebootInstallOperationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastNoRebootInstallOperationTime
    /**
     * The number of patches from the patch baseline that are applicable for the managed node but
     * aren't currently installed.
     */
    val missingCount: kotlin.Int = builder.missingCount
    /**
     * The number of patches from the patch baseline that aren't applicable for the managed node
     * and therefore aren't installed on the node. This number may be truncated if the list of patch
     * names is very large. The number of patches beyond this limit are reported in
     * UnreportedNotApplicableCount.
     */
    val notApplicableCount: kotlin.Int = builder.notApplicableCount
    /**
     * The type of patching operation that was performed: or
     *
     *
     *
     * SCAN assesses the patch compliance state.
     *
     *
     * INSTALL installs missing patches.
     */
    val operation: aws.sdk.kotlin.services.ssm.model.PatchOperationType? = builder.operation
    /**
     * The time the most recent patching operation completed on the managed node.
     */
    val operationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.operationEndTime
    /**
     * The time the most recent patching operation was started on the managed node.
     */
    val operationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.operationStartTime
    /**
     * The number of managed nodes with patches installed that are specified as other than
     * Critical or Security but aren't compliant with the patch baseline. The
     * status of these managed nodes is NON_COMPLIANT.
     */
    val otherNonCompliantCount: kotlin.Int = builder.otherNonCompliantCount
    /**
     * Placeholder information. This field will always be empty in the current release of the
     * service.
     */
    val ownerInformation: kotlin.String? = builder.ownerInformation
    /**
     * The name of the patch group the managed node belongs to.
     */
    val patchGroup: kotlin.String? = builder.patchGroup
    /**
     * Indicates the reboot option specified in the patch baseline.
     *
     * Reboot options apply to Install operations only. Reboots aren't attempted for
     * Patch Manager Scan operations.
     *
     *
     *
     * RebootIfNeeded: Patch Manager tries to reboot the managed node if it
     * installed any patches, or if any patches are detected with a status of
     * InstalledPendingReboot.
     *
     *
     * NoReboot: Patch Manager attempts to install missing packages without trying
     * to reboot the system. Patches installed with this option are assigned a status of
     * InstalledPendingReboot. These patches might not be in effect until a reboot is
     * performed.
     */
    val rebootOption: aws.sdk.kotlin.services.ssm.model.RebootOption? = builder.rebootOption
    /**
     * The number of managed nodes where patches that are specified as Security in a
     * patch advisory aren't installed. These patches might be missing, have failed installation, were
     * rejected, or were installed but awaiting a required managed node reboot. The status of these
     * managed nodes is NON_COMPLIANT.
     */
    val securityNonCompliantCount: kotlin.Int = builder.securityNonCompliantCount
    /**
     * The ID of the patch baseline snapshot used during the patching operation when this
     * compliance data was collected.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The number of patches beyond the supported limit of NotApplicableCount that
     * aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.
     */
    val unreportedNotApplicableCount: kotlin.Int = builder.unreportedNotApplicableCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstancePatchState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstancePatchState(")
        append("baselineId=$baselineId,")
        append("criticalNonCompliantCount=$criticalNonCompliantCount,")
        append("failedCount=$failedCount,")
        append("installOverrideList=$installOverrideList,")
        append("installedCount=$installedCount,")
        append("installedOtherCount=$installedOtherCount,")
        append("installedPendingRebootCount=$installedPendingRebootCount,")
        append("installedRejectedCount=$installedRejectedCount,")
        append("instanceId=$instanceId,")
        append("lastNoRebootInstallOperationTime=$lastNoRebootInstallOperationTime,")
        append("missingCount=$missingCount,")
        append("notApplicableCount=$notApplicableCount,")
        append("operation=$operation,")
        append("operationEndTime=$operationEndTime,")
        append("operationStartTime=$operationStartTime,")
        append("otherNonCompliantCount=$otherNonCompliantCount,")
        append("ownerInformation=*** Sensitive Data Redacted ***,")
        append("patchGroup=$patchGroup,")
        append("rebootOption=$rebootOption,")
        append("securityNonCompliantCount=$securityNonCompliantCount,")
        append("snapshotId=$snapshotId,")
        append("unreportedNotApplicableCount=$unreportedNotApplicableCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baselineId?.hashCode() ?: 0
        result = 31 * result + (criticalNonCompliantCount)
        result = 31 * result + (failedCount)
        result = 31 * result + (installOverrideList?.hashCode() ?: 0)
        result = 31 * result + (installedCount)
        result = 31 * result + (installedOtherCount)
        result = 31 * result + (installedPendingRebootCount)
        result = 31 * result + (installedRejectedCount)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (lastNoRebootInstallOperationTime?.hashCode() ?: 0)
        result = 31 * result + (missingCount)
        result = 31 * result + (notApplicableCount)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (operationEndTime?.hashCode() ?: 0)
        result = 31 * result + (operationStartTime?.hashCode() ?: 0)
        result = 31 * result + (otherNonCompliantCount)
        result = 31 * result + (ownerInformation?.hashCode() ?: 0)
        result = 31 * result + (patchGroup?.hashCode() ?: 0)
        result = 31 * result + (rebootOption?.hashCode() ?: 0)
        result = 31 * result + (securityNonCompliantCount)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (unreportedNotApplicableCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstancePatchState

        if (baselineId != other.baselineId) return false
        if (criticalNonCompliantCount != other.criticalNonCompliantCount) return false
        if (failedCount != other.failedCount) return false
        if (installOverrideList != other.installOverrideList) return false
        if (installedCount != other.installedCount) return false
        if (installedOtherCount != other.installedOtherCount) return false
        if (installedPendingRebootCount != other.installedPendingRebootCount) return false
        if (installedRejectedCount != other.installedRejectedCount) return false
        if (instanceId != other.instanceId) return false
        if (lastNoRebootInstallOperationTime != other.lastNoRebootInstallOperationTime) return false
        if (missingCount != other.missingCount) return false
        if (notApplicableCount != other.notApplicableCount) return false
        if (operation != other.operation) return false
        if (operationEndTime != other.operationEndTime) return false
        if (operationStartTime != other.operationStartTime) return false
        if (otherNonCompliantCount != other.otherNonCompliantCount) return false
        if (ownerInformation != other.ownerInformation) return false
        if (patchGroup != other.patchGroup) return false
        if (rebootOption != other.rebootOption) return false
        if (securityNonCompliantCount != other.securityNonCompliantCount) return false
        if (snapshotId != other.snapshotId) return false
        if (unreportedNotApplicableCount != other.unreportedNotApplicableCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstancePatchState = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the patch baseline used to patch the managed node.
         */
        var baselineId: kotlin.String? = null
        /**
         * The number of managed nodes where patches that are specified as Critical for
         * compliance reporting in the patch baseline aren't installed. These patches might be missing, have
         * failed installation, were rejected, or were installed but awaiting a required managed node
         * reboot. The status of these managed nodes is NON_COMPLIANT.
         */
        var criticalNonCompliantCount: kotlin.Int = 0
        /**
         * The number of patches from the patch baseline that were attempted to be installed during the
         * last patching operation, but failed to install.
         */
        var failedCount: kotlin.Int = 0
        /**
         * An https URL or an Amazon Simple Storage Service (Amazon S3) path-style URL to a list of
         * patches to be installed. This patch installation list, which you maintain in an S3 bucket in YAML
         * format and specify in the SSM document AWS-RunPatchBaseline, overrides the patches
         * specified by the default patch baseline.
         * For more information about the InstallOverrideList parameter, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html">About the
         * AWS-RunPatchBaseline
         * SSM document in the
         * Amazon Web Services Systems Manager User Guide.
         */
        var installOverrideList: kotlin.String? = null
        /**
         * The number of patches from the patch baseline that are installed on the managed node.
         */
        var installedCount: kotlin.Int = 0
        /**
         * The number of patches not specified in the patch baseline that are installed on the managed
         * node.
         */
        var installedOtherCount: kotlin.Int = 0
        /**
         * The number of patches installed by Patch Manager since the last time the managed node was
         * rebooted.
         */
        var installedPendingRebootCount: kotlin.Int = 0
        /**
         * The number of patches installed on a managed node that are specified in a
         * RejectedPatches list. Patches with a status of InstalledRejected were
         * typically installed before they were added to a RejectedPatches list.
         *
         * If ALLOW_AS_DEPENDENCY is the specified option for
         * RejectedPatchesAction, the value of InstalledRejectedCount will
         * always be 0 (zero).
         */
        var installedRejectedCount: kotlin.Int = 0
        /**
         * The ID of the managed node the high-level patch compliance information was collected
         * for.
         */
        var instanceId: kotlin.String? = null
        /**
         * The time of the last attempt to patch the managed node with NoReboot specified
         * as the reboot option.
         */
        var lastNoRebootInstallOperationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of patches from the patch baseline that are applicable for the managed node but
         * aren't currently installed.
         */
        var missingCount: kotlin.Int = 0
        /**
         * The number of patches from the patch baseline that aren't applicable for the managed node
         * and therefore aren't installed on the node. This number may be truncated if the list of patch
         * names is very large. The number of patches beyond this limit are reported in
         * UnreportedNotApplicableCount.
         */
        var notApplicableCount: kotlin.Int = 0
        /**
         * The type of patching operation that was performed: or
         *
         *
         *
         * SCAN assesses the patch compliance state.
         *
         *
         * INSTALL installs missing patches.
         */
        var operation: aws.sdk.kotlin.services.ssm.model.PatchOperationType? = null
        /**
         * The time the most recent patching operation completed on the managed node.
         */
        var operationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the most recent patching operation was started on the managed node.
         */
        var operationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of managed nodes with patches installed that are specified as other than
         * Critical or Security but aren't compliant with the patch baseline. The
         * status of these managed nodes is NON_COMPLIANT.
         */
        var otherNonCompliantCount: kotlin.Int = 0
        /**
         * Placeholder information. This field will always be empty in the current release of the
         * service.
         */
        var ownerInformation: kotlin.String? = null
        /**
         * The name of the patch group the managed node belongs to.
         */
        var patchGroup: kotlin.String? = null
        /**
         * Indicates the reboot option specified in the patch baseline.
         *
         * Reboot options apply to Install operations only. Reboots aren't attempted for
         * Patch Manager Scan operations.
         *
         *
         *
         * RebootIfNeeded: Patch Manager tries to reboot the managed node if it
         * installed any patches, or if any patches are detected with a status of
         * InstalledPendingReboot.
         *
         *
         * NoReboot: Patch Manager attempts to install missing packages without trying
         * to reboot the system. Patches installed with this option are assigned a status of
         * InstalledPendingReboot. These patches might not be in effect until a reboot is
         * performed.
         */
        var rebootOption: aws.sdk.kotlin.services.ssm.model.RebootOption? = null
        /**
         * The number of managed nodes where patches that are specified as Security in a
         * patch advisory aren't installed. These patches might be missing, have failed installation, were
         * rejected, or were installed but awaiting a required managed node reboot. The status of these
         * managed nodes is NON_COMPLIANT.
         */
        var securityNonCompliantCount: kotlin.Int = 0
        /**
         * The ID of the patch baseline snapshot used during the patching operation when this
         * compliance data was collected.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The number of patches beyond the supported limit of NotApplicableCount that
         * aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.
         */
        var unreportedNotApplicableCount: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstancePatchState) : this() {
            this.baselineId = x.baselineId
            this.criticalNonCompliantCount = x.criticalNonCompliantCount
            this.failedCount = x.failedCount
            this.installOverrideList = x.installOverrideList
            this.installedCount = x.installedCount
            this.installedOtherCount = x.installedOtherCount
            this.installedPendingRebootCount = x.installedPendingRebootCount
            this.installedRejectedCount = x.installedRejectedCount
            this.instanceId = x.instanceId
            this.lastNoRebootInstallOperationTime = x.lastNoRebootInstallOperationTime
            this.missingCount = x.missingCount
            this.notApplicableCount = x.notApplicableCount
            this.operation = x.operation
            this.operationEndTime = x.operationEndTime
            this.operationStartTime = x.operationStartTime
            this.otherNonCompliantCount = x.otherNonCompliantCount
            this.ownerInformation = x.ownerInformation
            this.patchGroup = x.patchGroup
            this.rebootOption = x.rebootOption
            this.securityNonCompliantCount = x.securityNonCompliantCount
            this.snapshotId = x.snapshotId
            this.unreportedNotApplicableCount = x.unreportedNotApplicableCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstancePatchState = InstancePatchState(this)
    }
}
