// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * The inventory result item.
 */
class InventoryResultItem private constructor(builder: Builder) {
    /**
     * The time inventory item data was captured.
     */
    val captureTime: kotlin.String? = builder.captureTime
    /**
     * Contains all the inventory data of the item type. Results include attribute names and
     * values.
     */
    val content: List<Map<String, String>>? = builder.content
    /**
     * MD5 hash of the inventory item type contents. The content hash is used to determine whether
     * to update inventory information. The PutInventory API doesn't update the inventory item type
     * contents if the MD5 hash hasn't changed since last update.
     */
    val contentHash: kotlin.String? = builder.contentHash
    /**
     * The schema version for the inventory result item/
     */
    val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The name of the inventory result item type.
     */
    val typeName: kotlin.String? = builder.typeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InventoryResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryResultItem(")
        append("captureTime=$captureTime,")
        append("content=$content,")
        append("contentHash=$contentHash,")
        append("schemaVersion=$schemaVersion,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = captureTime?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentHash?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryResultItem

        if (captureTime != other.captureTime) return false
        if (content != other.content) return false
        if (contentHash != other.contentHash) return false
        if (schemaVersion != other.schemaVersion) return false
        if (typeName != other.typeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InventoryResultItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time inventory item data was captured.
         */
        var captureTime: kotlin.String? = null
        /**
         * Contains all the inventory data of the item type. Results include attribute names and
         * values.
         */
        var content: List<Map<String, String>>? = null
        /**
         * MD5 hash of the inventory item type contents. The content hash is used to determine whether
         * to update inventory information. The PutInventory API doesn't update the inventory item type
         * contents if the MD5 hash hasn't changed since last update.
         */
        var contentHash: kotlin.String? = null
        /**
         * The schema version for the inventory result item/
         */
        var schemaVersion: kotlin.String? = null
        /**
         * The name of the inventory result item type.
         */
        var typeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InventoryResultItem) : this() {
            this.captureTime = x.captureTime
            this.content = x.content
            this.contentHash = x.contentHash
            this.schemaVersion = x.schemaVersion
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InventoryResultItem = InventoryResultItem(this)
    }
}
